/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.android.tools.adtui.validation.ErrorDetailDialog;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.validators.TrueValidator;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.SwingHelper;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class ValidatorPanel
extends JPanel
implements Disposable {
    private static final String BLANK_HTML = "<html></html>";
    private final ListenerManager myListeners;
    private final List<Validator.Result> myResults;
    private final ObjectProperty<Validator.Result> myValidationResult;
    private final BooleanExpression myHasErrorsExpression;
    private JPanel myRootPanel;
    private JPanel mySouthPanel;
    private JBLabel mySeverityIcon;
    private JEditorPane myValidationText;
    private ErrorDetailDialog myErrorDetailDialog;

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel, @NotNull String errorDetailDialogTitle, @NotNull String errorDetailHeader) {
        if (parentDisposable == null) {
            ValidatorPanel.$$$reportNull$$$0(0);
        }
        if (innerPanel == null) {
            ValidatorPanel.$$$reportNull$$$0(1);
        }
        if (errorDetailDialogTitle == null) {
            ValidatorPanel.$$$reportNull$$$0(2);
        }
        if (errorDetailHeader == null) {
            ValidatorPanel.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myResults = new ArrayList<Validator.Result>();
        this.myValidationResult = new ObjectValueProperty((Object)Validator.Result.OK);
        this.myHasErrorsExpression = new BooleanExpression(new ObservableValue[]{this.myValidationResult}){

            @NotNull
            public Boolean get() {
                Boolean bl = ((Validator.Result)ValidatorPanel.this.myValidationResult.get()).getSeverity() == Validator.Severity.ERROR;
                if (bl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/validation/ValidatorPanel$1", "get"));
            }
        };
        this.add(this.myRootPanel);
        this.myRootPanel.add(innerPanel);
        this.myValidationText.setName("ValidationText");
        this.myValidationText.setText(BLANK_HTML);
        this.myValidationText.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String detailedMessage = ((Validator.Result)this.myValidationResult.get()).getDetailedMessage();
                if (this.myErrorDetailDialog == null) {
                    this.myErrorDetailDialog = new ErrorDetailDialog(errorDetailDialogTitle, errorDetailHeader, detailedMessage);
                    Disposer.register((Disposable)this.myErrorDetailDialog.getDisposable(), () -> {
                        this.myErrorDetailDialog = null;
                    });
                    Disposer.register((Disposable)this, () -> {
                        if (this.myErrorDetailDialog != null) {
                            this.myErrorDetailDialog.close(1);
                        }
                    });
                    this.myErrorDetailDialog.show();
                } else {
                    this.myErrorDetailDialog.setText(detailedMessage);
                }
            }
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel) {
        if (parentDisposable == null) {
            ValidatorPanel.$$$reportNull$$$0(4);
        }
        if (innerPanel == null) {
            ValidatorPanel.$$$reportNull$$$0(5);
        }
        this(parentDisposable, innerPanel, "Errors", "Error Details:");
    }

    public <T> void registerValidator(@NotNull ObservableValue<T> value, @NotNull Validator<? super T> validator, ObservableValue<?> ... dependencies) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(6);
        }
        if (validator == null) {
            ValidatorPanel.$$$reportNull$$$0(7);
        }
        if (dependencies == null) {
            ValidatorPanel.$$$reportNull$$$0(8);
        }
        ArrayList triggerObjects = Lists.newArrayList((Object[])new ObservableValue[]{value});
        if (dependencies.length > 0) {
            triggerObjects.addAll(Arrays.asList(dependencies));
        }
        int index = this.myResults.size();
        this.myResults.add(Validator.Result.OK);
        this.myListeners.listenAll((Collection)triggerObjects).withAndFire(() -> {
            Validator.Result oldValue = this.myResults.get(index);
            Validator.Result newValue = validator.validate(value.get());
            if (!newValue.equals(oldValue)) {
                this.myResults.set(index, newValue);
                this.updateActiveValidationResult();
            }
        });
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull Validator.Severity severity, @NotNull String message) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(9);
        }
        if (severity == null) {
            ValidatorPanel.$$$reportNull$$$0(10);
        }
        if (message == null) {
            ValidatorPanel.$$$reportNull$$$0(11);
        }
        this.registerValidator(value, new TrueValidator(severity, message), new ObservableValue[0]);
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull String message) {
        if (value == null) {
            ValidatorPanel.$$$reportNull$$$0(12);
        }
        if (message == null) {
            ValidatorPanel.$$$reportNull$$$0(13);
        }
        this.registerTest(value, Validator.Severity.ERROR, message);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message, @NotNull Validator.Severity severity) {
        if (message == null) {
            ValidatorPanel.$$$reportNull$$$0(14);
        }
        if (severity == null) {
            ValidatorPanel.$$$reportNull$$$0(15);
        }
        this.registerValidator(message, value -> {
            if (value.isEmpty()) {
                return Validator.Result.OK;
            }
            return new Validator.Result(severity, (String)value);
        }, new ObservableValue[0]);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message) {
        if (message == null) {
            ValidatorPanel.$$$reportNull$$$0(16);
        }
        this.registerMessageSource(message, Validator.Severity.ERROR);
    }

    @NotNull
    public ObservableBool hasErrors() {
        BooleanExpression booleanExpression = this.myHasErrorsExpression;
        if (booleanExpression == null) {
            ValidatorPanel.$$$reportNull$$$0(17);
        }
        return booleanExpression;
    }

    @NotNull
    public ObservableValue<Validator.Result> getValidationResult() {
        ObjectProperty<Validator.Result> objectProperty = this.myValidationResult;
        if (objectProperty == null) {
            ValidatorPanel.$$$reportNull$$$0(18);
        }
        return objectProperty;
    }

    private void updateActiveValidationResult() {
        Validator.Result activeResult = Validator.Result.OK;
        for (Validator.Result result : this.myResults) {
            if (result.getSeverity().compareTo(activeResult.getSeverity()) > 0 && (activeResult = result).getSeverity() == Validator.Severity.ERROR) break;
        }
        if (activeResult.getSeverity() == Validator.Severity.OK) {
            this.mySeverityIcon.setIcon(null);
            this.myValidationText.setText(BLANK_HTML);
        } else {
            this.mySeverityIcon.setIcon(activeResult.getSeverity().getIcon());
            String message = activeResult.getMessage().trim();
            if (!XmlStringUtil.isWrappedInHtml((String)message)) {
                message = !StringUtil.isEmpty((String)activeResult.getDetailedMessage()) ? XmlStringUtil.wrapInHtml((CharSequence)("<a href=\"details\">" + ValidatorPanel.convertToHtml(message) + "</a>")) : XmlStringUtil.wrapInHtml((CharSequence)ValidatorPanel.convertToHtml(message));
            }
            this.myValidationText.setText(message);
        }
        this.myValidationResult.set((Object)activeResult);
    }

    @NotNull
    private static String convertToHtml(String message) {
        String string = StringUtil.replace((String)XmlStringUtil.escapeString((String)message), (String)"\n", (String)"<br>");
        if (string == null) {
            ValidatorPanel.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void dispose() {
        this.myListeners.releaseAll();
    }

    @TestOnly
    @NotNull
    public JEditorPane getValidationText() {
        JEditorPane jEditorPane = this.myValidationText;
        if (jEditorPane == null) {
            ValidatorPanel.$$$reportNull$$$0(20);
        }
        return jEditorPane;
    }

    private void createUIComponents() {
        this.myValidationText = SwingHelper.createHtmlViewer((boolean)true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
        this.myValidationText.setOpaque(false);
        this.myValidationText.setFocusable(false);
        this.myValidationText.addHyperlinkListener(event -> {});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorDetailDialogTitle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorDetailHeader";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/validation/ValidatorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/validation/ValidatorPanel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "hasErrors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationResult";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToHtml";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerValidator";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerTest";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerMessageSource";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 15));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(154, 32));
        jPanel.setPreferredSize(new Dimension(154, 32));
        jPanel2.add((Component)jPanel, "South");
        this.mySeverityIcon = jBLabel = new JBLabel();
        jBLabel.setFocusable(false);
        jBLabel.setIconTextGap(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 1, 0, 1, 0, null, null, null));
        JEditorPane jEditorPane = this.myValidationText;
        ((Component)jEditorPane).setBackground(new Color(-855310));
        jEditorPane.setEditable(false);
        jEditorPane.setFocusable(false);
        jEditorPane.setMargin(new Insets(0, 0, 0, 0));
        jEditorPane.setText("");
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 1, 1, 1, 0, 3, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

