/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MissingTranslationsInspectionProvider
implements InconsistentResourceBundleInspectionProvider {
    @Override
    @NotNull
    public String getName() {
        return "REPORT_MISSING_TRANSLATIONS";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = JavaI18nBundle.message("inconsistent.bundle.report.missing.translations", new Object[0]);
        if (string == null) {
            MissingTranslationsInspectionProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void check(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<? extends PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, Map<PropertiesFile, Map<String, String>> propertiesFilesNamesMaps, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile propertiesFile : files) {
            boolean isLeaf;
            PropertiesFile parent = (PropertiesFile)parents.get((Object)propertiesFile);
            if (parent == null) continue;
            List children = parents.getKeysByValue((Object)propertiesFile);
            boolean bl = isLeaf = children == null || children.isEmpty();
            if (!isLeaf) continue;
            THashSet keys = propertiesFilesNamesMaps.get(propertiesFile).keySet();
            THashSet parentKeys = new THashSet((Collection)keysUpToParent.get(parent));
            if (parent.getLocale().getLanguage().equals(propertiesFile.getLocale().getLanguage())) {
                keys = new THashSet(keys);
                keys.addAll(propertiesFilesNamesMaps.get(parent).keySet());
                parent = (PropertiesFile)parents.get((Object)parent);
                if (parent == null) continue;
                parentKeys = new THashSet((Collection)keysUpToParent.get(parent));
            }
            parentKeys.removeAll((Collection<?>)keys);
            for (String untranslatedKey : parentKeys) {
                IProperty untranslatedProperty = null;
                PropertiesFile untranslatedFile = parent;
                while (untranslatedFile != null && (untranslatedProperty = untranslatedFile.findPropertyByKey(untranslatedKey)) == null) {
                    untranslatedFile = (PropertiesFile)parents.get((Object)untranslatedFile);
                }
                assert (untranslatedProperty != null);
                String message = JavaI18nBundle.message("inconsistent.bundle.untranslated.property.error", untranslatedKey, propertiesFile.getName());
                ProblemDescriptor descriptor = manager.createProblemDescriptor(untranslatedProperty.getPsiElement(), message, false, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)untranslatedFile.getContainingFile()), new CommonProblemDescriptor[]{descriptor});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/inconsistentResourceBundle/MissingTranslationsInspectionProvider", "getPresentableName"));
    }
}

