/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.psi.PsiFile;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulatorKt;
import org.jetbrains.kotlin.idea.configuration.GradleModuleBuilderUtilsKt;
import org.jetbrains.kotlin.idea.configuration.GradlePropertiesFileFacade;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleFrameworkSupportInModuleConfigurable;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.configuration.SettingsScriptBuilder;
import org.jetbrains.kotlin.idea.formatter.KotlinPredefinedCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;
import org.jetbrains.kotlin.idea.projectWizard.WizardStatsService;
import org.jetbrains.kotlin.idea.util.VersioningKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleFrameworkSupportProvider;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J6\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H$J\b\u0010\"\u001a\u00020\u0003H%J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0003H%J\b\u0010&\u001a\u00020\u0003H%J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0014J \u0010(\u001a\u00020\u000e2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinFrameworkSupportProvider;", "Lorg/jetbrains/plugins/gradle/frameworkSupport/GradleFrameworkSupportProvider;", "frameworkTypeId", "", "displayName", "frameworkIcon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "getDisplayName", "()Ljava/lang/String;", "getFrameworkIcon", "()Ljavax/swing/Icon;", "getFrameworkTypeId", "addSupport", "", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "modifiableModelsProvider", "Lcom/intellij/openapi/roots/ModifiableModelsProvider;", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "specifyPluginVersionIfNeeded", "", "explicitPluginVersion", "createConfigurable", "Lcom/intellij/framework/addSupport/FrameworkSupportInModuleConfigurable;", "model", "Lcom/intellij/ide/util/frameworkSupport/FrameworkSupportModel;", "getDependencies", "", "getDescription", "getFrameworkType", "Lcom/intellij/framework/FrameworkTypeEx;", "getPluginExpression", "getPluginId", "getTestDependencies", "updateSettingsScript", "settingsBuilder", "Lorg/jetbrains/kotlin/idea/configuration/SettingsScriptBuilder;", "Lcom/intellij/psi/PsiFile;", "kotlin.gradle.gradle-idea"})
public abstract class GradleKotlinFrameworkSupportProvider
extends GradleFrameworkSupportProvider {
    @NotNull
    private final String frameworkTypeId;
    @NotNull
    private final String displayName;
    @NotNull
    private final Icon frameworkIcon;

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        return new FrameworkTypeEx(this, this.frameworkTypeId){
            final /* synthetic */ GradleKotlinFrameworkSupportProvider this$0;

            @NotNull
            public Icon getIcon() {
                return this.this$0.getFrameworkIcon();
            }

            @NotNull
            public String getPresentableName() {
                return this.this$0.getDisplayName();
            }

            @NotNull
            public FrameworkSupportInModuleProvider createProvider() {
                return (FrameworkSupportInModuleProvider)this.this$0;
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        KotlinGradleFrameworkSupportInModuleConfigurable configurable = new KotlinGradleFrameworkSupportInModuleConfigurable(model, this);
        return new FrameworkSupportInModuleConfigurable(this, configurable){
            final /* synthetic */ GradleKotlinFrameworkSupportProvider this$0;
            final /* synthetic */ KotlinGradleFrameworkSupportInModuleConfigurable $configurable;

            public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
                Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
                this.$configurable.addSupport(module, rootModel, modifiableModelsProvider);
            }

            @NotNull
            public JComponent createComponent() {
                JTextPane jTextPane = new JTextPane();
                jTextPane.setText(this.this$0.getDescription());
                return jTextPane;
            }
            {
                this.this$0 = this$0;
                this.$configurable = $captured_local_variable$1;
            }
        };
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkNotNullParameter((Object)buildScriptData, (String)"buildScriptData");
        GradleKotlinFrameworkSupportProvider.addSupport$default(this, buildScriptData, module, rootModel.getSdk(), true, null, 16, null);
    }

    public void addSupport(@NotNull BuildScriptDataBuilder buildScriptData, @NotNull Module module, @Nullable Sdk sdk, boolean specifyPluginVersionIfNeeded, @Nullable String explicitPluginVersion) {
        String oneLineRepository;
        boolean useNewSyntax2;
        Intrinsics.checkNotNullParameter((Object)buildScriptData, (String)"buildScriptData");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = explicitPluginVersion;
        if (string == null) {
            string = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
        }
        String kotlinVersion2 = string;
        RepositoryDescription additionalRepository = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion((String)kotlinVersion2);
        if (VersioningKt.isSnapshot((String)kotlinVersion2)) {
            kotlinVersion2 = "1.4.255-SNAPSHOT";
        }
        GradleVersion gradleVersion = buildScriptData.getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"buildScriptData.gradleVersion");
        GradleVersion gradleVersion2 = gradleVersion;
        boolean bl = useNewSyntax2 = gradleVersion2.compareTo(GradleBuildScriptManipulatorKt.getMIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX()) >= 0;
        if (useNewSyntax2) {
            if (additionalRepository != null) {
                oneLineRepository = StringsKt.replace$default((String)ConfigureKotlinInProjectUtilsKt.toGroovyRepositorySnippet((RepositoryDescription)additionalRepository), (char)'\n', (char)' ', (boolean)false, (int)4, null);
                GradleModuleBuilderUtilsKt.updateSettingsScript(module, (Function1<? super SettingsScriptBuilder<? extends PsiFile>, Unit>)((Function1)new Function1<SettingsScriptBuilder<? extends PsiFile>, Unit>(additionalRepository){
                    final /* synthetic */ RepositoryDescription $additionalRepository;

                    public final void invoke(@NotNull SettingsScriptBuilder<? extends PsiFile> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        boolean bl = false;
                        boolean bl2 = false;
                        SettingsScriptBuilder<? extends PsiFile> $this$with = it;
                        boolean bl3 = false;
                        $this$with.addPluginRepository(this.$additionalRepository);
                        $this$with.addMavenCentralPluginRepository();
                        $this$with.addPluginRepository(ConfigureKotlinInProjectUtilsKt.getDEFAULT_GRADLE_PLUGIN_REPOSITORY());
                    }
                    {
                        this.$additionalRepository = repositoryDescription;
                        super(1);
                    }
                }));
                buildScriptData.addRepositoriesDefinition("mavenCentral()");
                buildScriptData.addRepositoriesDefinition(oneLineRepository);
            }
            buildScriptData.addPluginDefinitionInPluginsGroup(this.getPluginExpression() + (specifyPluginVersionIfNeeded ? " version '" + kotlinVersion2 + '\'' : ""));
        } else {
            if (additionalRepository != null) {
                oneLineRepository = StringsKt.replace$default((String)ConfigureKotlinInProjectUtilsKt.toGroovyRepositorySnippet((RepositoryDescription)additionalRepository), (char)'\n', (char)' ', (boolean)false, (int)4, null);
                buildScriptData.addBuildscriptRepositoriesDefinition(oneLineRepository);
                buildScriptData.addRepositoriesDefinition("mavenCentral()");
                buildScriptData.addRepositoriesDefinition(oneLineRepository);
            }
            buildScriptData.addPluginDefinition(KotlinWithGradleConfigurator.Companion.getGroovyApplyPluginDirective(this.getPluginId())).addBuildscriptRepositoriesDefinition("mavenCentral()").addBuildscriptPropertyDefinition("ext.kotlin_version = '" + kotlinVersion2 + '\'');
        }
        buildScriptData.addRepositoriesDefinition("mavenCentral()");
        for (String dependency : this.getDependencies(sdk)) {
            buildScriptData.addDependencyNotation(KotlinWithGradleConfigurator.Companion.getGroovyDependencySnippet(dependency, "implementation", !useNewSyntax2, gradleVersion2));
        }
        for (String dependency : this.getTestDependencies()) {
            buildScriptData.addDependencyNotation(StringsKt.contains$default((CharSequence)dependency, (CharSequence)":", (boolean)false, (int)2, null) ? GradleBuildScriptManipulatorKt.scope(gradleVersion2, "testImplementation") + " \"" + dependency + '\"' : KotlinWithGradleConfigurator.Companion.getGroovyDependencySnippet(dependency, "testImplementation", !useNewSyntax2, gradleVersion2));
        }
        if (useNewSyntax2) {
            GradleModuleBuilderUtilsKt.updateSettingsScript(module, (Function1<? super SettingsScriptBuilder<? extends PsiFile>, Unit>)((Function1)new Function1<SettingsScriptBuilder<? extends PsiFile>, Unit>(this, specifyPluginVersionIfNeeded){
                final /* synthetic */ GradleKotlinFrameworkSupportProvider this$0;
                final /* synthetic */ boolean $specifyPluginVersionIfNeeded;

                public final void invoke(@NotNull SettingsScriptBuilder<? extends PsiFile> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.this$0.updateSettingsScript(it, this.$specifyPluginVersionIfNeeded);
                }
                {
                    this.this$0 = gradleKotlinFrameworkSupportProvider;
                    this.$specifyPluginVersionIfNeeded = bl;
                    super(1);
                }
            }));
        } else {
            buildScriptData.addBuildscriptDependencyNotation("classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"");
        }
        boolean isNewProject = Intrinsics.areEqual((Object)((Boolean)module.getProject().getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT)), (Object)true);
        if (isNewProject) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            ProjectCodeStyleImporter.INSTANCE.apply(project, (KotlinPredefinedCodeStyle)KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
            GradlePropertiesFileFacade.Companion.forProject(project2).addCodeStyleProperty("official");
        }
        String string2 = this.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.presentableName");
        WizardStatsService.ProjectCreationStats projectCreationStats = new WizardStatsService.ProjectCreationStats("Gradle", string2, "gradleGroovy", null, 8, null);
        WizardStatsService.Companion.logDataOnProjectGenerated(null, module.getProject(), projectCreationStats);
    }

    public static /* synthetic */ void addSupport$default(GradleKotlinFrameworkSupportProvider gradleKotlinFrameworkSupportProvider, BuildScriptDataBuilder buildScriptDataBuilder, Module module, Sdk sdk, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSupport");
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        gradleKotlinFrameworkSupportProvider.addSupport(buildScriptDataBuilder, module, sdk, bl, string);
    }

    protected void updateSettingsScript(@NotNull SettingsScriptBuilder<? extends PsiFile> settingsBuilder, boolean specifyPluginVersionIfNeeded) {
        Intrinsics.checkNotNullParameter(settingsBuilder, (String)"settingsBuilder");
    }

    @NotNull
    protected abstract List<String> getDependencies(@Nullable Sdk var1);

    @NotNull
    protected List<String> getTestDependencies() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @NonNls
    @NotNull
    protected abstract String getPluginId();

    @NonNls
    @NotNull
    protected abstract String getPluginExpression();

    @Nls
    @NotNull
    protected abstract String getDescription();

    @NotNull
    public final String getFrameworkTypeId() {
        return this.frameworkTypeId;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final Icon getFrameworkIcon() {
        return this.frameworkIcon;
    }

    public GradleKotlinFrameworkSupportProvider(@NotNull String frameworkTypeId, @NotNull String displayName, @NotNull Icon frameworkIcon) {
        Intrinsics.checkNotNullParameter((Object)frameworkTypeId, (String)"frameworkTypeId");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)frameworkIcon, (String)"frameworkIcon");
        this.frameworkTypeId = frameworkTypeId;
        this.displayName = displayName;
        this.frameworkIcon = frameworkIcon;
    }
}

