/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.arrangement;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.Stack;
import com.intellij.xml.arrangement.XmlArrangementParseInfo;
import com.intellij.xml.arrangement.XmlElementArrangementEntry;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlArrangementVisitor
extends XmlElementVisitor {
    private final Stack<XmlElementArrangementEntry> myStack;
    private final XmlArrangementParseInfo myInfo;
    private final Collection<? extends TextRange> myRanges;

    public XmlArrangementVisitor(@NotNull XmlArrangementParseInfo info2, @NotNull Collection<? extends TextRange> ranges) {
        if (info2 == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(1);
        }
        this.myStack = new Stack();
        this.myInfo = info2;
        this.myRanges = ranges;
    }

    public void visitXmlFile(XmlFile file) {
        XmlDocument document = file.getDocument();
        List tags = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)document, XmlTag.class);
        for (XmlTag tag : tags) {
            if (tag == null) continue;
            tag.accept((PsiElementVisitor)this);
        }
    }

    public void visitXmlTag(XmlTag tag) {
        XmlElementArrangementEntry entry = this.createNewEntry((PsiElement)tag, StdArrangementTokens.EntryType.XML_TAG, tag.getName(), tag.getNamespace());
        this.processEntry(entry, (PsiElement)tag);
        if (entry != null) {
            this.postProcessTag(tag, entry);
        }
    }

    protected void postProcessTag(@NotNull XmlTag xmlTagValue, @NotNull XmlElementArrangementEntry entry) {
        if (xmlTagValue == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(2);
        }
        if (entry == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(3);
        }
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlElementArrangementEntry entry = this.createNewEntry((PsiElement)attribute, (ArrangementSettingsToken)StdArrangementTokens.EntryType.XML_ATTRIBUTE, attribute.getName(), attribute.getNamespace());
        this.processEntry(entry, null);
    }

    private void processEntry(@Nullable XmlElementArrangementEntry entry, @Nullable PsiElement nextElement) {
        if (entry == null || nextElement == null) {
            return;
        }
        this.myStack.push((Object)entry);
        try {
            nextElement.acceptChildren((PsiElementVisitor)this);
        }
        finally {
            this.myStack.pop();
        }
    }

    @Nullable
    private XmlElementArrangementEntry createNewEntry(@NotNull PsiElement element, @NotNull ArrangementSettingsToken type, @Nullable String name, @Nullable String namespace) {
        TextRange range;
        if (element == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(4);
        }
        if (type == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(5);
        }
        if ((range = element.getTextRange()).getStartOffset() == 0 && range.getEndOffset() == 0 || !this.isWithinBounds(range)) {
            return null;
        }
        DefaultArrangementEntry current = this.getCurrent();
        if (current != null && type == StdArrangementTokens.EntryType.XML_ATTRIBUTE) {
            current = (ArrangementEntry)current.getChildren().get(0);
        }
        XmlElementArrangementEntry entry = new XmlElementArrangementEntry((ArrangementEntry)current, range, type, name, namespace, true);
        if (type == StdArrangementTokens.EntryType.XML_TAG) {
            ASTNode startName = XmlChildRole.START_TAG_NAME_FINDER.findChild(element.getNode());
            assert (startName != null);
            ASTNode end = XmlChildRole.START_TAG_END_FINDER.findChild(element.getNode());
            end = end == null ? XmlChildRole.EMPTY_TAG_END_FINDER.findChild(element.getNode()) : end;
            UnfairTextRange attributesRange = new UnfairTextRange(startName.getTextRange().getEndOffset(), end != null ? end.getStartOffset() : range.getEndOffset());
            if (attributesRange.getLength() > 0) {
                entry.addChild((ArrangementEntry)new XmlElementArrangementEntry((ArrangementEntry)entry, (TextRange)attributesRange, (ArrangementSettingsToken)StdArrangementTokens.EntryType.XML_ATTRIBUTE, null, null, false));
            }
        }
        if (current == null) {
            this.myInfo.addEntry(entry);
        } else {
            current.addChild((ArrangementEntry)entry);
        }
        return entry;
    }

    @Nullable
    private DefaultArrangementEntry getCurrent() {
        return this.myStack.isEmpty() ? null : (DefaultArrangementEntry)this.myStack.peek();
    }

    private boolean isWithinBounds(@NotNull TextRange range) {
        if (range == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(6);
        }
        for (TextRange textRange : this.myRanges) {
            if (!textRange.intersects(range)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTagValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/arrangement/XmlArrangementVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessTag";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewEntry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isWithinBounds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

