/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidClassesDirBuildRootDescriptor;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidLibraryPackagingTarget
extends AndroidBuildTarget {
    public AndroidLibraryPackagingTarget(@NotNull JpsModule module) {
        if (module == null) {
            AndroidLibraryPackagingTarget.$$$reportNull$$$0(0);
        }
        super(MyTargetType.INSTANCE, module);
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File moduleOutputDir = ProjectPaths.getModuleOutputDir((JpsModule)this.myModule, (boolean)false);
        if (moduleOutputDir != null) {
            List<AndroidClassesDirBuildRootDescriptor> list = Collections.singletonList(new AndroidClassesDirBuildRootDescriptor(this, moduleOutputDir));
            if (list == null) {
                AndroidLibraryPackagingTarget.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<BuildRootDescriptor> list = Collections.emptyList();
        if (list == null) {
            AndroidLibraryPackagingTarget.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputFile(context));
        if (list == null) {
            AndroidLibraryPackagingTarget.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        File file = this.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths());
        if (file == null) {
            AndroidLibraryPackagingTarget.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public File getOutputFile(BuildDataPaths dataPaths) {
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, this.myModule);
        return new File(dir, "classes.jar");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidLibraryPackagingTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidLibraryPackagingTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeRootDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MyTargetType
    extends AndroidBuildTargetType<AndroidLibraryPackagingTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-library-packaging", "Library Packaging");
        }

        @Override
        @Nullable
        public AndroidLibraryPackagingTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                MyTargetType.$$$reportNull$$$0(0);
            }
            return extension.isLibrary() ? new AndroidLibraryPackagingTarget(extension.getModule()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/builder/AndroidLibraryPackagingTarget$MyTargetType", "createBuildTarget"));
        }
    }
}

