/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.inspection;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.kotlin.AndroidKtPsiUtilsKt;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.idea.highlighter.IdeErrorMessages;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IncorrectScopeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.android.kotlin.idea"})
public final class IncorrectScopeInspection
extends AbstractKotlinInspection {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (((Boolean)StudioFlags.KOTLIN_INCORRECT_SCOPE_CHECK_IN_TESTS.get()).booleanValue()) {
            PsiFile psiFile = session.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"session.file");
            if (ModuleExtensionsKt.getAndroidFacet((PsiElement)((PsiElement)psiFile)) != null) {
                PsiFile psiFile2 = session.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"session.file");
                VirtualFile virtualFile = psiFile2.getVirtualFile();
                PsiFile psiFile3 = session.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"session.file");
                if (TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)psiFile3.getProject())) {
                    psiElementVisitor = (PsiElementVisitor)new KtVisitorVoid(holder){
                        final /* synthetic */ ProblemsHolder $holder;

                        public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            if (expression instanceof KtNameReferenceExpression) {
                                PsiReference[] psiReferenceArray = ((KtNameReferenceExpression)expression).getReferences();
                                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"expression.references");
                                PsiReference[] $this$ifNotEmpty$iv = psiReferenceArray;
                                boolean $i$f$ifNotEmpty = false;
                                PsiReference[] psiReferenceArray2 = $this$ifNotEmpty$iv;
                                boolean bl = false;
                                PsiReference[] psiReferenceArray3 = psiReferenceArray2;
                                boolean bl2 = false;
                                if (!(psiReferenceArray3.length == 0)) {
                                    PsiReference[] $this$ifNotEmpty = $this$ifNotEmpty$iv;
                                    boolean bl3 = false;
                                    PsiElement psiElement = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)expression)).resolve();
                                    if (psiElement == null) {
                                        return;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.mainReference.resolve() ?: return");
                                    PsiElement resolveResult = psiElement;
                                    GlobalSearchScope globalSearchScope = ((KtNameReferenceExpression)expression).getResolveScope();
                                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"expression.resolveScope");
                                    GlobalSearchScope scope = globalSearchScope;
                                    PsiElement psiElement2 = resolveResult;
                                    String string = psiElement2 instanceof PsiClass ? ((PsiClass)resolveResult).getQualifiedName() : (psiElement2 instanceof KtClass ? AndroidKtPsiUtilsKt.getQualifiedName((KtClass)((KtClass)resolveResult)) : null);
                                    if (string == null) {
                                        return;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (resolveResult) {\n \u2026              } ?: return");
                                    String qualifiedName = string;
                                    if (JavaPsiFacade.getInstance((Project)((KtNameReferenceExpression)expression).getProject()).findClass(qualifiedName, scope) == null) {
                                        ParametrizedDiagnostic parametrizedDiagnostic = Errors.UNRESOLVED_REFERENCE.on((PsiElement)expression, (Object)expression);
                                        Intrinsics.checkNotNullExpressionValue((Object)parametrizedDiagnostic, (String)"Errors.UNRESOLVED_REFERE\u2026n(expression, expression)");
                                        ParametrizedDiagnostic diagnostic = parametrizedDiagnostic;
                                        String string2 = IdeErrorMessages.render((Diagnostic)((Diagnostic)diagnostic));
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeErrorMessages.render(diagnostic)");
                                        String message = string2;
                                        this.$holder.registerProblem((PsiElement)expression, message, ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                                    }
                                }
                            }
                        }
                        {
                            this.$holder = $captured_local_variable$0;
                        }
                    };
                    return psiElementVisitor;
                }
            }
        }
        PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
        psiElementVisitor = psiElementVisitor2;
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"PsiElementVisitor.EMPTY_VISITOR");
        return psiElementVisitor;
    }
}

