/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.intention;

import com.android.tools.idea.flags.StudioFlags;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.compose.AndroidComposablePsiUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementSurroundDescriptor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0016J%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/android/intention/ComposeSurroundWithWidget;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "getFamilyName", "", "getTemplate", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.android.kotlin.idea"})
public final class ComposeSurroundWithWidget
implements IntentionAction,
HighPriorityAction {
    @NotNull
    public String getText() {
        String string = AndroidBundle.message((String)"compose.surround.with.widget.intention.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AndroidBundle.message(\"c\u2026h.widget.intention.text\")");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return "Compose Surround With Widget";
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        PsiElement[] statements;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!((Boolean)StudioFlags.COMPOSE_EDITOR_SUPPORT.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)StudioFlags.COMPOSE_SURROUND_WITH_WIDGET.get()).booleanValue()) {
            return false;
        }
        if (file == null || editor == null) {
            return false;
        }
        if (!(file.isWritable() && file instanceof KtFile && editor.getSelectionModel().hasSelection())) {
            return false;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        PsiElement psiElement = file.findElementAt(caretModel.getOffset());
        if (psiElement == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"file.findElementAt(edito\u2026l.offset) ?: return false");
        PsiElement element = psiElement;
        if (!AndroidComposablePsiUtils.isInsideComposableCode((PsiElement)element)) {
            return false;
        }
        KotlinStatementSurroundDescriptor kotlinStatementSurroundDescriptor = new KotlinStatementSurroundDescriptor();
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        int n = selectionModel.getSelectionStart();
        SelectionModel selectionModel2 = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel2, (String)"editor.selectionModel");
        PsiElement[] psiElementArray = kotlinStatementSurroundDescriptor.getElementsToSurround(file, n, selectionModel2.getSelectionEnd());
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"KotlinStatementSurroundD\u2026ectionModel.selectionEnd)");
        PsiElement[] psiElementArray2 = statements = psiElementArray;
        boolean bl = false;
        PsiElement[] psiElementArray3 = psiElementArray2;
        boolean bl2 = false;
        return !(psiElementArray3.length == 0);
    }

    private final TemplateImpl getTemplate() {
        return TemplateSettings.getInstance().getTemplate("W", "AndroidCompose");
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        new InvokeTemplateAction(this.getTemplate(), editor, project, (Set)new HashSet()).perform();
    }
}

