/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;

public final class PluginIdDependenciesIndex
extends PluginXmlIndexBase<String, Void> {
    private static final ID<String, Void> NAME = ID.create((String)"PluginIdDependenciesIndex");
    @NonNls
    private static final String FILENAME_KEY_PREFIX = "___FILENAME___";
    @NonNls
    private static final String PLUGIN_ID_KEY_PREFIX = "___PLUGIN_ID___";

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PluginIdDependenciesIndex.$$$reportNull$$$0(0);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            PluginIdDependenciesIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            PluginIdDependenciesIndex.$$$reportNull$$$0(2);
        }
        return voidDataExternalizer;
    }

    @Override
    protected Map<String, Void> performIndexing(IdeaPlugin plugin) {
        SmartList ids = new SmartList();
        String pluginId = plugin.getPluginId();
        if (pluginId != null) {
            ids.add(PLUGIN_ID_KEY_PREFIX + pluginId);
        }
        List<DomElement> dependencies = PluginIdDependenciesIndex.getChildrenWithoutIncludes(plugin, "depends");
        for (Dependency dependency : dependencies) {
            ContainerUtil.addIfNotNull((Collection)ids, (Object)dependency.getStringValue());
            String configFile = dependency.getConfigFile().getStringValue();
            if (configFile == null) continue;
            String filename = PathUtil.getFileName((String)configFile);
            ids.add(PluginIdDependenciesIndex.getDependsIndexingKey(filename));
        }
        return ContainerUtil.newHashMap((List)ids, Collections.nCopies(ids.size(), null));
    }

    public int getVersion() {
        return 2;
    }

    public static Set<String> getPluginAndDependsIds(Project project, Set<VirtualFile> files) {
        HashSet<String> ids = new HashSet<String>();
        for (VirtualFile file : files) {
            Set<String> keys = FileBasedIndex.getInstance().getFileData(NAME, file, project).keySet();
            String pluginId = PluginIdDependenciesIndex.findPluginId(keys);
            ContainerUtil.addIfNotNull(ids, (Object)pluginId);
            ids.addAll(ContainerUtil.filter(keys, s -> !StringUtil.startsWith((CharSequence)s, (CharSequence)PLUGIN_ID_KEY_PREFIX) && !StringUtil.startsWith((CharSequence)s, (CharSequence)FILENAME_KEY_PREFIX)));
        }
        return ids;
    }

    @Nullable
    public static String getPluginId(Project project, VirtualFile file) {
        Set<String> keys = FileBasedIndex.getInstance().getFileData(NAME, file, project).keySet();
        return PluginIdDependenciesIndex.findPluginId(keys);
    }

    @Nullable
    private static String findPluginId(Set<String> data) {
        String pluginIdEntry = (String)ContainerUtil.find(data, s -> StringUtil.startsWith((CharSequence)s, (CharSequence)PLUGIN_ID_KEY_PREFIX));
        return pluginIdEntry == null ? null : StringUtil.trimStart((String)pluginIdEntry, (String)PLUGIN_ID_KEY_PREFIX);
    }

    public static Collection<VirtualFile> findDependsTo(Project project, VirtualFile file) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)PluginIdDependenciesIndex.getDependsIndexingKey(file.getName()), GlobalSearchScopesCore.projectProductionScope((Project)project));
    }

    private static String getDependsIndexingKey(@NotNull String filename) {
        if (filename == null) {
            PluginIdDependenciesIndex.$$$reportNull$$$0(3);
        }
        return FILENAME_KEY_PREFIX + filename;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/index/PluginIdDependenciesIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/PluginIdDependenciesIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDependsIndexingKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

