/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;

public class PluginXmlDynamicPluginInspection
extends DevKitPluginXmlInspectionBase {
    public boolean highlightNonDynamicEPUsages = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.option.highlight.usages.ep", new Object[0]), (InspectionProfileEntry)this, "highlightNonDynamicEPUsages");
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof ApplicationComponents || element instanceof ProjectComponents || element instanceof ModuleComponents) {
            PluginXmlDynamicPluginInspection.highlightComponents(holder, element);
        } else if (element instanceof ExtensionPoint) {
            PluginXmlDynamicPluginInspection.highlightExtensionPoint(holder, (ExtensionPoint)element);
        } else if (element instanceof Group) {
            PluginXmlDynamicPluginInspection.highlightGroup(holder, (Group)element);
        } else if (this.highlightNonDynamicEPUsages && element instanceof Extension) {
            PluginXmlDynamicPluginInspection.highlightExtension(holder, (Extension)element);
        }
    }

    private static void highlightComponents(DomElementAnnotationHolder holder, DomElement component) {
        holder.createProblem(component, new HtmlBuilder().append(DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.component.usage", new Object[0])).nbsp().append((HtmlChunk)HtmlChunk.link((String)"https://www.jetbrains.org/intellij/sdk/docs/basics/plugin_structure/plugin_components.html", (String)DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.component.usage.docs.link.title", new Object[0]))).wrapWithHtmlBody().toString(), new LocalQuickFix[0]);
    }

    private static void highlightExtensionPoint(DomElementAnnotationHolder holder, ExtensionPoint extensionPoint) {
        if (!DomUtil.hasXml(extensionPoint.getDynamic())) {
            LocalQuickFix[] localQuickFixArray;
            if (holder.isOnTheFly() && ApplicationManager.getApplication().isInternal()) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                localQuickFixArray2[0] = PluginXmlDynamicPluginInspection.createAnalyzeEPFix("AnalyzeEPUsage", extensionPoint);
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[1] = PluginXmlDynamicPluginInspection.createAnalyzeEPFix("AnalyzeEPUsageIgnoreSafeClasses", extensionPoint);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.createProblem((DomElement)extensionPoint, DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.extension.point", extensionPoint.getEffectiveQualifiedName()), fixes);
        } else if (Boolean.FALSE == extensionPoint.getDynamic().getValue()) {
            holder.createProblem((DomElement)extensionPoint, DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.explicit.non.dynamic.extension.point", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[0]);
        }
    }

    private static IntentionAndQuickFixAction createAnalyzeEPFix(String actionId, ExtensionPoint extensionPoint) {
        final AnAction action = ActionManager.getInstance().getAction(actionId);
        assert (action != null) : actionId;
        final String name = DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.analyze.extension.point", action.getTemplateText(), extensionPoint.getEffectiveQualifiedName());
        return new IntentionAndQuickFixAction(){

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getName() {
                String string = name;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                String string = Objects.requireNonNull(action.getTemplateText());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                assert (editor != null);
                action.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((EditorEx)editor).getDataContext()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDynamicPluginInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDynamicPluginInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void highlightGroup(DomElementAnnotationHolder holder, Group group) {
        if (!DomUtil.hasXml((DomElement)group.getId())) {
            holder.createProblem((DomElement)group, DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.id.required.for.group", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix((DomElement)group.getId())});
        }
    }

    private static void highlightExtension(DomElementAnnotationHolder holder, Extension extension) {
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint != null && Boolean.TRUE != extensionPoint.getDynamic().getValue()) {
            holder.createProblem((DomElement)extension, DevKitBundle.message("inspections.plugin.xml.dynamic.plugin.usage.of.non.dynamic.extension.point", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[0]);
        }
    }
}

