/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyThemeAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyThemeAction.$$$reportNull$$$0(0);
        }
        ApplyThemeAction.applyTempTheme(e);
    }

    public static boolean applyTempTheme(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ApplyThemeAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return false;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (!UITheme.isThemeFile((VirtualFile)file)) {
            file = null;
        }
        if (file == null) {
            for (VirtualFile virtualFile : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
                if (!UITheme.isThemeFile((VirtualFile)virtualFile)) continue;
                file = virtualFile;
                break;
            }
        }
        if (file == null) {
            file = (VirtualFile)ContainerUtil.getFirstItem((Collection)FilenameIndex.getAllFilesByExt((Project)project, (String)"theme.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        }
        if (file != null && UITheme.isThemeFile((VirtualFile)file)) {
            return ApplyThemeAction.applyTempTheme(file, project);
        }
        return false;
    }

    private static boolean applyTempTheme(@NotNull VirtualFile json, Project project) {
        if (json == null) {
            ApplyThemeAction.$$$reportNull$$$0(2);
        }
        try {
            FileDocumentManager.getInstance().saveAllDocuments();
            UITheme theme = UITheme.loadFromJson((InputStream)json.getInputStream(), (String)"Temp theme", null, ApplyThemeAction.createIconsMapper(json, project));
            String pathToScheme = theme.getEditorScheme();
            VirtualFile editorScheme = null;
            if (pathToScheme != null) {
                editorScheme = ApplyThemeAction.findThemeFile(json, project, pathToScheme);
            }
            ApplyThemeAction.patchBackgroundImagePath(json, project, theme.getBackground());
            ApplyThemeAction.patchBackgroundImagePath(json, project, theme.getEmptyFrameBackground());
            LafManager.getInstance().setCurrentLookAndFeel((UIManager.LookAndFeelInfo)new TempUIThemeBasedLookAndFeelInfo(theme, editorScheme));
            IconLoader.clearCache();
            LafManager.getInstance().updateUI();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void patchBackgroundImagePath(@NotNull VirtualFile json, Project project, Map<String, Object> background) {
        VirtualFile pathToBg;
        if (json == null) {
            ApplyThemeAction.$$$reportNull$$$0(3);
        }
        if (background != null && (pathToBg = ApplyThemeAction.findThemeFile(json, project, background.get("image").toString())) != null) {
            background.put("image", pathToBg.getPath());
        }
    }

    @Nullable
    private static VirtualFile findThemeFile(@NotNull VirtualFile json, Project project, String pathToFile) {
        Module module;
        if (json == null) {
            ApplyThemeAction.$$$reportNull$$$0(4);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)json, (Project)project)) != null) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots(false)) {
                Path path = Paths.get(root.getPath(), pathToFile);
                if (!path.toFile().exists()) continue;
                return VfsUtil.findFile((Path)path, (boolean)true);
            }
        }
        return null;
    }

    private static Function<String, String> createIconsMapper(VirtualFile json, Project project) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)json, (Project)project);
        if (module != null) {
            return s -> ApplyThemeAction.findAbsoluteFilePathByRelativePath(module, s, s);
        }
        return s -> s;
    }

    @Nullable
    private static String findAbsoluteFilePathByRelativePath(Module module, String relativePath, String defaultResult) {
        String filename = new File(relativePath).getName();
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope((Module)module);
        Collection filesByName = FilenameIndex.getVirtualFilesByName((Project)module.getProject(), (String)filename, (GlobalSearchScope)moduleScope);
        for (VirtualFile file : filesByName) {
            String path = file.getPath();
            if (!path.endsWith(relativePath) && !path.endsWith(relativePath.replaceAll("/", "\\"))) continue;
            return "file:/" + path;
        }
        return defaultResult;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyThemeAction.$$$reportNull$$$0(5);
        }
        if (LafManager.getInstance().getCurrentLookAndFeel() instanceof TempUIThemeBasedLookAndFeelInfo) {
            e.getPresentation().setIcon(AllIcons.Actions.Rerun);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/themes/ApplyThemeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTempTheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "patchBackgroundImagePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findThemeFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

