/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateVariableFix
extends AbstractFix {
    private final XPathVariableReference myReference;

    public CreateVariableFix(XPathVariableReference reference) {
        this.myReference = reference;
    }

    @NotNull
    public String getText() {
        String string = XPathBundle.message("intention.name.create.variable", this.myReference.getReferencedName());
        if (string == null) {
            CreateVariableFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getFamilyName() {
        return XPathBundle.message("intention.family.name.create.variable", new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateVariableFix.$$$reportNull$$$0(1);
        }
        editor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)this.myReference, XmlTag.class, (boolean)true);
        if (tag == null) {
            return;
        }
        XmlTag xmlTag = tag.createChildTag("variable", "http://www.w3.org/1999/XSL/Transform", null, false);
        xmlTag.setAttribute("name", this.myReference.getReferencedName());
        xmlTag.setAttribute("select", "dummy");
        XmlAttribute select = xmlTag.getAttribute("select", null);
        assert (select != null);
        PsiElement dummy = XsltSupport.getAttValueToken(select);
        assert (dummy != null);
        TemplateBuilderImpl builder = CreateVariableFix.createTemplateBuilder(xmlTag);
        builder.replaceElement(dummy, (Expression)new MacroCallNode((Macro)new CompleteMacro()));
        builder.setEndVariableAfter((PsiElement)select);
        Template template = builder.buildTemplate();
        template.addTextSegment("\n");
        template.setToIndent(true);
        XmlTag insertionPoint = this.findVariableInsertionPoint(tag);
        CreateVariableFix.moveTo(editor, insertionPoint);
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
    }

    private XmlTag findVariableInsertionPoint(XmlTag currentUsageTag) {
        return XsltCodeInsightUtil.findVariableInsertionPoint(currentUsageTag, this.getUsageBlock(), this.myReference.getReferencedName(), new XmlTag[0]);
    }

    @Nullable
    public PsiElement getUsageBlock() {
        return XsltCodeInsightUtil.getUsageBlock(this.myReference);
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateVariableFix.$$$reportNull$$$0(2);
        }
        if (!this.myReference.isValid()) {
            return false;
        }
        PsiFile psiFile = this.myReference.getContainingFile();
        assert (psiFile != null);
        return this.myReference.isValid() && psiFile.isValid();
    }

    @Override
    protected boolean requiresEditor() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/CreateVariableFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/CreateVariableFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

