/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.io.IOException;
import java.io.Reader;

abstract class ReadProcessThread
extends Thread
implements Disposable {
    private static final int NOTIFY_TEXT_DELAY = 300;
    private final Reader myReader;
    private final StringBuffer myBuffer = new StringBuffer();
    private boolean myIsClosed = false;

    public ReadProcessThread(Reader reader) {
        super("ReadProcessThread " + reader.getClass().getName());
        this.setPriority(10);
        this.myReader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!ReadProcessThread.this.isClosed()) {
                    myAlarm.addRequest((Runnable)this, 300);
                    ReadProcessThread.this.checkTextAvailable();
                }
            }
        }, 300);
        try {
            while (!this.isClosed()) {
                int c = this.readNextByte();
                if (c == -1) {
                    break;
                }
                StringBuffer stringBuffer = this.myBuffer;
                synchronized (stringBuffer) {
                    this.myBuffer.append((char)c);
                }
                if (c != 10) continue;
                this.checkTextAvailable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.close();
            }
            finally {
                Disposer.dispose((Disposable)this);
            }
        }
    }

    private int readNextByte() {
        try {
            return this.myReader.read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTextAvailable() {
        StringBuffer stringBuffer = this.myBuffer;
        synchronized (stringBuffer) {
            if (this.myBuffer.length() == 0) {
                return;
            }
            String s = this.myBuffer.substring(0, this.myBuffer.length());
            this.myBuffer.setLength(0);
            this.textAvailable(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReadProcessThread readProcessThread = this;
        synchronized (readProcessThread) {
            if (this.isClosed()) {
                return;
            }
            this.myIsClosed = true;
        }
        try {
            if (Thread.currentThread() != this) {
                this.join(0L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.myReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.checkTextAvailable();
    }

    protected abstract void textAvailable(String var1);

    private synchronized boolean isClosed() {
        return this.myIsClosed;
    }

    public void dispose() {
    }
}

