/*
 * Decompiled with CFR 0.152.
 */
package javaslang.match;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javaslang.match.UnapplyChecker;
import javaslang.match.annotation.Patterns;
import javaslang.match.annotation.Unapply;
import javaslang.match.generator.Generator;
import javaslang.match.model.ClassModel;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class PatternsProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(Patterns.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<ClassModel> classModels;
        Set<TypeElement> typeElements;
        if (!(annotations.isEmpty() || (typeElements = roundEnv.getElementsAnnotatedWith(Patterns.class).stream().filter(element -> element instanceof TypeElement).map(element -> (TypeElement)element).collect(Collectors.toSet())).isEmpty() || (classModels = this.transform(typeElements)).isEmpty())) {
            this.generate(classModels);
        }
        return true;
    }

    private Set<ClassModel> transform(Set<TypeElement> typeElements) {
        HashSet<ClassModel> classModels = new HashSet<ClassModel>();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Messager messager = this.processingEnv.getMessager();
        for (TypeElement typeElement : typeElements) {
            ClassModel classModel = ClassModel.of(elementUtils, typeElement);
            List methodModels = classModel.getMethods().stream().filter(method -> method.isAnnotatedWith(Unapply.class)).collect(Collectors.toList());
            if (methodModels.isEmpty()) {
                messager.printMessage(Diagnostic.Kind.WARNING, "No @Unapply methods found.", classModel.typeElement());
                continue;
            }
            boolean methodsValid = methodModels.stream().reduce(true, (bool, method) -> bool != false && UnapplyChecker.isValid(method.getExecutableElement(), messager), (b1, b2) -> b1 != false && b2 != false);
            if (!methodsValid) continue;
            classModels.add(classModel);
        }
        return classModels;
    }

    private void generate(Set<ClassModel> classModels) {
        Filer filer = this.processingEnv.getFiler();
        for (ClassModel classModel : classModels) {
            String derivedClassName = this.deriveClassName(classModel);
            String code = Generator.generate(derivedClassName, classModel);
            String fqn = (classModel.hasDefaultPackage() ? "" : classModel.getPackageName() + ".") + derivedClassName;
            try {
                Writer writer = filer.createSourceFile(fqn, classModel.typeElement()).openWriter();
                Throwable throwable = null;
                try {
                    writer.write(code);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException x) {
                throw new Error("Error writing " + fqn, x);
            }
        }
    }

    private String deriveClassName(ClassModel classModel) {
        String name = classModel.getClassName();
        return ("$".equals(name) ? "" : (name.endsWith(".$") ? name.substring(0, name.length() - 2) : name)).replaceAll("\\.", "_") + Patterns.class.getSimpleName();
    }
}

