/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.packer;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.sonatype.nexus.index.context.IndexingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPackingRequest {
    private static final int MAX_CHUNKS = 30;
    private IndexingContext context;
    private File targetDir;
    private boolean createIncrementalChunks;
    private boolean createChecksumFiles;
    private int maxIndexChunks;
    private boolean useTargetProperties;
    private Collection<IndexFormat> formats;

    public IndexPackingRequest(IndexingContext context, File targetDir) {
        this.context = context;
        this.targetDir = targetDir;
        this.createIncrementalChunks = true;
        this.createChecksumFiles = false;
        this.maxIndexChunks = 30;
        this.useTargetProperties = false;
        this.formats = Arrays.asList(IndexFormat.FORMAT_LEGACY, IndexFormat.FORMAT_V1);
    }

    public IndexingContext getContext() {
        return this.context;
    }

    public void setContext(IndexingContext context) {
        this.context = context;
    }

    public void setFormats(Collection<IndexFormat> formats) {
        this.formats = formats;
    }

    public Collection<IndexFormat> getFormats() {
        return this.formats;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public boolean isCreateIncrementalChunks() {
        return this.createIncrementalChunks;
    }

    public void setCreateIncrementalChunks(boolean createIncrementalChunks) {
        this.createIncrementalChunks = createIncrementalChunks;
    }

    public boolean isCreateChecksumFiles() {
        return this.createChecksumFiles;
    }

    public void setCreateChecksumFiles(boolean createChecksumFiles) {
        this.createChecksumFiles = createChecksumFiles;
    }

    public int getMaxIndexChunks() {
        return this.maxIndexChunks;
    }

    public void setMaxIndexChunks(int maxIndexChunks) {
        this.maxIndexChunks = maxIndexChunks;
    }

    public boolean isUseTargetProperties() {
        return this.useTargetProperties;
    }

    public void setUseTargetProperties(boolean useTargetProperties) {
        this.useTargetProperties = useTargetProperties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexFormat {
        FORMAT_LEGACY,
        FORMAT_V1;

    }
}

