/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analytics.BuildAttributionAnalyticsManager;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersWrapper;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.data.builder.BuildAttributionReportBuilder;
import com.android.ide.common.attribution.AndroidGradlePluginAttributionData;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.io.File;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.events.ProgressEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0012\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/build/attribution/BuildAttributionManagerImpl;", "Lcom/android/tools/idea/gradle/project/build/attribution/BuildAttributionManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "analyzersProxy", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "getAnalyzersProxy", "()Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "analyzersWrapper", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersWrapper;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "onBuildFailure", "", "onBuildStart", "onBuildSuccess", "attributionFileDir", "Ljava/io/File;", "openResultsTab", "statusChanged", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "intellij.android.build-attribution"})
public final class BuildAttributionManagerImpl
implements BuildAttributionManager {
    private final TaskContainer taskContainer;
    private final PluginContainer pluginContainer;
    @NotNull
    private final BuildEventsAnalyzersProxy analyzersProxy;
    private final BuildEventsAnalyzersWrapper analyzersWrapper;
    private final Project project;

    @VisibleForTesting
    @NotNull
    public final BuildEventsAnalyzersProxy getAnalyzersProxy() {
        return this.analyzersProxy;
    }

    @Override
    public void onBuildStart() {
        this.analyzersWrapper.onBuildStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBuildSuccess(@NotNull File attributionFileDir) {
        Intrinsics.checkNotNullParameter((Object)attributionFileDir, (String)"attributionFileDir");
        long buildFinishedTimestamp = System.currentTimeMillis();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        String buildSessionId = string;
        Closeable closeable = new BuildAttributionAnalyticsManager(buildSessionId, this.project);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BuildAttributionAnalyticsManager analyticsManager = (BuildAttributionAnalyticsManager)closeable;
            boolean bl3 = false;
            analyticsManager.logBuildAttributionPerformanceStats(buildFinishedTimestamp - this.analyzersProxy.getBuildFinishedTimestamp(), (Function0<Unit>)((Function0)new Function0<Unit>(this, buildFinishedTimestamp, attributionFileDir, buildSessionId){
                final /* synthetic */ BuildAttributionManagerImpl this$0;
                final /* synthetic */ long $buildFinishedTimestamp$inlined;
                final /* synthetic */ File $attributionFileDir$inlined;
                final /* synthetic */ String $buildSessionId$inlined;
                {
                    this.this$0 = buildAttributionManagerImpl;
                    this.$buildFinishedTimestamp$inlined = l;
                    this.$attributionFileDir$inlined = file;
                    this.$buildSessionId$inlined = string;
                    super(0);
                }

                public final void invoke() {
                    AndroidGradlePluginAttributionData attributionData = AndroidGradlePluginAttributionData.Companion.load(this.$attributionFileDir$inlined);
                    if (attributionData != null) {
                        BuildAttributionManagerImpl.access$getTaskContainer$p(this.this$0).updateTasksData(attributionData);
                    }
                    BuildAttributionManagerImpl.access$getAnalyzersWrapper$p(this.this$0).onBuildSuccess(attributionData);
                }
            }));
            analyticsManager.logAnalyzersData(this.analyzersProxy);
            BuildAttributionUiManager.Companion.getInstance(this.project).showNewReport(new BuildAttributionReportBuilder(this.analyzersProxy, buildFinishedTimestamp).build(), buildSessionId);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void onBuildFailure() {
        this.analyzersWrapper.onBuildFailure();
    }

    public void statusChanged(@Nullable ProgressEvent event) {
        if (event == null) {
            return;
        }
        this.analyzersWrapper.receiveEvent(event);
    }

    @Override
    public void openResultsTab() {
        BuildAttributionUiManager.Companion.getInstance(this.project).openTab(BuildAttributionUiAnalytics.TabOpenEventSource.BUILD_OUTPUT_LINK);
    }

    public BuildAttributionManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.taskContainer = new TaskContainer();
        this.pluginContainer = new PluginContainer();
        this.analyzersProxy = new BuildEventsAnalyzersProxy(BuildAttributionWarningsFilter.Companion.getInstance(this.project), this.taskContainer, this.pluginContainer);
        this.analyzersWrapper = new BuildEventsAnalyzersWrapper(this.analyzersProxy.getBuildEventsAnalyzers(), this.analyzersProxy.getBuildAttributionReportAnalyzers());
    }

    public static final /* synthetic */ TaskContainer access$getTaskContainer$p(BuildAttributionManagerImpl $this) {
        return $this.taskContainer;
    }

    public static final /* synthetic */ BuildEventsAnalyzersWrapper access$getAnalyzersWrapper$p(BuildAttributionManagerImpl $this) {
        return $this.analyzersWrapper;
    }
}

