/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JComponent;

public abstract class AbstractBuildAttributionInfoPanel
extends JBPanel<AbstractBuildAttributionInfoPanel> {
    private static final int BORDER_WIDTH = 16;

    public AbstractBuildAttributionInfoPanel() {
        super((LayoutManager)new GridBagLayout());
        this.setBorder(JBUI.Borders.empty((int)16));
    }

    public AbstractBuildAttributionInfoPanel init() {
        this.addHeader();
        this.addBody();
        int preferredWidth = this.calculatePreferredWidth() + 32;
        this.withPreferredWidth(preferredWidth);
        return this;
    }

    private void addHeader() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        c.insets = JBUI.insetsBottom((int)8);
        this.add(this.createHeader(), c);
    }

    private void addBody() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = JBUI.emptyInsets();
        c.fill = 1;
        c.anchor = 23;
        JComponent body = this.createBody();
        body.setName("pageBody");
        this.add(body, c);
    }

    public int calculatePreferredWidth() {
        return Arrays.stream(this.getComponents()).mapToInt(c -> c.getPreferredSize().width).max().orElse(0);
    }

    public abstract JComponent createHeader();

    public abstract JComponent createBody();
}

