/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.DescriptionWithHelpLinkLabel;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.data.CriticalPathPluginUiData;
import com.android.build.attribution.ui.data.TaskIssueType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskIssuesGroup;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.panels.TreeLinkListener;
import com.android.utils.HtmlBuilder;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0016\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0002\u001a\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001\u001a$\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00180\u00072\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0006\u0010 \u001a\u00020\u001f\u001a\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"CRITICAL_PATH_LINK", "", "createIssueTypeListPanel", "Ljavax/swing/JComponent;", "issuesGroup", "Lcom/android/build/attribution/ui/data/TaskIssuesGroup;", "listener", "Lcom/android/build/attribution/ui/panels/TreeLinkListener;", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "createReasonsText", "reasons", "", "criticalPathHeader", "prefix", "duration", "headerLabel", "Ljavax/swing/JLabel;", "text", "htmlTextLabel", "Lcom/intellij/ui/components/JBLabel;", "html", "pluginInfoPanel", "pluginUiData", "Lcom/android/build/attribution/ui/data/CriticalPathPluginUiData;", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "analytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "reasonsToRunList", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "taskInfoPanel", "Ljavax/swing/JPanel;", "verticalRuler", "wrapPathToSpans", "intellij.android.build-attribution"})
public final class BuildAttributionPanelsKt {
    @NotNull
    public static final String CRITICAL_PATH_LINK = "https://developer.android.com/r/tools/build-attribution/critical-path";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JComponent pluginInfoPanel(@NotNull CriticalPathPluginUiData pluginUiData, @NotNull TreeLinkListener<TaskIssueType> listener2, @NotNull BuildAttributionUiAnalytics analytics) {
        void $this$apply;
        HtmlBuilder pluginText;
        Intrinsics.checkNotNullParameter((Object)pluginUiData, (String)"pluginUiData");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        JBPanel jBPanel = new JBPanel((LayoutManager)new VerticalLayout(0));
        boolean bl = false;
        boolean bl2 = false;
        JBPanel $this$apply2 = jBPanel;
        boolean bl3 = false;
        HtmlBuilder htmlBuilder = pluginText = new HtmlBuilder().openHtmlBody().add("This plugin has " + pluginUiData.getCriticalPathTasks().getSize() + ' ' + StringUtil.pluralize((String)"task", (int)pluginUiData.getCriticalPathTasks().getSize()) + ' ' + "of total duration " + BuildAttributionUIUtilKt.durationString(pluginUiData.getCriticalPathDuration()) + " (" + BuildAttributionUIUtilKt.percentageString(pluginUiData.getCriticalPathDuration()) + ')').newline().add("determining this build's duration.").closeHtmlBody();
        Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"pluginText");
        String string = htmlBuilder.getHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginText.html");
        $this$apply2.add((Component)((Object)new DescriptionWithHelpLinkLabel(string, CRITICAL_PATH_LINK, analytics)));
        JBPanel jBPanel2 = new JBPanel((LayoutManager)new VerticalLayout(6));
        boolean bl4 = false;
        boolean bl5 = false;
        JBPanel jBPanel3 = jBPanel2;
        JBPanel jBPanel4 = $this$apply2;
        boolean bl6 = false;
        $this$apply.setBorder((Border)JBUI.Borders.emptyTop((int)15));
        $this$apply.add((Component)new JBLabel("Warnings detected").withFont(JBUI.Fonts.label().asBold()));
        for (TaskIssuesGroup issueGroup : pluginUiData.getIssues()) {
            void $this$apply3;
            HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(issueGroup.getType().getUiName() + " (" + issueGroup.getSize() + ')');
            boolean bl7 = false;
            boolean bl8 = false;
            HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel;
            void var21_21 = $this$apply;
            boolean bl9 = false;
            $this$apply3.addHyperlinkListener(new HyperlinkListener(issueGroup, pluginUiData, analytics, listener2){
                final /* synthetic */ TaskIssuesGroup $issueGroup$inlined;
                final /* synthetic */ CriticalPathPluginUiData $pluginUiData$inlined;
                final /* synthetic */ BuildAttributionUiAnalytics $analytics$inlined;
                final /* synthetic */ TreeLinkListener $listener$inlined;
                {
                    this.$issueGroup$inlined = taskIssuesGroup;
                    this.$pluginUiData$inlined = criticalPathPluginUiData;
                    this.$analytics$inlined = buildAttributionUiAnalytics;
                    this.$listener$inlined = treeLinkListener;
                }

                public final void hyperlinkUpdate(HyperlinkEvent it) {
                    this.$listener$inlined.clickedOn(this.$issueGroup$inlined.getType());
                }
            });
            $this$apply3.setBorder((Border)JBUI.Borders.emptyLeft((int)15));
            $this$apply3.setIcon(BuildAttributionUIUtilKt.issueIcon(issueGroup.getType()));
            Unit unit = Unit.INSTANCE;
            var21_21.add((Component)hyperlinkLabel);
        }
        if (pluginUiData.getIssues().isEmpty()) {
            $this$apply.add((Component)new JLabel("No warnings detected"));
        }
        Unit unit = Unit.INSTANCE;
        jBPanel4.add((Component)jBPanel2);
        $this$apply2.withPreferredWidth(400);
        return (JComponent)jBPanel;
    }

    @NotNull
    public static final JPanel taskInfoPanel(@NotNull TaskUiData taskData, @NotNull TreeLinkListener<TaskIssueUiData> listener2) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        JBPanel infoPanel = new JBPanel((LayoutManager)new GridBagLayout());
        HtmlBuilder htmlBuilder = new HtmlBuilder().openHtmlBody().add(taskData.getOnLogicalCriticalPath() ? "This task frequently determines build duration because of dependencies between its inputs/outputs and other tasks." : "This task occasionally determines build duration because of parallelism constraints introduced by number of cores or other tasks in the same module.").closeHtmlBody();
        Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"HtmlBuilder()\n      .ope\u2026 )\n      .closeHtmlBody()");
        String string = htmlBuilder.getHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder()\n      .ope\u2026oseHtmlBody()\n      .html");
        JBLabel taskDescription = BuildAttributionPanelsKt.htmlTextLabel(string);
        HtmlBuilder htmlBuilder2 = new HtmlBuilder().openHtmlBody().add("Module: " + taskData.getModule()).newline().add("Plugin: " + taskData.getPluginName()).newline().add("Type: " + taskData.getTaskType()).newline().add("Duration: " + BuildAttributionUIUtilKt.durationString(taskData.getExecutionTime()) + " / " + BuildAttributionUIUtilKt.percentageString(taskData.getExecutionTime())).newline().add("Executed incrementally: " + (taskData.getExecutedIncrementally() ? "Yes" : "No")).closeHtmlBody();
        Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder2, (String)"HtmlBuilder()\n      .ope\u2026\")\n      .closeHtmlBody()");
        String string2 = htmlBuilder2.getHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"HtmlBuilder()\n      .ope\u2026oseHtmlBody()\n      .html");
        JBLabel taskInfo = BuildAttributionPanelsKt.htmlTextLabel(string2);
        JBPanel jBPanel = new JBPanel((LayoutManager)new VerticalLayout(6));
        boolean bl = false;
        boolean bl2 = false;
        JBPanel $this$apply = jBPanel;
        boolean bl3 = false;
        $this$apply.add((Component)new JBLabel("Issues with this task").withFont(JBUI.Fonts.label().asBold()));
        for (TaskIssueUiData issue2 : taskData.getIssues()) {
            HyperlinkLabel label = new HyperlinkLabel(issue2.getType().getUiName());
            label.addHyperlinkListener(new HyperlinkListener(issue2, taskData, listener2){
                final /* synthetic */ TaskIssueUiData $issue;
                final /* synthetic */ TaskUiData $taskData$inlined;
                final /* synthetic */ TreeLinkListener $listener$inlined;
                {
                    this.$issue = taskIssueUiData;
                    this.$taskData$inlined = taskUiData;
                    this.$listener$inlined = treeLinkListener;
                }

                public final void hyperlinkUpdate(HyperlinkEvent it) {
                    this.$listener$inlined.clickedOn(this.$issue);
                }
            });
            label.setBorder((Border)JBUI.Borders.emptyLeft((int)15));
            label.setIcon(BuildAttributionUIUtilKt.issueIcon(issue2.getType()));
            $this$apply.add((Component)label);
        }
        if (taskData.getIssues().isEmpty()) {
            $this$apply.add((Component)new JLabel("No issues found"));
        }
        JBPanel issuesList = jBPanel;
        JBLabel reasonsToRunHeader = new JBLabel("Reason task ran").withFont(JBUI.Fonts.label().asBold());
        JBLabel reasonsList = BuildAttributionPanelsKt.reasonsToRunList(taskData);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        c.fill = 2;
        c.insets = (Insets)JBUI.insetsBottom((int)8);
        infoPanel.add((Component)taskDescription, (Object)c);
        c.gridy = 1;
        infoPanel.add((Component)taskInfo, (Object)c);
        c.gridy = 2;
        infoPanel.add((Component)issuesList, (Object)c);
        c.gridy = 3;
        c.insets = (Insets)JBUI.insetsTop((int)8);
        infoPanel.add((Component)reasonsToRunHeader, (Object)c);
        c.gridy = 4;
        c.insets = (Insets)JBUI.insetsTop((int)8);
        c.fill = 1;
        c.weighty = 1.0;
        infoPanel.add((Component)reasonsList, (Object)c);
        Comparable comparable = SequencesKt.max((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])new JComponent[]{(JComponent)taskInfo, (JComponent)issuesList}), (Function1)taskInfoPanel.1.INSTANCE));
        Intrinsics.checkNotNull((Object)comparable);
        infoPanel.withPreferredWidth(((Number)((Object)comparable)).intValue());
        return (JPanel)infoPanel;
    }

    private static final JBLabel reasonsToRunList(TaskUiData taskData) {
        return BuildAttributionPanelsKt.htmlTextLabel(BuildAttributionPanelsKt.createReasonsText(taskData.getReasonsToRun()));
    }

    private static final String createReasonsText(List<String> reasons) {
        return reasons.isEmpty() ? "No info" : CollectionsKt.joinToString$default((Iterable)reasons, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)createReasonsText.1.INSTANCE, (int)30, null);
    }

    private static final String wrapPathToSpans(String text) {
        return "<p>" + StringsKt.replace$default((String)text, (String)"/", (String)"<span>/</span>", (boolean)false, (int)4, null) + "</p>";
    }

    @NotNull
    public static final JPanel verticalRuler() {
        JBPanel jBPanel = new JBPanel().withBackground(OnePixelDivider.BACKGROUND).withPreferredWidth(1).withMaximumWidth(1).withMinimumWidth(1);
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"JBPanel<JBPanel<*>>()\n  \u20261)\n  .withMinimumWidth(1)");
        return (JPanel)jBPanel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JComponent createIssueTypeListPanel(@NotNull TaskIssuesGroup issuesGroup, @NotNull TreeLinkListener<TaskIssueUiData> listener2) {
        Intrinsics.checkNotNullParameter((Object)issuesGroup, (String)"issuesGroup");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        JBPanel jBPanel = new JBPanel();
        boolean bl = false;
        boolean bl2 = false;
        JBPanel $this$apply = jBPanel;
        boolean bl3 = false;
        $this$apply.setLayout((LayoutManager)new VerticalLayout(6));
        Iterable $this$forEach$iv = issuesGroup.getIssues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$apply2;
            TaskIssueUiData it = (TaskIssueUiData)element$iv;
            boolean bl4 = false;
            HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(it.getTask().getTaskPath());
            boolean bl5 = false;
            boolean bl6 = false;
            HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel;
            JBPanel jBPanel2 = $this$apply;
            boolean bl7 = false;
            $this$apply2.addHyperlinkListener(new HyperlinkListener(it, $this$apply, issuesGroup, listener2){
                final /* synthetic */ TaskIssueUiData $it$inlined;
                final /* synthetic */ JBPanel $this_apply$inlined;
                final /* synthetic */ TaskIssuesGroup $issuesGroup$inlined;
                final /* synthetic */ TreeLinkListener $listener$inlined;
                {
                    this.$it$inlined = taskIssueUiData;
                    this.$this_apply$inlined = jBPanel;
                    this.$issuesGroup$inlined = taskIssuesGroup;
                    this.$listener$inlined = treeLinkListener;
                }

                public final void hyperlinkUpdate(HyperlinkEvent $noName_0) {
                    this.$listener$inlined.clickedOn(this.$it$inlined);
                }
            });
            Unit unit = Unit.INSTANCE;
            jBPanel2.add((Component)hyperlinkLabel);
        }
        return (JComponent)jBPanel;
    }

    @NotNull
    public static final JComponent criticalPathHeader(@NotNull String prefix, @NotNull String duration) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return BuildAttributionPanelsKt.headerLabel(prefix + " determining this build's duration (" + duration + ')');
    }

    @NotNull
    public static final JLabel headerLabel(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        JBLabel jBLabel = new JBLabel(text).withFont(JBUI.Fonts.label((float)13.0f).asBold());
        boolean bl = false;
        boolean bl2 = false;
        JBLabel $this$apply = jBLabel;
        boolean bl3 = false;
        $this$apply.setName("pageHeader");
        JBLabel jBLabel2 = jBLabel;
        Intrinsics.checkNotNullExpressionValue((Object)jBLabel2, (String)"JBLabel(text).withFont(J\u2026{\n  name = \"pageHeader\"\n}");
        return (JLabel)jBLabel2;
    }

    @NotNull
    public static final JBLabel htmlTextLabel(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        JBLabel jBLabel = new JBLabel(html);
        boolean bl = false;
        boolean bl2 = false;
        JBLabel $this$apply = jBLabel;
        boolean bl3 = false;
        $this$apply.setAllowAutoWrapping(true);
        $this$apply.setCopyable(true);
        $this$apply.setFocusable(false);
        $this$apply.setVerticalTextPosition(1);
        return jBLabel;
    }

    public static final /* synthetic */ String access$wrapPathToSpans(String text) {
        return BuildAttributionPanelsKt.wrapPathToSpans(text);
    }
}

