/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.tree;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.PluginConfigurationUiData;
import com.android.build.attribution.ui.panels.AbstractBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.tree.AbstractBuildAttributionNode;
import com.android.build.attribution.ui.tree.PluginConfigurationNode;
import com.android.build.attribution.ui.tree.PluginConfigurationTimeNodesKt;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.treeStructure.SimpleNode;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/android/build/attribution/ui/tree/PluginConfigurationNode;", "Lcom/android/build/attribution/ui/tree/AbstractBuildAttributionNode;", "pluginData", "Lcom/android/build/attribution/ui/data/PluginConfigurationUiData;", "needEmptyIconShift", "", "parent", "(Lcom/android/build/attribution/ui/data/PluginConfigurationUiData;ZLcom/android/build/attribution/ui/tree/AbstractBuildAttributionNode;)V", "issuesCountsSuffix", "", "getIssuesCountsSuffix", "()Ljava/lang/String;", "pageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getPluginData", "()Lcom/android/build/attribution/ui/data/PluginConfigurationUiData;", "presentationIcon", "Ljavax/swing/Icon;", "getPresentationIcon", "()Ljavax/swing/Icon;", "timeSuffix", "getTimeSuffix", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "createComponent", "Lcom/android/build/attribution/ui/panels/AbstractBuildAttributionInfoPanel;", "intellij.android.build-attribution"})
final class PluginConfigurationNode
extends AbstractBuildAttributionNode {
    @Nullable
    private final Icon presentationIcon;
    @Nullable
    private final String issuesCountsSuffix;
    @Nullable
    private final String timeSuffix;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType pageType;
    @NotNull
    private final PluginConfigurationUiData pluginData;

    @Override
    @Nullable
    public Icon getPresentationIcon() {
        return this.presentationIcon;
    }

    @Override
    @Nullable
    public String getIssuesCountsSuffix() {
        return this.issuesCountsSuffix;
    }

    @Override
    @Nullable
    public String getTimeSuffix() {
        return this.timeSuffix;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getPageType() {
        return this.pageType;
    }

    @Override
    @NotNull
    public AbstractBuildAttributionInfoPanel createComponent() {
        return new AbstractBuildAttributionInfoPanel(this){
            final /* synthetic */ PluginConfigurationNode this$0;

            @NotNull
            public JComponent createHeader() {
                return BuildAttributionPanelsKt.headerLabel(this.this$0.getPluginData().getPluginName());
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public JComponent createBody() {
                void $this$apply;
                JBPanel jBPanel = new JBPanel((LayoutManager)new VerticalLayout(6));
                boolean bl = false;
                boolean bl2 = false;
                JBPanel $this$apply2 = jBPanel;
                boolean bl3 = false;
                $this$apply2.add((Component)new JBLabel(StringsKt.trimIndent((String)("\n        During build configuration, this plugin required " + BuildAttributionUIUtilKt.durationString(this.this$0.getPluginData().getConfigurationTime()) + ",\n        or " + BuildAttributionUIUtilKt.percentageString(this.this$0.getPluginData().getConfigurationTime()) + " of the total build configuration phase.\n        "))));
                SimpleNode[] simpleNodeArray = new HyperlinkLabel("Learn more");
                boolean bl4 = false;
                boolean bl5 = false;
                SimpleNode[] simpleNodeArray2 = simpleNodeArray;
                JBPanel jBPanel2 = $this$apply2;
                boolean bl6 = false;
                $this$apply.addHyperlinkListener(new HyperlinkListener(this){
                    final /* synthetic */ createComponent.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void hyperlinkUpdate(HyperlinkEvent it) {
                        this.this$0.this$0.getAnalytics().helpLinkClicked();
                    }
                });
                $this$apply.setHyperlinkTarget("https://d.android.com/r/tools/build-attribution/optimize-configuration-phase");
                Unit unit = Unit.INSTANCE;
                jBPanel2.add((Component)simpleNodeArray);
                SimpleNode[] simpleNodeArray3 = this.this$0.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)simpleNodeArray3, (String)"children");
                simpleNodeArray = simpleNodeArray3;
                bl4 = false;
                SimpleNode[] simpleNodeArray4 = simpleNodeArray;
                boolean bl7 = false;
                if (!(simpleNodeArray4.length == 0)) {
                    $this$apply2.add((Component)new JBLabel("This plugin also triggers configuration of:"));
                    SimpleNode[] simpleNodeArray5 = this.this$0.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleNodeArray5, (String)"children");
                    $this$apply2.add((Component)PluginConfigurationTimeNodesKt.access$createPluginsTable(simpleNodeArray5, this.this$0.getNodeSelector()));
                }
                return (JComponent)jBPanel;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected SimpleNode[] buildChildren() {
        void $this$mapTo$iv$iv;
        boolean childrenHaveIcon2 = this.pluginData.getNestedPlugins().stream().anyMatch(buildChildren.childrenHaveIcon.1.INSTANCE);
        Iterable $this$map$iv = this.pluginData.getNestedPlugins();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void data;
            PluginConfigurationUiData pluginConfigurationUiData = (PluginConfigurationUiData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            PluginConfigurationNode pluginConfigurationNode = new PluginConfigurationNode((PluginConfigurationUiData)data, childrenHaveIcon2, this);
            collection2.add(pluginConfigurationNode);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SimpleNode[] simpleNodeArray = thisCollection$iv.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return simpleNodeArray;
    }

    @NotNull
    public final PluginConfigurationUiData getPluginData() {
        return this.pluginData;
    }

    public PluginConfigurationNode(@NotNull PluginConfigurationUiData pluginData, boolean needEmptyIconShift, @NotNull AbstractBuildAttributionNode parent) {
        Intrinsics.checkNotNullParameter((Object)pluginData, (String)"pluginData");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent, pluginData.getPluginName());
        this.pluginData = pluginData;
        this.presentationIcon = this.pluginData.getSlowsConfiguration() ? BuildAttributionUIUtilKt.warningIcon() : (needEmptyIconShift ? BuildAttributionUIUtilKt.emptyIcon() : null);
        this.issuesCountsSuffix = BuildAttributionUIUtilKt.issuesCountString(this.pluginData.getNestedIssueCount(), 0);
        this.timeSuffix = BuildAttributionUIUtilKt.durationString(this.pluginData.getConfigurationTime());
        this.pageType = BuildAttributionUiEvent.Page.PageType.CONFIGURATION_TIME_PLUGIN;
    }
}

