/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.tree;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.PluginConfigurationUiData;
import com.android.build.attribution.ui.data.ProjectConfigurationUiData;
import com.android.build.attribution.ui.panels.AbstractBuildAttributionInfoPanel;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.tree.AbstractBuildAttributionNode;
import com.android.build.attribution.ui.tree.PluginConfigurationNode;
import com.android.build.attribution.ui.tree.PluginConfigurationTimeNodesKt;
import com.android.build.attribution.ui.tree.PluginConfigurationTimeRoot;
import com.android.build.attribution.ui.tree.ProjectNode;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/android/build/attribution/ui/tree/ProjectNode;", "Lcom/android/build/attribution/ui/tree/AbstractBuildAttributionNode;", "projectData", "Lcom/android/build/attribution/ui/data/ProjectConfigurationUiData;", "parent", "Lcom/android/build/attribution/ui/tree/PluginConfigurationTimeRoot;", "(Lcom/android/build/attribution/ui/data/ProjectConfigurationUiData;Lcom/android/build/attribution/ui/tree/PluginConfigurationTimeRoot;)V", "issuesCountsSuffix", "", "getIssuesCountsSuffix", "()Ljava/lang/String;", "pageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "presentationIcon", "Ljavax/swing/Icon;", "getPresentationIcon", "()Ljavax/swing/Icon;", "getProjectData", "()Lcom/android/build/attribution/ui/data/ProjectConfigurationUiData;", "timeSuffix", "getTimeSuffix", "buildChildren", "", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()[Lcom/intellij/ui/treeStructure/SimpleNode;", "createComponent", "Lcom/android/build/attribution/ui/panels/AbstractBuildAttributionInfoPanel;", "intellij.android.build-attribution"})
final class ProjectNode
extends AbstractBuildAttributionNode {
    @Nullable
    private final Icon presentationIcon;
    @Nullable
    private final String issuesCountsSuffix;
    @Nullable
    private final String timeSuffix;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType pageType;
    @NotNull
    private final ProjectConfigurationUiData projectData;

    @Override
    @Nullable
    public Icon getPresentationIcon() {
        return this.presentationIcon;
    }

    @Override
    @Nullable
    public String getIssuesCountsSuffix() {
        return this.issuesCountsSuffix;
    }

    @Override
    @Nullable
    public String getTimeSuffix() {
        return this.timeSuffix;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getPageType() {
        return this.pageType;
    }

    @Override
    @NotNull
    public AbstractBuildAttributionInfoPanel createComponent() {
        return new AbstractBuildAttributionInfoPanel(this){
            final /* synthetic */ ProjectNode this$0;

            @NotNull
            public JComponent createHeader() {
                return BuildAttributionPanelsKt.headerLabel(this.this$0.getProjectData().getProject() + " Configuration Time");
            }

            @NotNull
            public JComponent createBody() {
                JBPanel jBPanel = new JBPanel((LayoutManager)new VerticalLayout(6));
                boolean bl = false;
                boolean bl2 = false;
                JBPanel $this$apply = jBPanel;
                boolean bl3 = false;
                $this$apply.add((Component)new JBLabel("\nThis project took " + BuildAttributionUIUtilKt.durationString(this.this$0.getProjectData().getConfigurationTime()) + " (" + BuildAttributionUIUtilKt.percentageString(this.this$0.getProjectData().getConfigurationTime()) + " \nof total plugin configuration time) to configure the following plugins:\n"));
                SimpleNode[] simpleNodeArray = this.this$0.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)simpleNodeArray, (String)"children");
                $this$apply.add((Component)PluginConfigurationTimeNodesKt.access$createPluginsTable(simpleNodeArray, this.this$0.getNodeSelector()));
                return (JComponent)jBPanel;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected SimpleNode[] buildChildren() {
        void $this$mapTo$iv$iv;
        boolean childrenHasIcon2 = this.projectData.getPlugins().stream().anyMatch(buildChildren.childrenHasIcon.1.INSTANCE);
        Iterable $this$map$iv = this.projectData.getPlugins();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void data;
            PluginConfigurationUiData pluginConfigurationUiData = (PluginConfigurationUiData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            PluginConfigurationNode pluginConfigurationNode = new PluginConfigurationNode((PluginConfigurationUiData)data, childrenHasIcon2, this);
            collection2.add(pluginConfigurationNode);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SimpleNode[] simpleNodeArray = thisCollection$iv.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return simpleNodeArray;
    }

    @NotNull
    public final ProjectConfigurationUiData getProjectData() {
        return this.projectData;
    }

    public ProjectNode(@NotNull ProjectConfigurationUiData projectData, @NotNull PluginConfigurationTimeRoot parent) {
        Intrinsics.checkNotNullParameter((Object)projectData, (String)"projectData");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent, projectData.getProject());
        this.projectData = projectData;
        this.presentationIcon = StudioIcons.Shell.Filetree.ANDROID_MODULE;
        this.issuesCountsSuffix = BuildAttributionUIUtilKt.issuesCountString(this.projectData.getIssueCount(), 0);
        this.timeSuffix = BuildAttributionUIUtilKt.durationString(this.projectData.getConfigurationTime());
        this.pageType = BuildAttributionUiEvent.Page.PageType.CONFIGURATION_TIME_PROJECT;
    }
}

