/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeLibrary {
    @NotNull
    public String name;
    @NotNull
    public Map<Abi, DebuggableSharedObjectFile> debuggableSharedObjectFilesByAbi;
    @NotNull
    public Map<String, String> pathMappings;
    @NotNull
    private List<String> mySharedObjectFilePaths;
    @Transient
    @NotNull
    public final Map<Abi, VirtualFile> sharedObjectFilesByAbi;
    @Transient
    @NotNull
    public final List<Abi> abis;
    @Transient
    @VisibleForTesting
    @Nullable
    List<String> sourceFolderPaths;
    public boolean hasDebugSymbols;

    public NativeLibrary() {
        this.name = "";
        this.debuggableSharedObjectFilesByAbi = new HashMap<Abi, DebuggableSharedObjectFile>();
        this.pathMappings = new HashMap<String, String>();
        this.mySharedObjectFilePaths = new ArrayList<String>();
        this.sharedObjectFilesByAbi = new LinkedHashMap<Abi, VirtualFile>();
        this.abis = new ArrayList<Abi>();
    }

    public NativeLibrary(@NotNull String name) {
        if (name == null) {
            NativeLibrary.$$$reportNull$$$0(0);
        }
        this.name = "";
        this.debuggableSharedObjectFilesByAbi = new HashMap<Abi, DebuggableSharedObjectFile>();
        this.pathMappings = new HashMap<String, String>();
        this.mySharedObjectFilePaths = new ArrayList<String>();
        this.sharedObjectFilesByAbi = new LinkedHashMap<Abi, VirtualFile>();
        this.abis = new ArrayList<Abi>();
        this.name = name;
    }

    @NotNull
    public List<String> getSharedObjectFilePaths() {
        List<String> list = this.mySharedObjectFilePaths;
        if (list == null) {
            NativeLibrary.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getSharedObjectFiles() {
        return new ArrayList<VirtualFile>(this.sharedObjectFilesByAbi.values());
    }

    public void setSharedObjectFilePaths(@NotNull List<String> sharedObjectFilePaths) {
        if (sharedObjectFilePaths == null) {
            NativeLibrary.$$$reportNull$$$0(2);
        }
        this.mySharedObjectFilePaths = sharedObjectFilePaths;
        this.abis.clear();
        this.sharedObjectFilesByAbi.clear();
        ArrayList<String> nonExistingPaths = new ArrayList<String>();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (String path2 : sharedObjectFilePaths) {
            VirtualFile file = fileSystem.findFileByPath(path2);
            if (file != null) {
                Abi abi = NativeLibrary.extractAbiFrom(file);
                this.sharedObjectFilesByAbi.put(abi, file);
                this.abis.add(abi);
                continue;
            }
            nonExistingPaths.add(path2);
        }
        this.sortAbis();
        if (!nonExistingPaths.isEmpty()) {
            this.mySharedObjectFilePaths.removeAll(nonExistingPaths);
        }
    }

    public void clearDebugSymbols() {
        this.debuggableSharedObjectFilesByAbi.clear();
        this.pathMappings.clear();
        this.hasDebugSymbols = false;
        this.clearSourceFolderCache();
    }

    public boolean containsMappingForRemotePath(@NotNull String remotePath) {
        if (remotePath == null) {
            NativeLibrary.$$$reportNull$$$0(3);
        }
        return this.pathMappings.containsKey(remotePath);
    }

    public void addPathMapping(@NotNull String remotePath, @NotNull String localPath) {
        if (remotePath == null) {
            NativeLibrary.$$$reportNull$$$0(4);
        }
        if (localPath == null) {
            NativeLibrary.$$$reportNull$$$0(5);
        }
        this.pathMappings.put(remotePath, localPath);
        this.clearSourceFolderCache();
    }

    public void removePathMapping(@NotNull String remotePath) {
        if (remotePath == null) {
            NativeLibrary.$$$reportNull$$$0(6);
        }
        this.pathMappings.remove(remotePath);
        this.clearSourceFolderCache();
    }

    public void replacePathMappingsWith(@NotNull Map<String, String> newPathMappings) {
        if (newPathMappings == null) {
            NativeLibrary.$$$reportNull$$$0(7);
        }
        this.pathMappings.clear();
        this.pathMappings.putAll(newPathMappings);
        this.clearSourceFolderCache();
    }

    public boolean needsPathMappings() {
        return !this.pathMappings.isEmpty();
    }

    public void addSharedObjectFiles(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            NativeLibrary.$$$reportNull$$$0(8);
        }
        for (VirtualFile file : files2) {
            this.doAddSharedObjectFile(file);
        }
        this.sortAbis();
    }

    private void sortAbis() {
        if (this.abis.size() > 1) {
            this.abis.sort(Comparator.comparing(Abi::toString));
        }
    }

    private void doAddSharedObjectFile(@NotNull VirtualFile file) {
        if (file == null) {
            NativeLibrary.$$$reportNull$$$0(9);
        }
        Abi abi = NativeLibrary.extractAbiFrom(file);
        this.sharedObjectFilesByAbi.put(abi, file);
        this.abis.add(abi);
        this.mySharedObjectFilePaths.add(file.getPath());
    }

    @NotNull
    private static Abi extractAbiFrom(@NotNull VirtualFile file) {
        if (file == null) {
            NativeLibrary.$$$reportNull$$$0(10);
        }
        VirtualFile parent = file.getParent();
        assert (parent != null);
        String folderName = parent.getName();
        Abi abi = Abi.getEnum((String)folderName);
        if (abi == null) {
            throw new IllegalArgumentException("Failed to find ABI for file: '" + FileUtil.toSystemDependentName((String)file.getPath()) + "'");
        }
        Abi abi2 = abi;
        if (abi2 == null) {
            NativeLibrary.$$$reportNull$$$0(11);
        }
        return abi2;
    }

    public boolean isMissingPathMappings() {
        for (String mappedPath : this.pathMappings.values()) {
            if (!StringUtil.isEmpty((String)mappedPath)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DebuggableSharedObjectFile addDebuggableSharedObjectFile(@NotNull Abi abi, @NotNull VirtualFile file) {
        if (abi == null) {
            NativeLibrary.$$$reportNull$$$0(12);
        }
        if (file == null) {
            NativeLibrary.$$$reportNull$$$0(13);
        }
        this.hasDebugSymbols = true;
        DebuggableSharedObjectFile sharedObjectFile = new DebuggableSharedObjectFile(file);
        this.debuggableSharedObjectFilesByAbi.put(abi, sharedObjectFile);
        this.clearSourceFolderCache();
        DebuggableSharedObjectFile debuggableSharedObjectFile = sharedObjectFile;
        if (debuggableSharedObjectFile == null) {
            NativeLibrary.$$$reportNull$$$0(14);
        }
        return debuggableSharedObjectFile;
    }

    private void clearSourceFolderCache() {
        this.sourceFolderPaths = null;
    }

    @NotNull
    public List<String> getUserSelectedPathsInMappings() {
        Collection<String> values = this.pathMappings.values();
        List<String> list = values.isEmpty() ? Collections.emptyList() : values.stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList());
        if (list == null) {
            NativeLibrary.$$$reportNull$$$0(15);
        }
        return list;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public List<String> getSourceFolderPaths() {
        if (this.sourceFolderPaths != null) {
            List<String> list = this.sourceFolderPaths;
            if (list == null) {
                NativeLibrary.$$$reportNull$$$0(16);
            }
            return list;
        }
        this.recalculateSourceFolderPaths();
        List<String> list = this.sourceFolderPaths;
        if (list == null) {
            NativeLibrary.$$$reportNull$$$0(17);
        }
        return list;
    }

    public void recalculateSourceFolderPaths() {
        if (this.debuggableSharedObjectFilesByAbi.isEmpty()) {
            this.sourceFolderPaths = Collections.emptyList();
            return;
        }
        this.sourceFolderPaths = new ArrayList<String>();
        for (DebuggableSharedObjectFile sharedObjectFile : this.debuggableSharedObjectFilesByAbi.values()) {
            for (String debugSymbolPath : sharedObjectFile.debugSymbolPaths) {
                File path2 = new File(debugSymbolPath);
                if (path2.toPath().isAbsolute() && path2.exists()) {
                    this.sourceFolderPaths.add(debugSymbolPath);
                    continue;
                }
                String mappedPath = this.pathMappings.get(debugSymbolPath);
                if (!StringUtil.isNotEmpty((String)mappedPath) || !(path2 = new File(mappedPath)).toPath().isAbsolute() || !path2.exists()) continue;
                this.sourceFolderPaths.add(mappedPath);
            }
        }
        if (this.sourceFolderPaths.size() > 1) {
            this.sourceFolderPaths.sort(Comparator.naturalOrder());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeLibrary library = (NativeLibrary)o;
        return this.hasDebugSymbols == library.hasDebugSymbols && Objects.equals(this.name, library.name) && Objects.equals(this.pathMappings, library.pathMappings) && Objects.equals(this.mySharedObjectFilePaths, library.mySharedObjectFilePaths) && Objects.equals(this.debuggableSharedObjectFilesByAbi, library.debuggableSharedObjectFilesByAbi);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pathMappings, this.mySharedObjectFilePaths, this.debuggableSharedObjectFilesByAbi, this.hasDebugSymbols);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/debugging/NativeLibrary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedObjectFilePaths";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPathMappings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/debugging/NativeLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedObjectFilePaths";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractAbiFrom";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addDebuggableSharedObjectFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSelectedPathsInMappings";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolderPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSharedObjectFilePaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsMappingForRemotePath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePathMapping";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMappingsWith";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSharedObjectFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doAddSharedObjectFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractAbiFrom";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addDebuggableSharedObjectFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

