/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.apk.analyzer.internal.ProguardMappingFiles;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectProguardMapsDialog {
    private final Project myProject;
    @Nullable
    private final VirtualFile myApkFolder;
    private ProguardMappingFiles myMappingFiles;

    public SelectProguardMapsDialog(@NotNull Project project, @Nullable VirtualFile apkFolder) {
        if (project == null) {
            SelectProguardMapsDialog.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myApkFolder = apkFolder;
    }

    public boolean showAndGet() throws IOException {
        FileChooserDescriptor desc = new FileChooserDescriptor(true, true, false, false, false, true);
        desc.setDescription("Please select the proguard mapping files (mapping, seeds or usage) or a folder containing these files.");
        desc.withFileFilter(file -> "txt".equals(file.getExtension()) && (file.getName().contains("mapping") || file.getName().contains("seeds") || file.getName().contains("usage")));
        VirtualFile[] files2 = FileChooser.chooseFiles((FileChooserDescriptor)desc, (Project)this.myProject, this.myApkFolder != null ? SelectProguardMapsDialog.getDefaultFolderToSelect(this.myApkFolder) : null);
        if (files2.length == 0) {
            return false;
        }
        Path[] paths = new Path[files2.length];
        for (int i2 = 0; i2 < files2.length; ++i2) {
            paths[i2] = VfsUtilCore.virtualToIoFile((VirtualFile)files2[i2]).toPath();
        }
        this.myMappingFiles = ProguardMappingFiles.from((Path[])paths);
        return true;
    }

    @VisibleForTesting
    static VirtualFile getDefaultFolderToSelect(@NotNull VirtualFile apkFolder) {
        VirtualFile mappingFolder;
        if (apkFolder == null) {
            SelectProguardMapsDialog.$$$reportNull$$$0(1);
        }
        String buildTypeName = null;
        VirtualFile folderToSelect = apkFolder;
        if (folderToSelect.getParent() != null) {
            VirtualFile parentFolder = folderToSelect.getParent();
            if ("apk".equals(parentFolder.getName())) {
                buildTypeName = folderToSelect.getName();
                if (parentFolder.getParent() != null) {
                    folderToSelect = parentFolder.getParent();
                }
            } else {
                folderToSelect = parentFolder;
            }
        }
        if ((mappingFolder = folderToSelect.findChild("mapping")) != null) {
            VirtualFile buildTypeFolder;
            folderToSelect = mappingFolder;
            if (folderToSelect.getChildren().length == 1) {
                folderToSelect = folderToSelect.getChildren()[0];
            } else if (buildTypeName != null && (buildTypeFolder = folderToSelect.findChild(buildTypeName)) != null) {
                folderToSelect = buildTypeFolder;
            }
        }
        return folderToSelect;
    }

    @NotNull
    public ProguardMappingFiles getMappingFiles() {
        ProguardMappingFiles proguardMappingFiles = this.myMappingFiles;
        if (proguardMappingFiles == null) {
            SelectProguardMapsDialog.$$$reportNull$$$0(2);
        }
        return proguardMappingFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/dex/SelectProguardMapsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/SelectProguardMapsDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFolderToSelect";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

