/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.lint.BackgroundEditorHighlighter;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditor
extends UserDataHolderBase
implements FileEditor {
    protected final Project myProject;
    protected final VirtualFile myFile;
    private DesignerEditorPanel myEditorPanel;
    private BackgroundEditorHighlighter myBackgroundHighlighter;

    public DesignerEditor(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            DesignerEditor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DesignerEditor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFile = file;
    }

    @NotNull
    public abstract String getEditorId();

    @NotNull
    protected abstract DesignerEditorPanel createEditorPanel();

    @NotNull
    public DesignerEditorPanel getComponent() {
        if (this.myEditorPanel == null) {
            this.myEditorPanel = this.createEditorPanel();
            Disposer.register((Disposable)this, (Disposable)this.myEditorPanel);
        }
        DesignerEditorPanel designerEditorPanel = this.myEditorPanel;
        if (designerEditorPanel == null) {
            DesignerEditor.$$$reportNull$$$0(2);
        }
        return designerEditorPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getComponent().getPreferredFocusedComponent();
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            DesignerEditor.$$$reportNull$$$0(3);
        }
    }

    public void dispose() {
    }

    public void selectNotify() {
        if (((Boolean)StudioFlags.NELE_SPLIT_EDITOR.get()).booleanValue()) {
            return;
        }
        if (ArrayUtil.contains((Object)((Object)this), (Object[])FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors())) {
            this.getComponent().activate();
        }
    }

    public void deselectNotify() {
        if (((Boolean)StudioFlags.NELE_SPLIT_EDITOR.get()).booleanValue()) {
            return;
        }
        if (!ArrayUtil.contains((Object)((Object)this), (Object[])FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors())) {
            this.getComponent().deactivate();
        }
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public boolean isModified() {
        return false;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            DesignerEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            DesignerEditor.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new BackgroundEditorHighlighter(this.myEditorPanel);
        }
        BackgroundEditorHighlighter backgroundEditorHighlighter = this.myBackgroundHighlighter;
        if (backgroundEditorHighlighter == null) {
            DesignerEditor.$$$reportNull$$$0(6);
        }
        return backgroundEditorHighlighter;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            DesignerEditor.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/DesignerEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/DesignerEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundHighlighter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

