/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class DrawComponentBackground
extends DrawRegion {
    public static final int SUBDUED = 0;
    public static final int NORMAL = 1;
    public static final int OVER = 2;
    public static final int SELECTED = 3;
    private final int myMode;

    public DrawComponentBackground(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
    }

    @Override
    public int getLevel() {
        return 20;
    }

    public DrawComponentBackground(int x, int y, int width, int height, int mode) {
        super(x, y, width, height);
        this.myMode = mode;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color[] colorBackground = new Color[]{colorSet.getComponentBackground(), colorSet.getComponentBackground(), colorSet.getComponentHighlightedBackground(), colorSet.getComponentHighlightedBackground(), colorSet.getDragReceiverBackground()};
        g.setColor(colorBackground[this.myMode]);
        g.fillRect(this.x, this.y, this.width, this.height);
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode;
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, int mode) {
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        list.add(new DrawComponentBackground(l, t, w, h, mode));
    }
}

