/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionHandlerKt;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SceneViewHelper;
import com.android.tools.idea.common.surface.ScrollInteraction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016J$\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016J\"\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016J\"\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/common/surface/InteractionHandlerBase;", "Lcom/android/tools/idea/common/surface/InteractionHandler;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "cursorWhenNoInteraction", "Ljava/awt/Cursor;", "createInteractionOnDragEnter", "Lcom/android/tools/idea/common/surface/Interaction;", "dragEvent", "Ljava/awt/dnd/DropTargetDragEvent;", "createInteractionOnMouseWheelMoved", "mouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "doubleClick", "", "x", "", "y", "modifiersEx", "getCursorWhenNoInteraction", "mouseX", "mouseY", "hoverWhenNoInteraction", "mouseReleaseWhenNoInteraction", "popupMenuTrigger", "mouseEvent", "Ljava/awt/event/MouseEvent;", "singleClick", "intellij.android.designer"})
public abstract class InteractionHandlerBase
implements InteractionHandler {
    private Cursor cursorWhenNoInteraction;
    private final DesignSurface surface;

    @Override
    @Nullable
    public Interaction createInteractionOnDragEnter(@NotNull DropTargetDragEvent dragEvent) {
        Intrinsics.checkNotNullParameter((Object)dragEvent, (String)"dragEvent");
        NlDropEvent event = new NlDropEvent(dragEvent);
        Point location = dragEvent.getLocation();
        int mouseX = location.x;
        int mouseY = location.y;
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            event.reject();
            return null;
        }
        NlModel nlModel = sceneView.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"sceneView.model");
        NlModel model2 = nlModel;
        DnDTransferItem item = DnDTransferItem.getTransferItem(event.getTransferable(), true);
        if (item == null) {
            event.reject();
            return null;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        InsertType insertType = model2.determineInsertType(dragType, item, true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)insertType), (String)"model.determineInsertTyp\u2026item, true /* preview */)");
        InsertType insertType2 = insertType;
        List dragged = null;
        Object object = StudioFlags.NELE_DRAG_PLACEHOLDER.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.NELE_DRAG_PLACEHOLDER.get()");
        if (((Boolean)object).booleanValue() && !item.isFromPalette()) {
            SelectionModel selectionModel = this.surface.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"surface.selectionModel");
            dragged = new ArrayList((Collection)selectionModel.getSelection());
        } else {
            if (item.isFromPalette()) {
                this.surface.getSelectionModel().clear();
            }
            List list = model2.createComponents(item, insertType2, this.surface);
            Intrinsics.checkNotNullExpressionValue(list, (String)"model.createComponents(item, insertType, surface)");
            dragged = list;
        }
        if (dragged.isEmpty()) {
            event.reject();
            return null;
        }
        DragDropInteraction interaction = new DragDropInteraction(this.surface, dragged);
        interaction.setType(dragType);
        interaction.setTransferItem(item);
        event.accept(insertType2);
        return interaction;
    }

    @Override
    public void mouseReleaseWhenNoInteraction(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        block0: {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Intrinsics.checkNotNullExpressionValue((Object)toolkit, (String)"Toolkit.getDefaultToolkit()");
            boolean allowToggle = (modifiersEx & (1 | toolkit.getMenuShortcutKeyMask())) != 0;
            SceneView sceneView = this.surface.getSceneView(x, y);
            if (sceneView == null) break block0;
            SceneViewHelper.selectComponentAt(sceneView, x, y, modifiersEx, allowToggle, false);
        }
    }

    @Override
    public void hoverWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        Object object = StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()");
        if (((Boolean)object).booleanValue()) {
            SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
            if (sceneView != null) {
                SceneContext sceneContext = sceneView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)sceneContext, (String)"sceneView.context");
                SceneContext context = sceneContext;
                context.setMouseLocation(mouseX, mouseY);
                sceneView.getScene().mouseHover(context, Coordinates.getAndroidXDip(sceneView, mouseX), Coordinates.getAndroidYDip(sceneView, mouseY), modifiersEx);
                Scene scene = sceneView.getScene();
                Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"sceneView.scene");
                this.cursorWhenNoInteraction = scene.getMouseCursor();
            } else {
                this.cursorWhenNoInteraction = null;
            }
        }
        for (Layer layer : this.surface.getLayers()) {
            layer.onHover(mouseX, mouseY);
        }
    }

    @Override
    public void popupMenuTrigger(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        int modifiersEx = mouseEvent.getModifiersEx();
        SceneView sceneView = this.surface.getSceneView(x, y);
        if (sceneView != null) {
            NlComponent component3 = SceneViewHelper.selectComponentAt(sceneView, x, y, modifiersEx, false, true);
            this.surface.getActionManager().showPopup(mouseEvent, component3);
        }
    }

    @Override
    @Nullable
    public Interaction createInteractionOnMouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelEvent, (String)"mouseWheelEvent");
        int x = mouseWheelEvent.getX();
        int y = mouseWheelEvent.getY();
        SceneView sceneView = this.surface.getSceneView(x, y);
        if (sceneView == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(x, y) ?: return null");
        SceneView sceneView2 = sceneView;
        NlComponent nlComponent = Coordinates.findComponent(sceneView2, x, y);
        if (nlComponent == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"Coordinates.findComponen\u2026iew, x, y) ?: return null");
        NlComponent component3 = nlComponent;
        return ScrollInteraction.createScrollInteraction(sceneView2, component3);
    }

    @Override
    public void singleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        Object object = StudioFlags.NELE_SPLIT_EDITOR.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.NELE_SPLIT_EDITOR.get()");
        if (((Boolean)object).booleanValue()) {
            DesignToolsSplitEditor splitEditor;
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.surface.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(surface.project)");
            FileEditor selectedEditor = fileEditorManager.getSelectedEditor();
            if (selectedEditor instanceof DesignToolsSplitEditor && (splitEditor = (DesignToolsSplitEditor)selectedEditor).isSplitMode()) {
                SceneView sceneView = this.surface.getSceneView(x, y);
                if (sceneView == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(x, y) ?: return");
                SceneView sceneView2 = sceneView;
                NlComponent component3 = Coordinates.findComponent(sceneView2, x, y);
                if (component3 != null) {
                    InteractionHandlerKt.navigateToComponent(component3, false);
                }
            }
        }
    }

    @Override
    public void doubleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        SceneView sceneView = this.surface.getSceneView(x, y);
        if (sceneView == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(x, y) ?: return");
        SceneView sceneView2 = sceneView;
        NlComponent component3 = Coordinates.findComponent(sceneView2, x, y);
        if (component3 != null) {
            this.surface.notifyComponentActivate(component3, Coordinates.getAndroidX(sceneView2, x), Coordinates.getAndroidY(sceneView2, y));
        }
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        Object object = StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()");
        if (((Boolean)object).booleanValue()) {
            return this.cursorWhenNoInteraction;
        }
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(mou\u2026X, mouseY) ?: return null");
        SceneView sceneView2 = sceneView;
        SceneContext sceneContext = sceneView2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)sceneContext, (String)"sceneView.context");
        SceneContext context = sceneContext;
        context.setMouseLocation(mouseX, mouseY);
        sceneView2.getScene().mouseHover(context, Coordinates.getAndroidXDip(sceneView2, mouseX), Coordinates.getAndroidYDip(sceneView2, mouseY), modifiersEx);
        Scene scene = sceneView2.getScene();
        Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"sceneView.scene");
        return scene.getMouseCursor();
    }

    public InteractionHandlerBase(@NotNull DesignSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)((Object)surface2), (String)"surface");
        this.surface = surface2;
    }
}

