/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.ui.AdtUiCursors;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceShortcut;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ScrollInteraction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.PanInteraction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class InteractionManager
implements Disposable {
    private static final int HOVER_DELAY_MS = Registry.intValue((String)"ide.tooltip.initialDelay");
    private static final int SCROLL_END_TIME_MS = 500;
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final InteractionHandler myInteractionHandler;
    @Nullable
    private Interaction myCurrentInteraction;
    @Nullable
    private List<Layer> myLayers;
    protected int myLastMouseX;
    protected int myLastMouseY;
    @JdkConstants.InputEventMask
    protected int myLastModifiersEx;
    private final Timer myHoverTimer;
    private final Timer myScrollEndTimer;
    private final ActionListener myScrollEndListener;
    private final Listener myListener;
    private DropTarget myDropTarget;
    private boolean myIsListening;
    private boolean myIsPanning;
    private boolean myIsInteractionCanceled;

    public InteractionManager(@NotNull DesignSurface surface2, @NotNull InteractionHandler provider2) {
        if (surface2 == null) {
            InteractionManager.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            InteractionManager.$$$reportNull$$$0(1);
        }
        this.mySurface = surface2;
        this.myInteractionHandler = provider2;
        Disposer.register((Disposable)surface2, (Disposable)this);
        this.myListener = new Listener();
        this.myHoverTimer = new Timer(HOVER_DELAY_MS, null);
        this.myHoverTimer.setRepeats(false);
        this.myScrollEndTimer = new Timer(500, null);
        this.myScrollEndTimer.setRepeats(false);
        this.myScrollEndListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractionManager.this.myScrollEndTimer.removeActionListener(this);
                if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                    InteractionManager.this.finishInteraction(e, false);
                } else {
                    InteractionManager.this.finishInteraction(0, 0, 0, false);
                }
            }
        };
    }

    public void dispose() {
        this.myHoverTimer.stop();
        this.myScrollEndTimer.stop();
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            InteractionManager.$$$reportNull$$$0(2);
        }
        return designSurface;
    }

    public boolean isPanning() {
        if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
            return this.myCurrentInteraction instanceof PanInteraction;
        }
        return this.myIsPanning;
    }

    public void startListening() {
        if (this.myIsListening) {
            return;
        }
        JComponent layeredPane = this.mySurface.getLayeredPane();
        layeredPane.addMouseMotionListener(this.myListener);
        layeredPane.addMouseWheelListener(this.myListener);
        layeredPane.addMouseListener(this.myListener);
        layeredPane.addKeyListener(this.myListener);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new DropTarget(this.mySurface.getLayeredPane(), 3, this.myListener, true, null);
        }
        this.myHoverTimer.addActionListener(this.myListener);
        this.myIsListening = true;
    }

    public void stopListening() {
        if (!this.myIsListening) {
            return;
        }
        JComponent layeredPane = this.mySurface.getLayeredPane();
        layeredPane.removeMouseMotionListener(this.myListener);
        layeredPane.removeMouseWheelListener(this.myListener);
        layeredPane.removeMouseListener(this.myListener);
        layeredPane.removeKeyListener(this.myListener);
        if (this.myDropTarget != null) {
            this.myDropTarget.removeDropTargetListener(this.myListener);
        }
        this.myHoverTimer.removeActionListener(this.myListener);
        this.myHoverTimer.stop();
        this.myIsListening = false;
    }

    private void startInteraction(@Nullable EventObject event, @Nullable Interaction interaction) {
        if (this.myCurrentInteraction != null) {
            this.finishInteraction(event, true);
            assert (this.myCurrentInteraction == null);
        }
        if (interaction != null) {
            this.myCurrentInteraction = interaction;
            this.myCurrentInteraction.begin(event, new InteractionInformation(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx));
            this.myLayers = interaction.createOverlays();
        }
    }

    private void startInteraction(int x, int y, @Nullable Interaction interaction, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.myCurrentInteraction != null) {
            this.finishInteraction(x, y, modifiersEx, true);
            assert (this.myCurrentInteraction == null);
        }
        if (interaction != null) {
            this.myCurrentInteraction = interaction;
            this.myCurrentInteraction.begin(x, y, modifiersEx);
            this.myLayers = interaction.createOverlays();
        }
    }

    @Nullable
    public List<Layer> getLayers() {
        return this.myLayers;
    }

    @JdkConstants.InputEventMask
    public int getLastModifiersEx() {
        return this.myLastModifiersEx;
    }

    @TestOnly
    public void setModifier(@JdkConstants.InputEventMask int modifier2) {
        this.myLastModifiersEx = modifier2;
    }

    private void updateMouseMoved(@NotNull MouseEvent event, int x, int y) {
        if (event == null) {
            InteractionManager.$$$reportNull$$$0(3);
        }
        if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
            if (this.myCurrentInteraction != null) {
                this.myCurrentInteraction.update(event, new InteractionInformation(x, y, this.myLastModifiersEx));
            } else {
                this.myInteractionHandler.hoverWhenNoInteraction(x, y, this.myLastModifiersEx);
            }
        } else if (this.myCurrentInteraction != null) {
            this.myCurrentInteraction.update(x, y, this.myLastModifiersEx);
        }
    }

    private void finishInteraction(@Nullable EventObject event, boolean canceled) {
        if (this.myCurrentInteraction != null) {
            if (canceled) {
                this.myCurrentInteraction.cancel(event, new InteractionInformation(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx));
            } else {
                this.myCurrentInteraction.commit(event, new InteractionInformation(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx));
            }
            if (this.myLayers != null) {
                for (Layer layer : this.myLayers) {
                    layer.dispose();
                }
                this.myLayers = null;
            }
            this.myCurrentInteraction = null;
            this.myLastModifiersEx = 0;
            if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                this.myInteractionHandler.hoverWhenNoInteraction(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
            }
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
            this.mySurface.repaint();
        }
    }

    private void finishInteraction(int x, int y, @JdkConstants.InputEventMask int modifiersEx, boolean canceled) {
        if (this.myCurrentInteraction != null) {
            if (!canceled) {
                this.myCurrentInteraction.end(x, y, modifiersEx);
            } else {
                this.myCurrentInteraction.cancel(x, y, modifiersEx);
            }
            if (this.myLayers != null) {
                for (Layer layer : this.myLayers) {
                    layer.dispose();
                }
                this.myLayers = null;
            }
            this.myCurrentInteraction = null;
            this.myLastModifiersEx = 0;
            this.updateCursor(x, y, modifiersEx);
            this.mySurface.repaint();
        }
    }

    void updateCursor(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
            Cursor cursor = this.myCurrentInteraction == null ? this.myInteractionHandler.getCursorWhenNoInteraction(x, y, modifiersEx) : this.myCurrentInteraction.getCursor();
            this.mySurface.setCursor(cursor != Cursor.getDefaultCursor() ? cursor : null);
        } else {
            Cursor cursor = this.myInteractionHandler.getCursorWhenNoInteraction(x, y, modifiersEx);
            this.mySurface.setCursor(cursor != Cursor.getDefaultCursor() ? cursor : null);
        }
    }

    public boolean isInteractionInProgress() {
        return this.myCurrentInteraction != null;
    }

    void setPanning(boolean panning) {
        if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
            if (panning && !(this.myCurrentInteraction instanceof PanInteraction)) {
                this.startInteraction(null, new PanInteraction(this.mySurface));
                this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
            } else if (!panning && this.myCurrentInteraction instanceof PanInteraction) {
                this.finishInteraction(null, false);
                this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
            }
        } else if (panning != this.myIsPanning) {
            this.myIsPanning = panning;
            this.mySurface.setCursor(panning ? AdtUiCursors.GRAB : Cursor.getDefaultCursor());
        }
    }

    public boolean interceptPanInteraction(@NotNull MouseEvent event) {
        if (event == null) {
            InteractionManager.$$$reportNull$$$0(4);
        }
        boolean wheelClickDown = SwingUtilities.isMiddleMouseButton(event);
        if (this.isPanning() || wheelClickDown) {
            boolean leftClickDown = SwingUtilities.isLeftMouseButton(event);
            this.mySurface.setCursor(leftClickDown || wheelClickDown ? AdtUiCursors.GRABBING : AdtUiCursors.GRAB);
            return true;
        }
        return false;
    }

    private static boolean isPanningKeyboardKey(@NotNull KeyEvent event) {
        if (event == null) {
            InteractionManager.$$$reportNull$$$0(5);
        }
        return event.getKeyCode() == DesignSurfaceShortcut.PAN.getKeyCode();
    }

    private void handlePanInteraction(int x, int y) {
        this.setPanning(true);
        PanInteraction.handlePanInteraction(this.mySurface, x, y, new InteractionInformation(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx));
    }

    public void cancelInteraction() {
        if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
            this.finishInteraction(null, true);
        } else {
            this.finishInteraction(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx, true);
        }
    }

    @VisibleForTesting
    public Object getListener() {
        return this.myListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/InteractionManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/InteractionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateMouseMoved";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "interceptPanInteraction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPanningKeyboardKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Listener
    implements MouseMotionListener,
    MouseListener,
    KeyListener,
    DropTargetListener,
    ActionListener,
    MouseWheelListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(0);
            }
            int x = event.getX();
            int y = event.getY();
            int clickCount = event.getClickCount();
            if (clickCount == 2 && event.getButton() == 1) {
                InteractionManager.this.myInteractionHandler.doubleClick(x, y, InteractionManager.this.myLastModifiersEx);
                return;
            }
            if (clickCount == 1 && event.getButton() == 1 && !event.isShiftDown() && !AdtUiUtils.isActionKeyDown((InputEvent)event)) {
                InteractionManager.this.myInteractionHandler.singleClick(x, y, InteractionManager.this.myLastModifiersEx);
            }
            if (event.isPopupTrigger()) {
                InteractionManager.this.myInteractionHandler.popupMenuTrigger(event);
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Interaction interaction;
            if (event == null) {
                Listener.$$$reportNull$$$0(1);
            }
            if (event.getID() == 501) {
                InteractionManager.this.mySurface.getLayeredPane().requestFocusInWindow();
            }
            InteractionManager.this.myIsInteractionCanceled = false;
            InteractionManager.this.myLastMouseX = event.getX();
            InteractionManager.this.myLastMouseY = event.getY();
            InteractionManager.this.myLastModifiersEx = event.getModifiersEx();
            if (event.isPopupTrigger()) {
                InteractionManager.this.myInteractionHandler.popupMenuTrigger(event);
                event.consume();
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction) {
                    InteractionManager.this.myCurrentInteraction.update(event, new InteractionInformation(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx));
                    InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                    return;
                }
                if (SwingUtilities.isMiddleMouseButton(event)) {
                    InteractionManager.this.startInteraction(event, new PanInteraction(InteractionManager.this.mySurface));
                    InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                    return;
                }
            } else if (InteractionManager.this.interceptPanInteraction(event)) {
                InteractionManager.this.handlePanInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
                return;
            }
            if ((interaction = InteractionManager.this.myInteractionHandler.createInteractionOnPressed(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx)) != null) {
                if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                    InteractionManager.this.startInteraction(event, interaction);
                } else {
                    InteractionManager.this.startInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, interaction, InteractionManager.this.myLastModifiersEx);
                }
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (InteractionManager.this.myIsInteractionCanceled) {
                return;
            }
            if (event.isPopupTrigger()) {
                InteractionManager.this.myInteractionHandler.popupMenuTrigger(event);
                return;
            }
            if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction) {
                if (SwingUtilities.isMiddleMouseButton(event)) {
                    InteractionManager.this.finishInteraction(event, true);
                } else {
                    InteractionManager.this.myCurrentInteraction.update(event, new InteractionInformation(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx));
                    InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                }
                return;
            }
            if (InteractionManager.this.interceptPanInteraction(event)) {
                if (SwingUtilities.isMiddleMouseButton(event)) {
                    InteractionManager.this.setPanning(false);
                }
                return;
            }
            if (event.getButton() > 1 || SystemInfo.isMac && event.isControlDown()) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            int modifiersEx = event.getModifiersEx();
            if (InteractionManager.this.myCurrentInteraction == null) {
                InteractionManager.this.myInteractionHandler.mouseReleaseWhenNoInteraction(x, y, modifiersEx);
                InteractionManager.this.updateCursor(x, y, modifiersEx);
            } else {
                if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                    InteractionManager.this.finishInteraction(event, false);
                } else {
                    InteractionManager.this.finishInteraction(x, y, modifiersEx, false);
                }
                InteractionManager.this.myCurrentInteraction = null;
            }
            InteractionManager.this.mySurface.repaint();
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(3);
            }
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(4);
            }
            InteractionManager.this.myHoverTimer.stop();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (InteractionManager.this.myIsInteractionCanceled) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction) {
                    InteractionManager.this.myCurrentInteraction.update(event, new InteractionInformation(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx));
                    InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                    return;
                }
            } else if (InteractionManager.this.interceptPanInteraction(event)) {
                InteractionManager.this.handlePanInteraction(x, y);
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(event)) {
                return;
            }
            int modifiersEx = event.getModifiersEx();
            if (InteractionManager.this.myCurrentInteraction != null) {
                InteractionManager.this.myLastMouseX = x;
                InteractionManager.this.myLastMouseY = y;
                InteractionManager.this.myLastModifiersEx = modifiersEx;
                if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                    InteractionManager.this.myCurrentInteraction.update(event, new InteractionInformation(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx));
                } else {
                    InteractionManager.this.myCurrentInteraction.update(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                }
                InteractionManager.this.updateCursor(x, y, modifiersEx);
                InteractionManager.this.mySurface.getLayeredPane().scrollRectToVisible(new Rectangle(x - 50, y - 50, 100, 100));
                InteractionManager.this.mySurface.repaint();
            } else {
                x = InteractionManager.this.myLastMouseX;
                y = InteractionManager.this.myLastMouseY;
                InteractionManager.this.myLastModifiersEx = modifiersEx;
                Interaction interaction = InteractionManager.this.myInteractionHandler.createInteractionOnDrag(x, y, InteractionManager.this.myLastModifiersEx);
                if (interaction != null) {
                    if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                        InteractionManager.this.startInteraction(event, interaction);
                    } else {
                        InteractionManager.this.startInteraction(x, y, interaction, modifiersEx);
                    }
                }
                InteractionManager.this.updateCursor(x, y, modifiersEx);
            }
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(5);
            }
            int x = event.getX();
            int y = event.getY();
            int modifiersEx = event.getModifiersEx();
            InteractionManager.this.myLastMouseX = x;
            InteractionManager.this.myLastMouseY = y;
            InteractionManager.this.myLastModifiersEx = modifiersEx;
            if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                if (InteractionManager.this.myCurrentInteraction instanceof PanInteraction) {
                    InteractionManager.this.myCurrentInteraction.update(event, new InteractionInformation(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx));
                    InteractionManager.this.updateCursor(x, y, modifiersEx);
                    return;
                }
            } else if (InteractionManager.this.interceptPanInteraction(event)) {
                InteractionManager.this.handlePanInteraction(x, y);
                return;
            }
            if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                InteractionManager.this.updateMouseMoved(event, x, y);
                InteractionManager.this.updateCursor(x, y, modifiersEx);
            } else {
                InteractionManager.this.myInteractionHandler.hoverWhenNoInteraction(x, y, modifiersEx);
                if ((InteractionManager.this.myLastModifiersEx & 0x400) != 0) {
                    if (InteractionManager.this.myCurrentInteraction != null) {
                        InteractionManager.this.updateMouseMoved(event, x, y);
                    }
                } else {
                    InteractionManager.this.updateCursor(x, y, modifiersEx);
                }
            }
            InteractionManager.this.mySurface.repaint();
            InteractionManager.this.myHoverTimer.restart();
        }

        @Override
        public void keyTyped(KeyEvent event) {
            InteractionManager.this.myLastModifiersEx = event.getModifiersEx();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            SelectionModel model2;
            SceneView sceneView;
            int modifiersEx = event.getModifiersEx();
            int keyCode = event.getKeyCode();
            InteractionManager.this.myLastModifiersEx = modifiersEx;
            Scene scene = InteractionManager.this.mySurface.getScene();
            if (scene != null) {
                scene.needsRebuildList();
                scene.repaint();
            }
            if (InteractionManager.this.myCurrentInteraction != null) {
                if (keyCode == 27) {
                    if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                        InteractionManager.this.finishInteraction(event, true);
                    } else {
                        InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx, true);
                    }
                    InteractionManager.this.myIsInteractionCanceled = true;
                    return;
                }
                if (InteractionManager.this.myCurrentInteraction.keyPressed(event)) {
                    return;
                }
            }
            if (InteractionManager.isPanningKeyboardKey(event)) {
                InteractionManager.this.setPanning(true);
                return;
            }
            if (event.isAltDown() || event.isMetaDown() || event.isShiftDown() || event.isControlDown()) {
                return;
            }
            if (!(keyCode != 127 && keyCode != 8 || (sceneView = InteractionManager.this.mySurface.getSceneView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY)) == null || (model2 = sceneView.getSelectionModel()).isEmpty() || ConstraintComponentUtilities.clearSelectedConstraint(InteractionManager.this.mySurface))) {
                ImmutableList<NlComponent> selection = model2.getSelection();
                sceneView.getModel().delete((Collection<NlComponent>)selection);
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            InteractionManager.this.myLastModifiersEx = event.getModifiersEx();
            Scene scene = InteractionManager.this.mySurface.getScene();
            if (scene != null) {
                scene.needsRebuildList();
                scene.repaint();
            }
            if (InteractionManager.this.myCurrentInteraction != null) {
                if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                    InteractionManager.this.myCurrentInteraction.update(event, new InteractionInformation(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx));
                } else {
                    InteractionManager.this.myCurrentInteraction.keyReleased(event);
                }
            }
            if (InteractionManager.isPanningKeyboardKey(event)) {
                InteractionManager.this.setPanning(false);
                InteractionManager.this.updateCursor(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
            }
        }

        @Override
        public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
            if (dragEvent == null) {
                Listener.$$$reportNull$$$0(6);
            }
            if (InteractionManager.this.myCurrentInteraction == null) {
                Point location = dragEvent.getLocation();
                InteractionManager.this.myLastMouseX = location.x;
                InteractionManager.this.myLastMouseY = location.y;
                Interaction interaction = InteractionManager.this.myInteractionHandler.createInteractionOnDragEnter(dragEvent);
                if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                    InteractionManager.this.startInteraction(dragEvent, interaction);
                } else {
                    InteractionManager.this.startInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, interaction, 0);
                }
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dragEvent) {
            Point location = dragEvent.getLocation();
            InteractionManager.this.myLastMouseX = location.x;
            InteractionManager.this.myLastMouseY = location.y;
            NlDropEvent event = new NlDropEvent(dragEvent);
            if (InteractionManager.this.myCurrentInteraction == null) {
                event.reject();
                return;
            }
            if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                InteractionManager.this.myCurrentInteraction.update(dragEvent, new InteractionInformation(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx));
            } else if (InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction) {
                SceneView sceneView = InteractionManager.this.mySurface.getSceneView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
                if (sceneView != null) {
                    DragDropInteraction interaction = (DragDropInteraction)InteractionManager.this.myCurrentInteraction;
                    interaction.update(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx);
                    if (interaction.acceptsDrop()) {
                        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
                        interaction.setType(dragType);
                        NlModel model2 = sceneView.getModel();
                        InsertType insertType = model2.determineInsertType(dragType, interaction.getTransferItem(), true);
                        event.accept(insertType);
                    } else {
                        event.reject();
                    }
                } else {
                    event.reject();
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            if (InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction) {
                if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                    InteractionManager.this.finishInteraction(event, true);
                } else {
                    InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx, true);
                }
            }
        }

        @Override
        public void drop(@NotNull DropTargetDropEvent dropEvent) {
            if (dropEvent == null) {
                Listener.$$$reportNull$$$0(7);
            }
            Point location = dropEvent.getLocation();
            InteractionManager.this.myLastMouseX = location.x;
            InteractionManager.this.myLastMouseY = location.y;
            NlDropEvent event = new NlDropEvent(dropEvent);
            if (!(InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction)) {
                event.reject();
                return;
            }
            if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                InteractionManager.this.finishInteraction(dropEvent, false);
            } else {
                DragDropInteraction interaction = (DragDropInteraction)InteractionManager.this.myCurrentInteraction;
                InsertType insertType = interaction.finishDropInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, event.getDropAction(), event.getTransferable());
                InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx, insertType == null);
                if (insertType != null) {
                    event.accept(insertType);
                    event.complete();
                } else {
                    event.reject();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != InteractionManager.this.myHoverTimer) {
                return;
            }
            int x = InteractionManager.this.myLastMouseX;
            int y = InteractionManager.this.myLastMouseY;
            for (Layer layer : InteractionManager.this.mySurface.getLayers()) {
                layer.onHover(x, y);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int scrollAmount;
            int x = e.getX();
            int y = e.getY();
            if (e.getScrollType() == 0) {
                scrollAmount = e.getUnitsToScroll();
            } else {
                int n = scrollAmount = e.getWheelRotation() < 0 ? -1 : 1;
            }
            if (!e.isShiftDown() && (SystemInfo.isMac && e.isMetaDown() || e.isControlDown())) {
                if (scrollAmount < 0) {
                    InteractionManager.this.mySurface.zoom(ZoomType.IN, x, y);
                } else if (scrollAmount > 0) {
                    InteractionManager.this.mySurface.zoom(ZoomType.OUT, x, y);
                }
                return;
            }
            if (InteractionManager.this.myCurrentInteraction == null) {
                Interaction scrollInteraction = InteractionManager.this.myInteractionHandler.createInteractionOnMouseWheelMoved(e);
                if (scrollInteraction == null) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
                if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                    InteractionManager.this.startInteraction(e, scrollInteraction);
                } else {
                    InteractionManager.this.startInteraction(x, y, scrollInteraction, 0);
                }
                InteractionManager.this.myScrollEndTimer.addActionListener(InteractionManager.this.myScrollEndListener);
            } else {
                SceneView sceneView = InteractionManager.this.mySurface.getSceneView(x, y);
                if (sceneView == null) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
                NlComponent component3 = Coordinates.findComponent(sceneView, x, y);
                if (component3 == null) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
            }
            boolean isScrollInteraction = InteractionManager.this.myCurrentInteraction instanceof ScrollInteraction;
            if (((Boolean)StudioFlags.NELE_NEW_INTERACTION_INTERFACE.get()).booleanValue()) {
                InteractionManager.this.myCurrentInteraction.update(e, new InteractionInformation(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, InteractionManager.this.myLastModifiersEx));
            } else {
                if (isScrollInteraction && !((ScrollInteraction)InteractionManager.this.myCurrentInteraction).canScroll(scrollAmount)) {
                    JScrollPane scrollPane = InteractionManager.this.mySurface.getScrollPane();
                    JViewport viewport = scrollPane.getViewport();
                    Dimension extentSize = viewport.getExtentSize();
                    Dimension viewSize = viewport.getViewSize();
                    if (viewSize.width > extentSize.width || viewSize.height > extentSize.height) {
                        e.getComponent().getParent().dispatchEvent(e);
                        return;
                    }
                }
                InteractionManager.this.myCurrentInteraction.scroll(e.getX(), e.getY(), scrollAmount);
            }
            if (isScrollInteraction) {
                InteractionManager.this.myScrollEndTimer.restart();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragEvent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dropEvent";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/common/surface/InteractionManager$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragEnter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

