/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.avdmanager.AvdManagerUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.DeviceGroup;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u0002\u001a \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\n\u001a\u00020\u0002\u001a&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\"\u009f\u0001\u0010\u0000\u001a\u0092\u0001\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u00120\u0012.\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006 \u0003*\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u00040\u0004 \u0003*G\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u00120\u0012.\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006 \u0003*\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u00040\u00040\u0004\u00a2\u0006\u0002\b\b0\u0001\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"DEVICE_CACHES", "", "Lcom/android/tools/idea/configurations/Configuration;", "kotlin.jvm.PlatformType", "", "Lcom/android/tools/idea/configurations/DeviceGroup;", "", "Lcom/android/sdklib/devices/Device;", "Lorg/jetbrains/annotations/NotNull;", "getAvdDevices", "configuration", "getSuitableDevices", "groupDevices", "devices", "sizeGroupNexus", "device", "intellij.android.core"})
@JvmName(name="DeviceUtils")
public final class DeviceUtils {
    private static final Map<Configuration, Map<DeviceGroup, List<Device>>> DEVICE_CACHES;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<DeviceGroup, List<Device>> getSuitableDevices(@NotNull Configuration configuration) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Map<Configuration, Map<DeviceGroup, List<Device>>> $this$getOrPut$iv = DEVICE_CACHES;
        boolean $i$f$getOrPut = false;
        Map<DeviceGroup, List<Device>> value$iv = $this$getOrPut$iv.get(configuration);
        if (value$iv == null) {
            boolean bl = false;
            ConfigurationManager configurationManager = configuration.getConfigurationManager();
            Intrinsics.checkNotNullExpressionValue((Object)configurationManager, (String)"configuration.configurationManager");
            ImmutableList<Device> immutableList = configurationManager.getDevices();
            Intrinsics.checkNotNullExpressionValue(immutableList, (String)"configuration.configurationManager.devices");
            return DeviceUtils.groupDevices((List)immutableList);
        }
        return (Map)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<DeviceGroup, List<Device>> groupDevices(@NotNull List<Device> devices2) {
        void $this$groupByTo$iv$iv;
        Device it;
        void $this$filterNotTo$iv$iv222;
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Iterable $this$filterNot$iv = devices2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv222) {
            it = (Device)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)"Custom", (Object)it.getId()) || ConfigurationManager.isAvdDevice(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        boolean $this$filterNotTo$iv$iv222 = false;
        Iterable $this$apply = $this$filterNot$iv;
        boolean bl = false;
        HardwareConfigHelper.sortDevicesByScreenSize((List)$this$apply);
        Iterable $this$groupBy$iv = $this$filterNot$iv;
        boolean $i$f$groupBy = false;
        Iterable $this$filterNotTo$iv$iv222 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Device)element$iv$iv;
            boolean bl2 = false;
            DeviceGroup key$iv$iv = HardwareConfigHelper.isAutomotive((Device)it) ? DeviceGroup.AUTOMOTIVE : (HardwareConfigHelper.isWear((Device)it) ? DeviceGroup.WEAR : (HardwareConfigHelper.isTv((Device)it) ? DeviceGroup.TV : (HardwareConfigHelper.isNexus((Device)it) && Intrinsics.areEqual((Object)it.getManufacturer(), (Object)"Generic") ^ true ? DeviceUtils.sizeGroupNexus(it) : (HardwareConfigHelper.isMobile((Device)it) ? DeviceGroup.GENERIC : DeviceGroup.OTHER))));
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return MapsKt.toSortedMap((Map)destination$iv$iv);
    }

    private static final DeviceGroup sizeGroupNexus(Device device) {
        Hardware hardware = device.getDefaultHardware();
        Intrinsics.checkNotNullExpressionValue((Object)hardware, (String)"device.defaultHardware");
        Screen screen = hardware.getScreen();
        Intrinsics.checkNotNullExpressionValue((Object)screen, (String)"device.defaultHardware.screen");
        double diagonalLength = screen.getDiagonalLength();
        return diagonalLength < (double)5 ? DeviceGroup.NEXUS : (diagonalLength < 6.5 ? DeviceGroup.NEXUS_XL : DeviceGroup.NEXUS_TABLET);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Device> getAvdDevices(@NotNull Configuration configuration) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)configuration.getModule());
        if (androidFacet == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"AndroidFacet.getInstance\u2026le) ?: return emptyList()");
        AndroidFacet facet2 = androidFacet;
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        Intrinsics.checkNotNullExpressionValue((Object)configurationManager, (String)"configuration.configurationManager");
        ConfigurationManager configurationManager2 = configurationManager;
        AvdManager avdManager = AvdManagerUtils.getAvdManagerSilently(facet2);
        if (avdManager == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)avdManager, (String)"AvdManagerUtils.getAvdMa\u2026et) ?: return emptyList()");
        AvdManager avdManager2 = avdManager;
        AvdInfo[] avdInfoArray = avdManager2.getValidAvds();
        Intrinsics.checkNotNullExpressionValue((Object)avdInfoArray, (String)"avdManager.validAvds");
        AvdInfo[] $this$mapNotNull$iv = avdInfoArray;
        boolean $i$f$mapNotNull = false;
        AvdInfo[] avdInfoArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var11_11 = $this$forEach$iv$iv$iv;
        int n = ((void)var11_11).length;
        for (int j = 0; j < n; ++j) {
            Device device;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var11_11[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (configurationManager2.createDeviceForAvd((AvdInfo)it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Device it$iv$iv = device;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        Map map2 = ContainerUtil.createSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"ContainerUtil.createSoft\u2026ceGroup, List<Device>>>()");
        DEVICE_CACHES = map2;
    }
}

