/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class DesugarUtils {
    @NotNull
    public static List<ClassPrepareRequest> addExtraPrepareRequestsIfNeeded(@NotNull DebugProcess debugProcess, final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position, @NotNull List<ClassPrepareRequest> requests) {
        if (debugProcess == null) {
            DesugarUtils.$$$reportNull$$$0(0);
        }
        if (requestor == null) {
            DesugarUtils.$$$reportNull$$$0(1);
        }
        if (position == null) {
            DesugarUtils.$$$reportNull$$$0(2);
        }
        if (requests == null) {
            DesugarUtils.$$$reportNull$$$0(3);
        }
        List list = (List)ReadAction.compute(() -> {
            PsiMethod methodHolder;
            PsiClass classHolder = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position.getElementAt(), PsiClass.class);
            if (classHolder != null && classHolder.isInterface() && (methodHolder = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position.getElementAt(), PsiMethod.class)) != null && methodHolder.getBody() != null) {
                String classPattern = classHolder.getQualifiedName() + "$*";
                ClassPrepareRequestor trampolinePrepareRequestor = new ClassPrepareRequestor(){

                    public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                        List locationsOfPosition;
                        try {
                            locationsOfPosition = debuggerProcess.getPositionManager().locationsOfLine(referenceType, position);
                        }
                        catch (NoDataException e) {
                            locationsOfPosition = Collections.emptyList();
                        }
                        if (!locationsOfPosition.isEmpty()) {
                            requestor.processClassPrepare(debuggerProcess, referenceType);
                        }
                    }
                };
                ClassPrepareRequest request = debugProcess.getRequestsManager().createClassPrepareRequest(trampolinePrepareRequestor, classPattern);
                if (request != null) {
                    requests.add(request);
                }
            }
            return requests;
        });
        if (list == null) {
            DesugarUtils.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<ReferenceType> addExtraClassesIfNeeded(@NotNull DebugProcess debugProcess, @NotNull SourcePosition position, @NotNull List<ReferenceType> types, @NotNull PositionManager positionManager) throws NoDataException {
        if (debugProcess == null) {
            DesugarUtils.$$$reportNull$$$0(5);
        }
        if (position == null) {
            DesugarUtils.$$$reportNull$$$0(6);
        }
        if (types == null) {
            DesugarUtils.$$$reportNull$$$0(7);
        }
        if (positionManager == null) {
            DesugarUtils.$$$reportNull$$$0(8);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)debugProcess.getProject());
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)debugProcess.getProject());
        List candidatesForDesugaringCompanion = types.stream().filter(type -> (Boolean)ReadAction.compute(() -> {
            PsiClass psiClass = javaPsiFacade.findClass(type.name(), globalSearchScope);
            return psiClass != null && DesugarUtils.canBeTransformedForDesugaring(psiClass);
        })).collect(Collectors.toList());
        if (candidatesForDesugaringCompanion.isEmpty()) {
            List<ReferenceType> list = types;
            if (list == null) {
                DesugarUtils.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<ReferenceType> newReferenceTypes = new ArrayList<ReferenceType>(types);
        List allLoadedTypes = debugProcess.getVirtualMachineProxy().allClasses();
        for (ReferenceType candidateType : candidatesForDesugaringCompanion) {
            String innerClassNamePrefix = candidateType.name() + "$";
            for (ReferenceType type2 : allLoadedTypes) {
                if (!type2.name().startsWith(innerClassNamePrefix) || positionManager.locationsOfLine(type2, position).isEmpty()) continue;
                newReferenceTypes.add(type2);
            }
        }
        ArrayList<ReferenceType> arrayList = newReferenceTypes;
        if (arrayList == null) {
            DesugarUtils.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static boolean canBeTransformedForDesugaring(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            DesugarUtils.$$$reportNull$$$0(11);
        }
        if (!psiClass.isInterface()) {
            return false;
        }
        return StreamEx.of((Object[])psiClass.getMethods()).anyMatch(m -> m.getBody() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/debug/DesugarUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/debug/DesugarUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addExtraPrepareRequestsIfNeeded";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addExtraClassesIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExtraPrepareRequestsIfNeeded";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addExtraClassesIfNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeTransformedForDesugaring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

