/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.report.DiagnosticReport;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class StudioReportDatabase {
    private final Object myDbLock;
    @GuardedBy(value="myDbLock")
    private final Path myDb;

    public StudioReportDatabase(@NotNull File databaseFile) {
        if (databaseFile == null) {
            StudioReportDatabase.$$$reportNull$$$0(0);
        }
        this(databaseFile.toPath());
    }

    public StudioReportDatabase(@NotNull Path databasePath) {
        if (databasePath == null) {
            StudioReportDatabase.$$$reportNull$$$0(1);
        }
        this.myDbLock = new Object();
        this.myDb = databasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DiagnosticReport> reapReports() {
        ImmutableList result2;
        Object object = this.myDbLock;
        synchronized (object) {
            try {
                result2 = this.getReports();
            }
            catch (Exception e) {
                result2 = ImmutableList.of();
            }
            try {
                Files.write(this.myDb, new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                result2 = ImmutableList.of();
            }
        }
        ImmutableList immutableList = result2;
        if (immutableList == null) {
            StudioReportDatabase.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<DiagnosticReport> getReports() throws IOException {
        ArrayList<DiagnosticReport> arrayList;
        InputStreamReader reader;
        Object object = this.myDbLock;
        synchronized (object) {
            if (!Files.exists(this.myDb, new LinkOption[0]) || Files.size(this.myDb) == 0L) {
                ImmutableList immutableList = ImmutableList.of();
                // MONITOREXIT @DISABLED, blocks:[5, 11] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                if (immutableList == null) {
                    StudioReportDatabase.$$$reportNull$$$0(3);
                }
                return immutableList;
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(this.myDb.toFile()), StandardCharsets.UTF_8);
            ArrayList<DiagnosticReport> arrayList2 = DiagnosticReport.Companion.readDiagnosticReports(reader);
            // MONITOREXIT @DISABLED, blocks:[2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            StudioReportDatabase.$$$reportNull$$$0(4);
        }
        return arrayList;
        {
            finally {
                ((Reader)reader).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendReport(DiagnosticReport report2) throws IOException {
        try (StringWriter sw = new StringWriter();){
            report2.serializeReport(sw);
            String content2 = sw.toString() + "\n";
            Object object = this.myDbLock;
            synchronized (object) {
                Files.write(this.myDb, content2.getBytes(Charsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databasePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/StudioReportDatabase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/StudioReportDatabase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reapReports";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

