/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.idea.diagnostics.error.SubmitCrashReportTask;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.ide.DataManager;
import com.intellij.idea.IdeaLogger;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.diagnostics.error.IdeaITNProxy;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ErrorReporter
extends ErrorReportSubmitter {
    private static final String FEEDBACK_TASK_TITLE = "Submitting error report";

    @NotNull
    public String getReportActionText() {
        String string = AndroidBundle.message("error.report.to.google.action", new Object[0]);
        if (string == null) {
            ErrorReporter.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, String description, Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> callback2) {
        if (events == null) {
            ErrorReporter.$$$reportNull$$$0(1);
        }
        if (callback2 == null) {
            ErrorReporter.$$$reportNull$$$0(2);
        }
        IdeaLoggingEvent event = events[0];
        ErrorBean bean = new ErrorBean(event.getThrowable(), IdeaLogger.ourLastActionId);
        bean.setDescription(description);
        bean.setMessage(event.getMessage());
        Pair pluginInfo = IdeErrorsDialog.getPluginInfo((IdeaLoggingEvent)event);
        if (pluginInfo != null) {
            bean.setPluginName((String)pluginInfo.first);
            bean.setPluginVersion((String)pluginInfo.second);
        }
        Object data = event.getData();
        if (ErrorReporter.handleAnalyticsReports(event.getThrowable(), data)) {
            return true;
        }
        if (data instanceof AbstractMessage) {
            bean.setAttachments(((AbstractMessage)data).getIncludedAttachments());
        }
        java.util.function.Consumer<DataContext> submitter = dataContext -> {
            Task.Backgroundable feedbackTask;
            if (dataContext == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            Consumer successCallback = token -> {
                SubmittedReportInfo reportInfo = new SubmittedReportInfo(null, "Issue " + token, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
                callback2.consume((Object)reportInfo);
                ReportMessages.GROUP.createNotification(ReportMessages.getErrorReport(), "Submitted", NotificationType.INFORMATION, null).setImportant(false).notify(project);
            };
            Consumer errorCallback = e -> {
                String message2 = AndroidBundle.message("error.report.at.b.android", e.getMessage());
                ReportMessages.GROUP.createNotification(ReportMessages.getErrorReport(), message2, NotificationType.ERROR, NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(project);
            };
            if (data instanceof ErrorReportCustomizer) {
                feedbackTask = ((ErrorReportCustomizer)data).makeReportingTask(project, FEEDBACK_TASK_TITLE, true, bean, (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
            } else {
                List<Pair<String, String>> kv = IdeaITNProxy.getKeyValuePairs(null, null, bean, ApplicationManager.getApplication(), (ApplicationInfoEx)ApplicationInfo.getInstance(), ApplicationNamesInfo.getInstance(), UpdateSettings.getInstance());
                feedbackTask = new SubmitCrashReportTask(project, FEEDBACK_TASK_TITLE, true, event.getThrowable(), ErrorReporter.pair2map(kv), (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
            }
            if (project == null) {
                feedbackTask.run((ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressManager.getInstance().run((Task)feedbackTask);
            }
        };
        if (parentComponent != null) {
            submitter.accept(DataManager.getInstance().getDataContext(parentComponent));
        } else {
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(submitter);
        }
        return true;
    }

    private static boolean handleAnalyticsReports(Throwable t, Object data) {
        if (!(data instanceof Map)) {
            return false;
        }
        Map map2 = (Map)data;
        String type = (String)map2.get("Type");
        if ("Exception".equals(type)) {
            ImmutableMap productData = ImmutableMap.of((Object)"md5", (Object)((String)map2.get("md5")), (Object)"summary", (Object)((String)map2.get("summary")));
            StudioExceptionReport exceptionReport = ((StudioExceptionReport.Builder)new StudioExceptionReport.Builder().setThrowable(t, false).addProductData((Map)productData)).build();
            StudioCrashReporter.getInstance().submit(exceptionReport);
        } else if ("Crashes".equals(type)) {
            // empty if block
        }
        return true;
    }

    @NotNull
    private static Map<String, String> pair2map(@NotNull List<Pair<String, String>> kv) {
        if (kv == null) {
            ErrorReporter.$$$reportNull$$$0(3);
        }
        HashMap m = Maps.newHashMapWithExpectedSize((int)kv.size());
        for (Pair<String, String> i2 : kv) {
            m.put((String)i2.getFirst(), (String)i2.getSecond());
        }
        HashMap hashMap = m;
        if (hashMap == null) {
            ErrorReporter.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/error/ErrorReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportActionText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/error/ErrorReporter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pair2map";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "pair2map";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

