/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.windows;

import com.android.tools.idea.diagnostics.windows.VirusCheckerStatusProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WindowsDefenderPowerShellStatusProvider
implements VirusCheckerStatusProvider {
    private static final int POWERSHELL_COMMAND_TIMEOUT_MS = 10000;
    private static final int MAX_POWERSHELL_STDERR_LENGTH = 500;

    @Override
    @NotNull
    public List<String> getExcludedPaths() throws IOException {
        ProcessOutput output;
        block4: {
            List list;
            try {
                output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-inputformat", "none", "-outputformat", "text", "-NonInteractive", "-Command", "Get-MpPreference | select -ExpandProperty \"ExclusionPath\""}), (int)10000);
                if (output.getExitCode() != 0) break block4;
                list = output.getStdoutLines(true);
            }
            catch (ExecutionException e) {
                throw e.toIOException();
            }
            if (list == null) {
                WindowsDefenderPowerShellStatusProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        throw new IOException("Windows Defender exclusion path check exited with status " + output.getExitCode() + ": " + StringUtil.first((String)output.getStderr(), (int)500, (boolean)false));
    }

    @Override
    @NotNull
    public VirusCheckerStatusProvider.RealtimeScanningStatus getRealtimeScanningStatus() throws IOException {
        ProcessOutput output;
        block6: {
            block7: {
                VirusCheckerStatusProvider.RealtimeScanningStatus realtimeScanningStatus;
                try {
                    output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-inputformat", "none", "-outputformat", "text", "-NonInteractive", "-Command", "Get-MpPreference | select -ExpandProperty \"DisableRealtimeMonitoring\""}), (int)10000);
                    if (output.getExitCode() != 0) break block6;
                    if (!output.getStdout().startsWith("False")) break block7;
                    realtimeScanningStatus = VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_ENABLED;
                }
                catch (ExecutionException e) {
                    throw e.toIOException();
                }
                if (realtimeScanningStatus == null) {
                    WindowsDefenderPowerShellStatusProvider.$$$reportNull$$$0(1);
                }
                return realtimeScanningStatus;
            }
            VirusCheckerStatusProvider.RealtimeScanningStatus realtimeScanningStatus = VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_DISABLED;
            if (realtimeScanningStatus == null) {
                WindowsDefenderPowerShellStatusProvider.$$$reportNull$$$0(2);
            }
            return realtimeScanningStatus;
        }
        throw new IOException("Windows Defender realtime scanning status check exited with status " + output.getExitCode() + ": " + StringUtil.first((String)output.getStderr(), (int)500, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/diagnostics/windows/WindowsDefenderPowerShellStatusProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealtimeScanningStatus";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

