/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.ui;

import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceComponent
extends JPanel {
    public static final String NAME_LABEL = "Name Label";
    private final ResourceSwatchComponent myResourceSwatchComponent;
    private final JLabel myNameLabel;
    protected final JLabel myWarningLabel;

    public ResourceComponent(@NotNull Project project, boolean isEditor) {
        if (project == null) {
            ResourceComponent.$$$reportNull$$$0(0);
        }
        super(new BorderLayout(0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP));
        this.myNameLabel = new JLabel();
        this.myWarningLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0, ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0));
        this.myWarningLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myWarningLabel.setVisible(false);
        this.myNameLabel.setName(NAME_LABEL);
        this.myNameLabel.setForeground((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR);
        Box topRowPanel = new Box(2);
        topRowPanel.add(this.myNameLabel);
        topRowPanel.add(this.myWarningLabel);
        topRowPanel.add(Box.createHorizontalGlue());
        this.add((Component)topRowPanel, "Center");
        this.myResourceSwatchComponent = new ResourceSwatchComponent(project, isEditor);
        this.add((Component)this.myResourceSwatchComponent, "South");
        ThemeEditorUtils.setInheritsPopupMenuRecursive(this);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int firstRowHeight = this.getFontMetrics(this.getFont()).getHeight();
            int secondRowHeight = this.myResourceSwatchComponent.getPreferredSize().height;
            return new Dimension(0, ThemeEditorConstants.ATTRIBUTE_MARGIN + ThemeEditorConstants.ATTRIBUTE_ROW_GAP + firstRowHeight + secondRowHeight);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
    }

    public void setSwatchIcon(@NotNull ResourceSwatchComponent.SwatchIcon icon2) {
        if (icon2 == null) {
            ResourceComponent.$$$reportNull$$$0(1);
        }
        this.myResourceSwatchComponent.setSwatchIcon(icon2);
    }

    public void setNameText(@NotNull String name) {
        if (name == null) {
            ResourceComponent.$$$reportNull$$$0(2);
        }
        this.myNameLabel.setText(name);
    }

    public void setWarning(@Nullable String warning) {
        if (!StringUtil.isEmpty((String)warning)) {
            this.myWarningLabel.setToolTipText(warning);
            this.myWarningLabel.setVisible(true);
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    public void setValueText(@NotNull String value2) {
        if (value2 == null) {
            ResourceComponent.$$$reportNull$$$0(3);
        }
        this.myResourceSwatchComponent.setText(value2);
    }

    @NotNull
    public String getValueText() {
        String string = this.myResourceSwatchComponent.getText();
        if (string == null) {
            ResourceComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myResourceSwatchComponent != null) {
            this.myResourceSwatchComponent.setFont(font);
        }
        if (this.myNameLabel != null) {
            this.myNameLabel.setFont(font);
        }
    }

    public void addSwatchListener(@NotNull ActionListener listener2) {
        if (listener2 == null) {
            ResourceComponent.$$$reportNull$$$0(5);
        }
        this.myResourceSwatchComponent.addSwatchListener(listener2);
    }

    public void addTextDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            ResourceComponent.$$$reportNull$$$0(6);
        }
        this.myResourceSwatchComponent.addTextDocumentListener(listener2);
    }

    public void setCompletionStrings(@NotNull List<String> completions) {
        if (completions == null) {
            ResourceComponent.$$$reportNull$$$0(7);
        }
        this.myResourceSwatchComponent.setCompletionStrings(completions);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myWarningLabel.isVisible()) {
            this.validate();
            if (SwingUtilities.getLocalBounds(this.myWarningLabel).contains(SwingUtilities.convertMouseEvent(this, event, this.myWarningLabel).getPoint())) {
                return this.myWarningLabel.getToolTipText();
            }
        }
        return super.getToolTipText(event);
    }

    @Nullable
    public ValidationInfo doValidate(int minApi, @NotNull AndroidTargetData androidTargetData) {
        if (androidTargetData == null) {
            ResourceComponent.$$$reportNull$$$0(8);
        }
        return this.myResourceSwatchComponent.doValidate(minApi, androidTargetData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ui/ResourceComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidTargetData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ui/ResourceComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSwatchIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setNameText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValueText";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSwatchListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTextDocumentListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionStrings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

