/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.callgraph;

import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.Graph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.MethodGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Callgraph {
    public Multimap<GraphNode, PsiCFGMethod> callerNodeToMethodsMap = Multimaps.newSetMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Set<PsiCFGMethod>>(){

        public Set<PsiCFGMethod> get() {
            return new HashSet<PsiCFGMethod>();
        }
    });
    public Multimap<PsiCFGMethod, GraphNode> calleeMethodToCallerGraphNodeMap = Multimaps.newSetMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Set<GraphNode>>(){

        public Set<GraphNode> get() {
            return new HashSet<GraphNode>();
        }
    });
    public Multimap<GraphNode, GraphNode> callerNodeToCalleeNodeMap = Multimaps.newSetMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Set<GraphNode>>(){

        public Set<GraphNode> get() {
            return new HashSet<GraphNode>();
        }
    });
    public Multimap<GraphNode, GraphNode> calleeNodeToCallerNodeMap = Multimaps.newSetMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Set<GraphNode>>(){

        public Set<GraphNode> get() {
            return new HashSet<GraphNode>();
        }
    });
    public Multimap<PsiCFGMethod, PsiCFGMethod> callerMethodToCalleeMethodMap = Multimaps.newSetMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Set<PsiCFGMethod>>(){

        public Set<PsiCFGMethod> get() {
            return new HashSet<PsiCFGMethod>();
        }
    });
    public Multimap<PsiCFGMethod, PsiCFGMethod> calleeMethodToCallerMethodReturnMap = Multimaps.newSetMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Set<PsiCFGMethod>>(){

        public Set<PsiCFGMethod> get() {
            return new HashSet<PsiCFGMethod>();
        }
    });
    public Set<PsiCFGMethod> allMethodsInGraph = new HashSet<PsiCFGMethod>();

    public PsiCFGMethod[] findCalleeMethodForGraphNode(GraphNode node) {
        if (this.callerNodeToMethodsMap.containsKey((Object)node)) {
            Collection methodCollection = this.callerNodeToMethodsMap.get((Object)node);
            return methodCollection.toArray(PsiCFGMethod.EMPTY_ARRAY);
        }
        return PsiCFGMethod.EMPTY_ARRAY;
    }

    public GraphNode[] findCalleeGraphNodeForGraphNode(GraphNode node) {
        if (this.callerNodeToCalleeNodeMap.containsKey((Object)node)) {
            Collection graphNodeCollection = this.callerNodeToCalleeNodeMap.get((Object)node);
            return graphNodeCollection.toArray(GraphNode.EMPTY_ARRAY);
        }
        return GraphNode.EMPTY_ARRAY;
    }

    public PsiCFGMethod[] findCalleeForMethod(PsiCFGMethod method) {
        if (this.calleeMethodToCallerMethodReturnMap.containsKey((Object)method)) {
            Collection methodsCollection = this.calleeMethodToCallerMethodReturnMap.get((Object)method);
            return methodsCollection.toArray(PsiCFGMethod.EMPTY_ARRAY);
        }
        return PsiCFGMethod.EMPTY_ARRAY;
    }

    public PsiCFGMethod getNodesParentMethod(GraphNode node) {
        Graph parentGraph;
        for (parentGraph = node.getParentGraph(); parentGraph != null && !(parentGraph instanceof MethodGraph); parentGraph = parentGraph.getParentGraph()) {
        }
        if (parentGraph == null) {
            return null;
        }
        return ((MethodGraph)parentGraph).getPsiCFGMethod();
    }

    public GraphNode[] findCallerForMethod(PsiCFGMethod method) {
        return GraphNode.EMPTY_ARRAY;
    }

    protected Callgraph() {
    }
}

