/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceCapabilities;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDataDirectoryEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDefaultFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDirectFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.adbimpl.AdbFileListing;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileOperations;
import com.android.tools.idea.explorer.adbimpl.AdbFileTransfer;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceState;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class AdbDeviceFileSystem
implements DeviceFileSystem {
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final AdbDeviceCapabilities myDeviceCapabilities;
    @NotNull
    private final AdbFileListing myFileListing;
    @NotNull
    private final AdbFileOperations myFileOperations;
    @NotNull
    private final AdbFileTransfer myFileTransfer;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;

    public AdbDeviceFileSystem(@NotNull IDevice device, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor) {
        if (device == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(0);
        }
        if (edtExecutor == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(1);
        }
        if (taskExecutor == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(2);
        }
        this.myEdtExecutor = new FutureCallbackExecutor(edtExecutor);
        this.myTaskExecutor = new FutureCallbackExecutor(taskExecutor);
        this.myDevice = device;
        this.myDeviceCapabilities = new AdbDeviceCapabilities(this.myDevice);
        this.myFileListing = new AdbFileListing(this.myDevice, this.myDeviceCapabilities, (Executor)this.myTaskExecutor);
        this.myFileOperations = new AdbFileOperations(this.myDevice, this.myDeviceCapabilities, (Executor)this.myTaskExecutor);
        this.myFileTransfer = new AdbFileTransfer(this.myDevice, this.myFileOperations, (Executor)this.myEdtExecutor, (Executor)this.myTaskExecutor);
    }

    public AdbDeviceFileSystem(AdbDeviceFileSystemService service, IDevice device) {
        this(device, (Executor)service.getEdtExecutor(), (Executor)service.getTaskExecutor());
    }

    boolean isDevice(@Nullable IDevice device) {
        return this.myDevice.equals(device);
    }

    @NotNull
    IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(3);
        }
        return iDevice;
    }

    @NotNull
    public AdbDeviceCapabilities getCapabilities() {
        AdbDeviceCapabilities adbDeviceCapabilities = this.myDeviceCapabilities;
        if (adbDeviceCapabilities == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(4);
        }
        return adbDeviceCapabilities;
    }

    @NotNull
    public AdbFileListing getAdbFileListing() {
        AdbFileListing adbFileListing = this.myFileListing;
        if (adbFileListing == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(5);
        }
        return adbFileListing;
    }

    @NotNull
    public AdbFileOperations getAdbFileOperations() {
        AdbFileOperations adbFileOperations = this.myFileOperations;
        if (adbFileOperations == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(6);
        }
        return adbFileOperations;
    }

    @NotNull
    public AdbFileTransfer getAdbFileTransfer() {
        AdbFileTransfer adbFileTransfer = this.myFileTransfer;
        if (adbFileTransfer == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(7);
        }
        return adbFileTransfer;
    }

    @NotNull
    FutureCallbackExecutor getTaskExecutor() {
        FutureCallbackExecutor futureCallbackExecutor = this.myTaskExecutor;
        if (futureCallbackExecutor == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(8);
        }
        return futureCallbackExecutor;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myDevice.getName();
        if (string == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public DeviceState getDeviceState() {
        IDevice.DeviceState state = this.myDevice.getState();
        if (state == null) {
            DeviceState deviceState = DeviceState.DISCONNECTED;
            if (deviceState == null) {
                AdbDeviceFileSystem.$$$reportNull$$$0(10);
            }
            return deviceState;
        }
        switch (state) {
            case ONLINE: {
                DeviceState deviceState = DeviceState.ONLINE;
                if (deviceState == null) {
                    AdbDeviceFileSystem.$$$reportNull$$$0(11);
                }
                return deviceState;
            }
            case OFFLINE: {
                DeviceState deviceState = DeviceState.OFFLINE;
                if (deviceState == null) {
                    AdbDeviceFileSystem.$$$reportNull$$$0(12);
                }
                return deviceState;
            }
            case UNAUTHORIZED: {
                DeviceState deviceState = DeviceState.UNAUTHORIZED;
                if (deviceState == null) {
                    AdbDeviceFileSystem.$$$reportNull$$$0(13);
                }
                return deviceState;
            }
            case DISCONNECTED: {
                DeviceState deviceState = DeviceState.DISCONNECTED;
                if (deviceState == null) {
                    AdbDeviceFileSystem.$$$reportNull$$$0(14);
                }
                return deviceState;
            }
            case BOOTLOADER: {
                DeviceState deviceState = DeviceState.BOOTLOADER;
                if (deviceState == null) {
                    AdbDeviceFileSystem.$$$reportNull$$$0(15);
                }
                return deviceState;
            }
            case RECOVERY: {
                DeviceState deviceState = DeviceState.RECOVERY;
                if (deviceState == null) {
                    AdbDeviceFileSystem.$$$reportNull$$$0(16);
                }
                return deviceState;
            }
            case SIDELOAD: {
                DeviceState deviceState = DeviceState.SIDELOAD;
                if (deviceState == null) {
                    AdbDeviceFileSystem.$$$reportNull$$$0(17);
                }
                return deviceState;
            }
        }
        DeviceState deviceState = DeviceState.DISCONNECTED;
        if (deviceState == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(18);
        }
        return deviceState;
    }

    @Override
    @NotNull
    public ListenableFuture<DeviceFileEntry> getRootDirectory() {
        ListenableFuture listenableFuture = this.getTaskExecutor().transform(this.getAdbFileListing().getRoot(), entry -> {
            assert (entry != null);
            return new AdbDeviceDefaultFileEntry(this, (AdbFileListingEntry)entry, null);
        });
        if (listenableFuture == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(19);
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<DeviceFileEntry> getEntry(final @NotNull String path2) {
        if (path2 == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(20);
        }
        final SettableFuture resultFuture = SettableFuture.create();
        ListenableFuture<DeviceFileEntry> currentDir = this.getRootDirectory();
        this.getTaskExecutor().addCallback(currentDir, (FutureCallback)new FutureCallback<DeviceFileEntry>(){

            public void onSuccess(@Nullable DeviceFileEntry result2) {
                assert (result2 != null);
                if (StringUtil.isEmpty((String)path2) || StringUtil.equals((CharSequence)path2, (CharSequence)"/")) {
                    resultFuture.set((Object)result2);
                    return;
                }
                String[] pathSegments = path2.substring(1).split("/");
                AdbDeviceFileSystem.this.resolvePathSegments((SettableFuture<DeviceFileEntry>)resultFuture, result2, pathSegments, 0);
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                resultFuture.setException(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileSystem$1", "onFailure"));
            }
        });
        SettableFuture settableFuture = resultFuture;
        if (settableFuture == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(21);
        }
        return settableFuture;
    }

    private void resolvePathSegments(final @NotNull SettableFuture<DeviceFileEntry> future2, @NotNull DeviceFileEntry currentEntry, final @NotNull String[] segments, final int segmentIndex) {
        if (future2 == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(22);
        }
        if (currentEntry == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(23);
        }
        if (segments == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(24);
        }
        if (segmentIndex >= segments.length) {
            future2.set((Object)currentEntry);
            return;
        }
        ListenableFuture<List<DeviceFileEntry>> entriesFuture = currentEntry.getEntries();
        this.getTaskExecutor().addCallback(entriesFuture, (FutureCallback)new FutureCallback<List<DeviceFileEntry>>(){

            public void onSuccess(@Nullable List<DeviceFileEntry> result2) {
                assert (result2 != null);
                Optional<DeviceFileEntry> entry = result2.stream().filter(x -> x.getName().equals(segments[segmentIndex])).findFirst();
                if (!entry.isPresent()) {
                    future2.setException((Throwable)new IllegalArgumentException("Path not found"));
                } else {
                    AdbDeviceFileSystem.this.resolvePathSegments((SettableFuture<DeviceFileEntry>)future2, entry.get(), segments, segmentIndex + 1);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                future2.setException(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileSystem$2", "onFailure"));
            }
        });
    }

    @NotNull
    public ListenableFuture<AdbDeviceFileEntry> resolveMountPoint(@NotNull AdbDeviceFileEntry entry) {
        if (entry == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(25);
        }
        ListenableFuture listenableFuture = this.getTaskExecutor().executeAsync(() -> {
            if (this.myDeviceCapabilities.supportsSuRootCommand() || this.myDeviceCapabilities.isRoot()) {
                return AdbDeviceFileSystem.createDirectFileEntry(entry);
            }
            if (Objects.equals(entry.getFullPath(), "/data")) {
                return new AdbDeviceDataDirectoryEntry(entry);
            }
            return AdbDeviceFileSystem.createDirectFileEntry(entry);
        });
        if (listenableFuture == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(26);
        }
        return listenableFuture;
    }

    @NotNull
    private static AdbDeviceDirectFileEntry createDirectFileEntry(@NotNull AdbDeviceFileEntry entry) {
        if (entry == null) {
            AdbDeviceFileSystem.$$$reportNull$$$0(27);
        }
        return new AdbDeviceDirectFileEntry(entry.myDevice, entry.myEntry, entry.myParent, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileSystem";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentEntry";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segments";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevice";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdbFileListing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdbFileOperations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdbFileTransfer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceState";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirectory";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMountPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 26: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolvePathSegments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveMountPoint";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createDirectFileEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

