/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileListingEntry {
    @NotNull
    private static Logger LOGGER = Logger.getInstance(AdbFileListingEntry.class);
    @NotNull
    private final String myPath;
    @NotNull
    private final EntryKind myKind;
    @Nullable
    private final String myPermissions;
    @Nullable
    private final String myOwner;
    @Nullable
    private final String myGroup;
    @Nullable
    private final String myDate;
    @Nullable
    private final String myTime;
    @Nullable
    private final String mySize;
    @Nullable
    private final String myExtraInfo;

    public AdbFileListingEntry(@NotNull String path2, @NotNull EntryKind kind, @Nullable String permissions, @Nullable String owner, @Nullable String group2, @Nullable String date, @Nullable String time2, @Nullable String size, @Nullable String extraInfo) {
        if (path2 == null) {
            AdbFileListingEntry.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            AdbFileListingEntry.$$$reportNull$$$0(1);
        }
        this.myPath = path2;
        this.myKind = kind;
        this.myPermissions = permissions;
        this.myOwner = owner;
        this.myGroup = group2;
        this.myDate = date;
        this.myTime = time2;
        this.mySize = size;
        this.myExtraInfo = extraInfo;
    }

    public String toString() {
        return String.format("%s: %s", new Object[]{this.myKind, this.myPath});
    }

    @NotNull
    public String getFullPath() {
        String string = this.myPath;
        if (string == null) {
            AdbFileListingEntry.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = AdbPathUtil.getFileName(this.myPath);
        if (string == null) {
            AdbFileListingEntry.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public EntryKind getKind() {
        EntryKind entryKind = this.myKind;
        if (entryKind == null) {
            AdbFileListingEntry.$$$reportNull$$$0(4);
        }
        return entryKind;
    }

    @Nullable
    public String getPermissions() {
        return this.myPermissions;
    }

    @Nullable
    public String getOwner() {
        return this.myOwner;
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getDate() {
        return this.myDate;
    }

    @Nullable
    public String getTime() {
        return this.myTime;
    }

    public long getSize() {
        String size = this.mySize;
        if (StringUtil.isEmpty((String)size)) {
            return -1L;
        }
        int index = size.indexOf(44);
        if (index >= 0) {
            return -1L;
        }
        try {
            return Long.parseLong(size);
        }
        catch (NumberFormatException e) {
            LOGGER.warn(String.format("Error paring size string \"%s\"", size), (Throwable)e);
            return -1L;
        }
    }

    @Nullable
    public String getInfo() {
        return this.myExtraInfo;
    }

    public boolean isDirectory() {
        return this.myKind == EntryKind.DIRECTORY;
    }

    public boolean isFile() {
        return this.myKind == EntryKind.FILE;
    }

    public boolean isSymbolicLink() {
        return this.myKind == EntryKind.SYMBOLIC_LINK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbFileListingEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbFileListingEntry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum EntryKind {
        FILE,
        DIRECTORY,
        SYMBOLIC_LINK,
        BLOCK,
        CHARACTER,
        SOCKET,
        FIFO,
        OTHER;

    }
}

