/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.BuildsToPathsMapper;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToBundleLocationTask
implements GradleBuildInvoker.AfterGradleInvocationTask {
    public static final String ANALYZE_URL_PREFIX = "analyze:";
    public static final String LOCATE_URL_PREFIX = "module:";
    public static final String LOCATE_KEY_URL_PREFIX = "key:";
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myNotificationTitle;
    @NotNull
    private final Collection<Module> myModules;
    @Nullable
    private final File myExportedKeyFile;
    @NotNull
    private final List<String> myBuildVariants;
    @Nullable
    private final String mySignedBundlePath;

    public GoToBundleLocationTask(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String notificationTitle) {
        if (project == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(1);
        }
        if (notificationTitle == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(2);
        }
        this(project, modules, notificationTitle, Collections.emptyList(), null, null);
    }

    public GoToBundleLocationTask(@NotNull Project project, @NotNull Collection<Module> modules, @NotNull String notificationTitle, @NotNull List<String> buildVariants, @Nullable File exportedKeyFile, @Nullable String signedBundlePath) {
        if (project == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(3);
        }
        if (modules == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(4);
        }
        if (notificationTitle == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(5);
        }
        if (buildVariants == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.myNotificationTitle = notificationTitle;
        this.myModules = modules;
        this.myExportedKeyFile = exportedKeyFile;
        this.myBuildVariants = buildVariants;
        this.mySignedBundlePath = signedBundlePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull GradleInvocationResult result2) {
        if (result2 == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(7);
        }
        try {
            BuildsToPathsMapper buildsToPathsMapper = BuildsToPathsMapper.getInstance(this.myProject);
            Map<String, File> bundleBuildsToPath = buildsToPathsMapper.getBuildsToPaths(result2.getModel(), this.myBuildVariants, this.myModules, true, this.mySignedBundlePath);
            this.showNotification(result2, bundleBuildsToPath);
        }
        finally {
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
        }
    }

    private void showNotification(@NotNull GradleInvocationResult result2, @NotNull Map<String, File> buildsAndBundlePaths) {
        if (result2 == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(8);
        }
        if (buildsAndBundlePaths == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(9);
        }
        AndroidNotification notification = AndroidNotification.getInstance(this.myProject);
        if (result2.isBuildSuccessful()) {
            this.notifySuccess(notification, buildsAndBundlePaths);
        } else if (result2.isBuildCancelled()) {
            notification.showBalloon(this.myNotificationTitle, "Build cancelled.", NotificationType.INFORMATION);
        } else {
            String msg = "Errors while building Bundle file. You can find the errors in the 'Messages' view.";
            notification.showBalloon(this.myNotificationTitle, msg, NotificationType.ERROR);
        }
    }

    private void notifySuccess(@NotNull AndroidNotification notification, @NotNull Map<String, File> bundleBuildsToPath) {
        if (notification == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(10);
        }
        if (bundleBuildsToPath == null) {
            GoToBundleLocationTask.$$$reportNull$$$0(11);
        }
        boolean isSigned = !this.myBuildVariants.isEmpty();
        StringBuilder builder2 = new StringBuilder();
        int count = bundleBuildsToPath.size();
        builder2.append("App bundle(s) generated successfully for ");
        if (isSigned) {
            String moduleName2 = ((Module)Iterators.getOnlyElement(this.myModules.iterator())).getName();
            builder2.append("module '").append(moduleName2).append("' with ").append(count).append(count == 1 ? " build variant" : " build variants");
        } else {
            builder2.append(count).append(count == 1 ? " module" : " modules");
        }
        builder2.append(":<br/>");
        if (this.isRevealFileActionSupported()) {
            Iterator<String> iterator = bundleBuildsToPath.keySet().iterator();
            while (iterator.hasNext()) {
                String moduleOrBuildVariant = iterator.next();
                if (isSigned) {
                    builder2.append("Build variant '");
                } else {
                    builder2.append("Module '");
                }
                builder2.append(moduleOrBuildVariant).append("': ");
                builder2.append("<a href=\"").append(LOCATE_URL_PREFIX).append(moduleOrBuildVariant).append("\">locate</a> or ");
                builder2.append("<a href=\"").append(ANALYZE_URL_PREFIX).append(moduleOrBuildVariant).append("\">analyze</a> the app bundle.");
                if (!iterator.hasNext()) continue;
                builder2.append("<br/>");
            }
            if (this.myExportedKeyFile != null) {
                builder2.append("<br/>");
                builder2.append("<a href=\"").append(LOCATE_KEY_URL_PREFIX).append("\">Locate</a> exported key file.");
            }
            String text = builder2.toString();
            notification.showBalloon(this.myNotificationTitle, text, NotificationType.INFORMATION, (NotificationListener)new OpenFolderNotificationListener(this.myProject, bundleBuildsToPath, this.myExportedKeyFile));
        } else {
            builder2.append(bundleBuildsToPath.entrySet().stream().map(entry -> String.format(" - %s: %s", entry.getKey(), ((File)entry.getValue()).getPath())).collect(Collectors.joining("\n")));
            StringBuilder balloonBuilder = new StringBuilder();
            balloonBuilder.append("App bundle(s) generated successfully for ");
            if (isSigned) {
                String moduleName3 = ((Module)Iterators.getOnlyElement(this.myModules.iterator())).getName();
                balloonBuilder.append("module '").append(moduleName3).append("' with ").append(count).append(count == 1 ? " build variant" : " build variants");
            } else {
                balloonBuilder.append(count).append(count == 1 ? " module" : " modules");
            }
            notification.showBalloon(this.myNotificationTitle, balloonBuilder.toString(), NotificationType.INFORMATION, new OpenEventLogHyperlink());
            notification.addLogEvent(this.myNotificationTitle, builder2.toString(), NotificationType.INFORMATION);
        }
    }

    @VisibleForTesting
    boolean isRevealFileActionSupported() {
        return RevealFileAction.isSupported();
    }

    private static Logger getLog() {
        return Logger.getInstance(GoToBundleLocationTask.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationTitle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariants";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildsAndBundlePaths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleBuildsToPath";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/actions/GoToBundleLocationTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "notifySuccess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @VisibleForTesting
    static class OpenEventLogHyperlink
    extends NotificationHyperlink {
        OpenEventLogHyperlink() {
            super("open.event.log", "Show app bundle path(s) in the 'Event Log' view");
        }

        @Override
        protected void execute(@NotNull Project project) {
            ToolWindow tw;
            if (project == null) {
                OpenEventLogHyperlink.$$$reportNull$$$0(0);
            }
            if ((tw = ToolWindowManager.getInstance((Project)project).getToolWindow("Event Log")) != null) {
                tw.activate(null, false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/GoToBundleLocationTask$OpenEventLogHyperlink", "execute"));
        }
    }

    @VisibleForTesting
    static class OpenFolderNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Map<String, File> myBundlePathsPerModule;
        @Nullable
        private final File myExportedKeyFile;

        OpenFolderNotificationListener(@NotNull Project project, @NotNull Map<String, File> myBuildsAndBundlePaths, @Nullable File exportedKeyFile) {
            if (project == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(0);
            }
            if (myBuildsAndBundlePaths == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myBundlePathsPerModule = myBuildsAndBundlePaths;
            this.myExportedKeyFile = exportedKeyFile;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(2);
            }
            if (e == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(3);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            String description = e.getDescription();
            if (description.startsWith(GoToBundleLocationTask.ANALYZE_URL_PREFIX)) {
                this.openBundleAnalyzer(description.substring(GoToBundleLocationTask.ANALYZE_URL_PREFIX.length()));
            } else if (description.startsWith(GoToBundleLocationTask.LOCATE_URL_PREFIX)) {
                this.openBundleDirectory(description.substring(GoToBundleLocationTask.LOCATE_URL_PREFIX.length()));
            } else if (description.startsWith(GoToBundleLocationTask.LOCATE_KEY_URL_PREFIX)) {
                this.openKeyDirectory();
            }
        }

        private void openBundleAnalyzer(@NotNull String bundlePath) {
            VirtualFile virtualFile;
            File bundleFile;
            if (bundlePath == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(4);
            }
            if ((bundleFile = this.myBundlePathsPerModule.get(bundlePath)) == null) {
                GoToBundleLocationTask.getLog().warn(String.format("Error finding bundle file \"%s\"", bundlePath));
                return;
            }
            VirtualFile virtualFile2 = virtualFile = !bundleFile.isFile() ? this.askUserForBundleFile(bundleFile) : LocalFileSystem.getInstance().findFileByIoFile(bundleFile);
            if (virtualFile == null) {
                GoToBundleLocationTask.getLog().warn(String.format("Bundle file not found in virtual file system \"%s\"", bundlePath));
                return;
            }
            OpenFileDescriptor fd = new OpenFileDescriptor(this.myProject, virtualFile);
            List editors = FileEditorManager.getInstance((Project)this.myProject).openEditor(fd, true);
            if (editors.isEmpty()) {
                GoToBundleLocationTask.getLog().warn(String.format("Could not open editor for bundle file \"%s\"", bundlePath));
            }
        }

        @Nullable
        VirtualFile askUserForBundleFile(@NotNull File bundleFile) {
            if (bundleFile == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(5);
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor().withDescription("Select Bundle file to analyze").withFileFilter(file -> "aab".equalsIgnoreCase(file.getExtension()));
            return FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.myProject, (VirtualFile)LocalFileSystem.getInstance().findFileByIoFile(bundleFile));
        }

        private void openBundleDirectory(String path2) {
            OpenFolderNotificationListener.showFileOrDirectory(this.myBundlePathsPerModule.get(path2));
        }

        private void openKeyDirectory() {
            assert (this.myExportedKeyFile != null);
            OpenFolderNotificationListener.showFileOrDirectory(this.myExportedKeyFile);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            OpenFolderNotificationListener listener2 = (OpenFolderNotificationListener)((Object)o);
            return Objects.equals(this.myBundlePathsPerModule, listener2.myBundlePathsPerModule);
        }

        public int hashCode() {
            return Objects.hash(this.myBundlePathsPerModule);
        }

        private static void showFileOrDirectory(@NotNull File file) {
            if (file == null) {
                OpenFolderNotificationListener.$$$reportNull$$$0(6);
            }
            if (file.isFile()) {
                RevealFileAction.openFile((File)file);
            } else {
                RevealFileAction.openDirectory((File)file.getParentFile());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myBuildsAndBundlePaths";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundlePath";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundleFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/actions/GoToBundleLocationTask$OpenFolderNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "openBundleAnalyzer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "askUserForBundleFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showFileOrDirectory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

