/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dependencies.ConfigurationNameMapper;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.Objects;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        if (project == null) {
            GradleDependencyManager.$$$reportNull$$$0(0);
        }
        GradleDependencyManager gradleDependencyManager = (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
        if (gradleDependencyManager == null) {
            GradleDependencyManager.$$$reportNull$$$0(1);
        }
        return gradleDependencyManager;
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies2) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(2);
        }
        if (dependencies2 == null) {
            GradleDependencyManager.$$$reportNull$$$0(3);
        }
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        GradleBuildModel buildModel = GradleBuildModel.get((Module)module);
        if (gradleModel == null && buildModel == null) {
            List<GradleCoordinate> list = Collections.emptyList();
            if (list == null) {
                GradleDependencyManager.$$$reportNull$$$0(4);
            }
            return list;
        }
        List compileDependencies = buildModel != null ? buildModel.dependencies().artifacts() : null;
        GradleVersion appCompatVersion = null;
        if (compileDependencies != null) {
            for (ArtifactDependencyModel dependency : compileDependencies) {
                if (!Objects.equal((Object)"com.android.support", (Object)dependency.group().toString()) || Objects.equal((Object)"multidex", (Object)dependency.name().forceString())) continue;
                String s = dependency.version().toString();
                if (s == null) break;
                appCompatVersion = GradleVersion.tryParse((String)s);
                break;
            }
        }
        Project project = module.getProject();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        ArrayList<GradleCoordinate> missingLibraries = new ArrayList<GradleCoordinate>();
        for (GradleCoordinate coordinate : dependencies2) {
            boolean dependencyFound;
            String groupId = coordinate.getGroupId();
            String artifactId = coordinate.getArtifactId();
            if (artifactId == null || groupId == null) continue;
            GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, project, null);
            if (appCompatVersion != null && coordinate.acceptsGreaterRevisions() && "com.android.support".equals(groupId) && !artifactId.equals("multidex")) {
                resolvedCoordinate = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + appCompatVersion.toString()));
            }
            if (resolvedCoordinate != null) {
                coordinate = resolvedCoordinate;
            }
            if (dependencyFound = compileDependencies != null && compileDependencies.stream().anyMatch(d -> Objects.equal((Object)d.group().toString(), (Object)groupId) && d.name().forceString().equals(artifactId))) continue;
            missingLibraries.add(coordinate);
        }
        ArrayList<GradleCoordinate> arrayList = missingLibraries;
        if (arrayList == null) {
            GradleDependencyManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public boolean addDependenciesAndSync(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies2, @Nullable Runnable callback2) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(6);
        }
        if (dependencies2 == null) {
            GradleDependencyManager.$$$reportNull$$$0(7);
        }
        return this.addDependenciesInTransaction(module, dependencies2, true, callback2, null);
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies2) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(8);
        }
        if (dependencies2 == null) {
            GradleDependencyManager.$$$reportNull$$$0(9);
        }
        return this.addDependenciesInTransaction(module, dependencies2, false, null, null);
    }

    public boolean addDependenciesWithoutSync(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies2, @Nullable ConfigurationNameMapper nameMapper) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(10);
        }
        if (dependencies2 == null) {
            GradleDependencyManager.$$$reportNull$$$0(11);
        }
        return this.addDependenciesInTransaction(module, dependencies2, false, null, nameMapper);
    }

    public boolean updateLibrariesToVersion(@NotNull Module module, @NotNull List<GradleCoordinate> dependencies2, @Nullable Runnable callback2) {
        GradleBuildModel buildModel;
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(12);
        }
        if (dependencies2 == null) {
            GradleDependencyManager.$$$reportNull$$$0(13);
        }
        if ((buildModel = GradleBuildModel.get((Module)module)) == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module, dependencies2, callback2);
        return true;
    }

    public boolean userWantToAddDependencies(@NotNull Module module, @NotNull Collection<GradleCoordinate> missing) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(14);
        }
        if (missing == null) {
            GradleDependencyManager.$$$reportNull$$$0(15);
        }
        String libraryNames2 = StringUtil.join(missing, GradleCoordinate::getArtifactId, (String)", ");
        String message2 = String.format("This operation requires the %1$s %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames2, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message2, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    private boolean addDependenciesInTransaction(final @NotNull Module module, final @NotNull Iterable<GradleCoordinate> coordinates, final boolean performSync, final @Nullable Runnable callback2, final @Nullable ConfigurationNameMapper nameMapper) {
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(16);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(17);
        }
        if (!performSync && callback2 != null) {
            throw new IllegalArgumentException("Callback must be null if sync is not requested.");
        }
        final GradleBuildModel buildModel = GradleBuildModel.get((Module)module);
        if (buildModel == null) {
            return false;
        }
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                List<GradleCoordinate> missing;
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((missing = GradleDependencyManager.this.findMissingDependencies(module, coordinates)).isEmpty()) {
                    return;
                }
                GradleDependencyManager.addDependencies(buildModel, module, missing, nameMapper);
                if (performSync) {
                    GradleDependencyManager.requestProjectSync(project, callback2, GradleSyncStats.Trigger.TRIGGER_GRADLEDEPENDENCY_ADDED);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$1", "run"));
            }
        }.execute();
        return true;
    }

    private static void addDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates, @Nullable ConfigurationNameMapper nameMapper) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(18);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(19);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(20);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model2 -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate coordinate : coordinates) {
                String name = "compile";
                if (nameMapper != null) {
                    name = nameMapper.mapName(module, name, coordinate);
                }
                name = GradleUtil.mapConfigurationName(name, GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                dependenciesModel.addArtifact(name, coordinate.toString());
            }
            buildModel.applyChanges();
        });
    }

    private static void updateDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback2) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(21);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(22);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(23);
        }
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                GradleDependencyManager.updateDependencies(buildModel, module, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback2, GradleSyncStats.Trigger.TRIGGER_GRADLEDEPENDENCY_UPDATED);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$2", "run"));
            }
        }.execute();
    }

    private static void requestProjectSync(@NotNull Project project, @Nullable Runnable callback2, @NotNull GradleSyncStats.Trigger trigger) {
        if (project == null) {
            GradleDependencyManager.$$$reportNull$$$0(24);
        }
        if (trigger == null) {
            GradleDependencyManager.$$$reportNull$$$0(25);
        }
        if (callback2 != null) {
            GradleBuildInvoker.getInstance(project).add(new GradleCompletionTask(project, callback2));
        }
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(trigger);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request);
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        if (buildModel == null) {
            GradleDependencyManager.$$$reportNull$$$0(26);
        }
        if (module == null) {
            GradleDependencyManager.$$$reportNull$$$0(27);
        }
        if (coordinates == null) {
            GradleDependencyManager.$$$reportNull$$$0(28);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model2 -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList artifacts = new ArrayList(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (gc.getGroupId() == null || !gc.getGroupId().equals(m.group().toString()) || gc.getArtifactId() == null || !gc.getArtifactId().equals(m.name().forceString()) || gc.getRevision().equals(m.version().toString())) continue;
                    dependenciesModel.remove((DependencyModel)m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missing";
                break;
            }
            case 17: 
            case 20: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findMissingDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findMissingDependencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesAndSync";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesWithoutSync";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateLibrariesToVersion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "userWantToAddDependencies";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesInTransaction";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesInTransaction";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSync";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class GradleCompletionTask
    implements GradleBuildInvoker.AfterGradleInvocationTask {
        private final Project myProject;
        private final Runnable myCallback;

        private GradleCompletionTask(@NotNull Project project, @NotNull Runnable callback2) {
            if (project == null) {
                GradleCompletionTask.$$$reportNull$$$0(0);
            }
            if (callback2 == null) {
                GradleCompletionTask.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myCallback = callback2;
        }

        @Override
        public void execute(@NotNull GradleInvocationResult result2) {
            if (result2 == null) {
                GradleCompletionTask.$$$reportNull$$$0(2);
            }
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
            this.myCallback.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$GradleCompletionTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

