/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.android.tools.idea.gradle.project.sync.Modules;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleDependency
implements Serializable {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myModuleId;
    @Nullable
    private final String myScope;
    private final boolean myExported;

    @Nullable
    public static JavaModuleDependency copy(IdeaProject project, IdeaModuleDependency original) {
        IdeaModule targetModule = null;
        for (IdeaModule module : project.getModules()) {
            if (!module.getName().equals(original.getTargetModuleName())) continue;
            targetModule = module;
        }
        if (targetModule != null && StringUtil.isNotEmpty((String)targetModule.getName())) {
            File projectFolder;
            String scope = null;
            IdeaDependencyScope originalScope = original.getScope();
            if (originalScope != null) {
                scope = originalScope.getScope();
            }
            GradleProject gradleProject = targetModule.getGradleProject();
            try {
                projectFolder = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
            }
            catch (UnsupportedMethodException ex) {
                GradleProject rootGradleProject = gradleProject;
                while (rootGradleProject.getParent() != null) {
                    rootGradleProject = rootGradleProject.getParent();
                }
                projectFolder = rootGradleProject.getProjectDirectory();
            }
            String moduleId = Modules.createUniqueModuleId(projectFolder, gradleProject.getPath());
            return new JavaModuleDependency(targetModule.getName(), moduleId, scope, original.getExported());
        }
        return null;
    }

    @PropertyMapping(value={"myModuleName", "myModuleId", "myScope", "myExported"})
    public JavaModuleDependency(@NotNull String moduleName2, @NotNull String moduleId, @Nullable String scope, boolean exported) {
        if (moduleName2 == null) {
            JavaModuleDependency.$$$reportNull$$$0(0);
        }
        if (moduleId == null) {
            JavaModuleDependency.$$$reportNull$$$0(1);
        }
        this.myModuleName = moduleName2;
        this.myModuleId = moduleId;
        this.myScope = scope;
        this.myExported = exported;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            JavaModuleDependency.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getModuleId() {
        String string = this.myModuleId;
        if (string == null) {
            JavaModuleDependency.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    public boolean isExported() {
        return this.myExported;
    }

    public int hashCode() {
        return Objects.hash(this.myModuleName, this.myModuleId, this.myScope, this.myExported);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaModuleDependency)) {
            return false;
        }
        JavaModuleDependency dependency = (JavaModuleDependency)obj;
        return Objects.equals(this.myModuleName, dependency.myModuleName) && Objects.equals(this.myModuleId, dependency.myModuleId) && Objects.equals(this.myScope, dependency.myScope) && Objects.equals(this.myExported, dependency.myExported);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/model/java/JavaModuleDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/model/java/JavaModuleDependency";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

