/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.LegacyAndroidProjects;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import org.jetbrains.annotations.NotNull;

public class AndroidGradleProjectStartupActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectStartupActivity.$$$reportNull$$$0(0);
        }
        this.syncAndroidGradleProjectWithPersistedProjectData(project);
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.notifyOnInvalidGradleJDKEnv(project);
            this.notifyOnLegacyAndroidProject(project);
        }
    }

    private void syncAndroidGradleProjectWithPersistedProjectData(@NotNull Project project) {
        GradleProjectInfo gradleProjectInfo;
        if (project == null) {
            AndroidGradleProjectStartupActivity.$$$reportNull$$$0(1);
        }
        if ((!(gradleProjectInfo = GradleProjectInfo.getInstance(project)).getAndroidModules().isEmpty() || IdeInfo.getInstance().isAndroidStudio() && gradleProjectInfo.isBuildWithGradle() || gradleProjectInfo.isImportedProject()) && !gradleProjectInfo.isSkipStartupActivity()) {
            GradleSyncStats.Trigger trigger = gradleProjectInfo.isNewProject() ? GradleSyncStats.Trigger.TRIGGER_PROJECT_NEW : GradleSyncStats.Trigger.TRIGGER_PROJECT_REOPEN;
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(trigger);
            request.useCachedGradleModels = true;
            GradleSyncInvoker.getInstance().requestProjectSync(project, request);
        }
        gradleProjectInfo.setSkipStartupActivity(false);
    }

    private void notifyOnInvalidGradleJDKEnv(@NotNull Project project) {
        IdeSdks ideSdks;
        if (project == null) {
            AndroidGradleProjectStartupActivity.$$$reportNull$$$0(2);
        }
        if ((ideSdks = IdeSdks.getInstance()).isJdkEnvVariableDefined() && !ideSdks.isJdkEnvVariableValid()) {
            String msg = "STUDIO_GRADLE_JDK is being ignored since it is set to an invalid JDK Location:\n" + ideSdks.getEnvVariableJdkValue();
            AndroidNotification.getInstance(project).showBalloon("", msg, NotificationType.WARNING, SelectJdkFromFileSystemHyperlink.create(project));
        }
    }

    private void notifyOnLegacyAndroidProject(@NotNull Project project) {
        if (project == null) {
            AndroidGradleProjectStartupActivity.$$$reportNull$$$0(3);
        }
        LegacyAndroidProjects legacyAndroidProjects = new LegacyAndroidProjects(project);
        if (AndroidProjectInfo.getInstance(project).isLegacyIdeaAndroidProject() && !AndroidProjectInfo.getInstance(project).isApkProject()) {
            legacyAndroidProjects.trackProject();
            if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
                legacyAndroidProjects.showMigrateToGradleWarning();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/gradle/project/AndroidGradleProjectStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "syncAndroidGradleProjectWithPersistedProjectData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyOnInvalidGradleJDKEnv";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyOnLegacyAndroidProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

