/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.io.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.settings.LocationSettingType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class ChooseGradleHomeDialog
extends DialogWrapper {
    @VisibleForTesting
    public static final String VALIDATION_MESSAGE_CLIENT_PROPERTY = "validation.message";
    @NotNull
    private final GradleInstallationManager myInstallationManager;
    @Nullable
    private final String myMinimumGradleVersion;
    private TextFieldWithBrowseButton myGradleHomePathField;
    private JBLabel myGradleHomeLabel;
    private JPanel myPanel;
    private JXLabel myDescriptionLabel;

    public ChooseGradleHomeDialog() {
        this("6.1.1");
    }

    public ChooseGradleHomeDialog(@Nullable String minimumGradleVersion) {
        this("Import Gradle Project", minimumGradleVersion);
    }

    public ChooseGradleHomeDialog(@NotNull @NlsContexts.DialogTitle String title, @Nullable String minimumGradleVersion) {
        if (title == null) {
            ChooseGradleHomeDialog.$$$reportNull$$$0(0);
        }
        super(null);
        this.myMinimumGradleVersion = minimumGradleVersion;
        this.$$$setupUI$$$();
        this.myInstallationManager = (GradleInstallationManager)ApplicationManager.getApplication().getService(GradleInstallationManager.class);
        this.init();
        this.initValidation();
        this.setTitle(title);
        FileChooserDescriptor fileChooserDescriptor2 = org.jetbrains.plugins.gradle.util.GradleUtil.getGradleHomeFileChooserDescriptor();
        this.myGradleHomePathField.addBrowseFolderListener("", GradleBundle.message((String)"gradle.settings.text.home.path", (Object[])new Object[0]), null, fileChooserDescriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myGradleHomeLabel.setLabelFor((Component)this.myGradleHomePathField.getTextField());
        this.getPeer().getWindow().pack();
        this.myGradleHomePathField.setText(org.jetbrains.plugins.gradle.util.GradleUtil.getLastUsedGradleHome());
        this.myGradleHomePathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String fixedPath;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((fixedPath = ChooseGradleHomeDialog.this.myInstallationManager.suggestBetterGradleHomePath(ChooseGradleHomeDialog.this.myGradleHomePathField.getText())) != null) {
                    ApplicationManager.getApplication().invokeLater(() -> ChooseGradleHomeDialog.this.myGradleHomePathField.setText(fixedPath));
                } else {
                    ChooseGradleHomeDialog.this.initValidation();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/ChooseGradleHomeDialog$1", "textChanged"));
            }
        });
    }

    public void setDescription(@NotNull String descriptionLabel) {
        if (descriptionLabel == null) {
            ChooseGradleHomeDialog.$$$reportNull$$$0(1);
        }
        this.myDescriptionLabel.setText(descriptionLabel);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        LocationSettingType locationSettingType = this.validateLocation();
        switch (locationSettingType) {
            case EXPLICIT_CORRECT: {
                ValidationInfo validationInfo = this.validateMinimumGradleVersion();
                if (validationInfo != null) {
                    return validationInfo;
                }
                return super.doValidate();
            }
        }
        return this.newPathIsInvalidInfo(locationSettingType.getDescription(GradleUtil.GRADLE_SYSTEM_ID));
    }

    @NotNull
    private LocationSettingType validateLocation() {
        String gradleHome = this.getEnteredGradleHomePath();
        if (gradleHome.isEmpty()) {
            LocationSettingType locationSettingType = LocationSettingType.UNKNOWN;
            if (locationSettingType == null) {
                ChooseGradleHomeDialog.$$$reportNull$$$0(2);
            }
            return locationSettingType;
        }
        File gradleHomePath = ChooseGradleHomeDialog.getGradleHomePath(gradleHome);
        LocationSettingType locationSettingType = this.myInstallationManager.isGradleSdkHome(gradleHomePath) ? LocationSettingType.EXPLICIT_CORRECT : LocationSettingType.EXPLICIT_INCORRECT;
        if (locationSettingType == null) {
            ChooseGradleHomeDialog.$$$reportNull$$$0(3);
        }
        return locationSettingType;
    }

    @Nullable
    private ValidationInfo validateMinimumGradleVersion() {
        if (StringUtil.isNotEmpty((String)this.myMinimumGradleVersion)) {
            GradleVersion minimum = GradleVersion.parse((String)this.myMinimumGradleVersion);
            File enteredGradleHomePath = ChooseGradleHomeDialog.getGradleHomePath(this.getEnteredGradleHomePath());
            GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion(enteredGradleHomePath);
            if (gradleVersion2 == null) {
                return this.newPathIsInvalidInfo("Unable to detect Gradle version");
            }
            if (minimum.compareTo(gradleVersion2) > 0) {
                return this.newPathIsInvalidInfo(String.format("Gradle %1$s or newer is required", this.myMinimumGradleVersion));
            }
        }
        return null;
    }

    @NotNull
    private ValidationInfo newPathIsInvalidInfo(@NotNull String msg) {
        if (msg == null) {
            ChooseGradleHomeDialog.$$$reportNull$$$0(4);
        }
        this.storeErrorMessage(msg);
        return new ValidationInfo(msg, (JComponent)this.myGradleHomePathField.getTextField());
    }

    private void storeErrorMessage(@NotNull String msg) {
        if (msg == null) {
            ChooseGradleHomeDialog.$$$reportNull$$$0(5);
        }
        this.myGradleHomePathField.putClientProperty((Object)VALIDATION_MESSAGE_CLIENT_PROPERTY, (Object)msg);
    }

    @NotNull
    private static File getGradleHomePath(@NotNull String gradleHome) {
        if (gradleHome == null) {
            ChooseGradleHomeDialog.$$$reportNull$$$0(6);
        }
        File file = FilePaths.toSystemDependentPath((String)gradleHome);
        if (file == null) {
            ChooseGradleHomeDialog.$$$reportNull$$$0(7);
        }
        return file;
    }

    public void storeLastUsedGradleHomePath() {
        org.jetbrains.plugins.gradle.util.GradleUtil.storeLastUsedGradleHome((String)this.getEnteredGradleHomePath());
    }

    @NotNull
    public String getEnteredGradleHomePath() {
        String string = this.myGradleHomePathField.getText();
        if (string == null) {
            ChooseGradleHomeDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionLabel";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/ChooseGradleHomeDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/ChooseGradleHomeDialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "validateLocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleHomePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnteredGradleHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newPathIsInvalidInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "storeErrorMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGradleHomePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JXLabel jXLabel;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myGradleHomePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(500, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myGradleHomeLabel = jBLabel = new JBLabel();
        jBLabel.setText("Gradle home:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDescriptionLabel = jXLabel = new JXLabel();
        jXLabel.setLineWrap(true);
        jXLabel.setText("");
        jPanel.add((Component)jXLabel, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

