/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.GradleModuleImporter;
import com.google.common.base.Function;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSiblingLookup
implements Function<String, VirtualFile> {
    @NotNull
    private final VirtualFile myImportSource;
    @NotNull
    private final Project myDestination;
    private Map<String, VirtualFile> mySiblingsMap;

    public GradleSiblingLookup(@NotNull VirtualFile importSource, @NotNull Project destination) {
        if (importSource == null) {
            GradleSiblingLookup.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            GradleSiblingLookup.$$$reportNull$$$0(1);
        }
        this.myImportSource = importSource;
        this.myDestination = destination;
    }

    private static Map<String, VirtualFile> findSiblings(@Nullable VirtualFile directory, Project project, Set<VirtualFile> seen) {
        if (directory == null) {
            return Collections.emptyMap();
        }
        if (seen.contains(directory)) {
            return GradleSiblingLookup.findSiblings(null, project, seen);
        }
        seen.add(directory);
        VirtualFile settings = directory.findChild("settings.gradle");
        if (settings == null) {
            return GradleSiblingLookup.findSiblings(directory.getParent(), project, seen);
        }
        return GradleModuleImporter.getSubProjects(settings, project);
    }

    public String getPrimaryProjectName() {
        Object name = ":" + this.myImportSource.getName();
        if (this.mySiblingsMap != null) {
            for (Map.Entry<String, VirtualFile> entry : this.mySiblingsMap.entrySet()) {
                if (!this.myImportSource.equals(entry.getValue())) continue;
                name = entry.getKey();
                break;
            }
        }
        return name;
    }

    public VirtualFile apply(String input) {
        if (this.mySiblingsMap == null) {
            this.mySiblingsMap = GradleSiblingLookup.findSiblings(this.myImportSource, this.myDestination, new HashSet<VirtualFile>());
        }
        return this.mySiblingsMap.get(input);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "importSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "destination";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/gradle/project/GradleSiblingLookup";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

