/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.library;

import com.android.tools.idea.gradle.util.GradleProjects;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPropertiesDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Library myLibrary;
    private JPanel myMainPanel;
    private JPanel myTreePanel;
    private JBLabel myIconLabel;
    private JBLabel myNameLabel;
    private LibraryRootsComponent myLibraryEditorComponent;
    private SourcesAndDocsOnlyEditor myEditor;

    public LibraryPropertiesDialog(@NotNull Project project, @NotNull Library library) {
        if (project == null) {
            LibraryPropertiesDialog.$$$reportNull$$$0(0);
        }
        if (library == null) {
            LibraryPropertiesDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myLibrary = library;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle("Library Properties");
    }

    @Nullable
    protected JComponent createCenterPanel() {
        MultiLineLabel propertiesLabel;
        this.myIconLabel.setIcon(AllIcons.Nodes.PpLib);
        this.myNameLabel.setText(this.myLibrary.getName());
        this.myEditor = new SourcesAndDocsOnlyEditor(this.myLibrary);
        this.myLibraryEditorComponent = new LibraryRootsComponent(this.myProject, (LibraryEditor)this.myEditor){

            public void updatePropertiesLabel() {
                MultiLineLabel propertiesLabel;
                JComponent c = this.getComponent();
                if (c != null && (propertiesLabel = (MultiLineLabel)UIUtil.findComponentOfType((JComponent)c, MultiLineLabel.class)) != null) {
                    propertiesLabel.setText("Add or remove source/Javadoc attachments");
                }
            }
        };
        this.myLibraryEditorComponent.updatePropertiesLabel();
        JComponent c = this.myLibraryEditorComponent.getComponent();
        List actionButtons = UIUtil.findComponentsOfType((JComponent)c, ActionButton.class);
        for (ActionButton actionButton : actionButtons) {
            String text = actionButton.getAction().getTemplatePresentation().getText();
            if (text == null || !text.startsWith("Exclude")) continue;
            actionButton.setVisible(false);
            break;
        }
        if ((propertiesLabel = (MultiLineLabel)UIUtil.findComponentOfType((JComponent)c, MultiLineLabel.class)) != null) {
            propertiesLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 1));
        }
        this.myTreePanel.add((Component)c, "Center");
        this.myTreePanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)1, (int)1, (int)1));
        return this.myMainPanel;
    }

    protected void dispose() {
        if (this.myLibraryEditorComponent != null) {
            Disposer.dispose((Disposable)this.myLibraryEditorComponent);
        }
        super.dispose();
    }

    public void applyChanges() {
        if (this.myEditor != null) {
            GradleProjects.executeProjectChanges(this.myProject, () -> ((SourcesAndDocsOnlyEditor)this.myEditor).commit());
        }
    }

    @VisibleForTesting
    LibraryRootsComponent getLibraryEditorComponent() {
        return this.myLibraryEditorComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "library";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/gradle/project/library/LibraryPropertiesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(600, 400), null));
        this.myIconLabel = jBLabel2 = new JBLabel();
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 1, null, null, null));
        this.myNameLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class SourcesAndDocsOnlyEditor
    extends ExistingLibraryEditor {
        SourcesAndDocsOnlyEditor(@NotNull Library library) {
            if (library == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(0);
            }
            super(library, null);
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(1);
            }
            if (SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                    SourcesAndDocsOnlyEditor.$$$reportNull$$$0(2);
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            String[] stringArray = super.getUrls(rootType);
            if (stringArray == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(3);
            }
            return stringArray;
        }

        public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
            if (file == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(4);
            }
            if (rootType == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(5);
            }
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.addRoot(file, rootType);
            }
        }

        public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
            if (url == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(6);
            }
            if (rootType == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(7);
            }
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.addRoot(url, rootType);
            }
        }

        public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
            if (url == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(8);
            }
            if (rootType == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(9);
            }
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.removeRoot(url, rootType);
            }
        }

        private static boolean isIgnored(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                SourcesAndDocsOnlyEditor.$$$reportNull$$$0(10);
            }
            return rootType == OrderRootType.CLASSES;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 1: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/library/LibraryPropertiesDialog$SourcesAndDocsOnlyEditor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/library/LibraryPropertiesDialog$SourcesAndDocsOnlyEditor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addRoot";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoot";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnored";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

