/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.NativeVariantInfo;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeVariantAbi;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModelFeatures;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.project.model.NdkVariantName;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 4L;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private IdeNativeAndroidProject myAndroidProject;
    @NotNull
    private transient NdkModelFeatures myFeatures;
    @Nullable
    private transient GradleVersion myModelVersion;
    @NotNull
    private List<IdeNativeVariantAbi> myVariantAbi;
    @NotNull
    private Map<String, NdkVariantName> myVariantNamesByVariantAndAbiName;
    @NotNull
    private Map<String, NdkVariant> myVariantsByName;
    @NotNull
    private Map<String, NativeToolchain> myToolchainsByName;
    @NotNull
    private Map<String, NativeSettings> mySettingsByName;
    @NotNull
    private String mySelectedVariantName;

    @Nullable
    public static NdkModuleModel get(@NotNull Module module) {
        NdkFacet facet2;
        if (module == null) {
            NdkModuleModel.$$$reportNull$$$0(0);
        }
        return (facet2 = NdkFacet.getInstance(module)) != null ? NdkModuleModel.get(facet2) : null;
    }

    @Nullable
    public static NdkModuleModel get(@NotNull NdkFacet ndkFacet) {
        NdkModuleModel androidModel;
        if (ndkFacet == null) {
            NdkModuleModel.$$$reportNull$$$0(1);
        }
        if ((androidModel = ndkFacet.getNdkModuleModel()) == null) {
            return null;
        }
        return androidModel;
    }

    @PropertyMapping(value={"myModuleName", "myRootDirPath", "myAndroidProject", "myVariantAbi"})
    public NdkModuleModel(@NotNull String moduleName2, @NotNull File rootDirPath, @NotNull IdeNativeAndroidProject androidProject, @NotNull List<IdeNativeVariantAbi> variantAbi) {
        if (moduleName2 == null) {
            NdkModuleModel.$$$reportNull$$$0(2);
        }
        if (rootDirPath == null) {
            NdkModuleModel.$$$reportNull$$$0(3);
        }
        if (androidProject == null) {
            NdkModuleModel.$$$reportNull$$$0(4);
        }
        if (variantAbi == null) {
            NdkModuleModel.$$$reportNull$$$0(5);
        }
        this.myVariantAbi = new ArrayList<IdeNativeVariantAbi>();
        this.myVariantNamesByVariantAndAbiName = new HashMap<String, NdkVariantName>();
        this.myVariantsByName = new HashMap<String, NdkVariant>();
        this.myToolchainsByName = new HashMap<String, NativeToolchain>();
        this.mySettingsByName = new HashMap<String, NativeSettings>();
        this.myModuleName = moduleName2;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.myVariantAbi.addAll(variantAbi);
        this.parseAndSetModelVersion();
        this.myFeatures = new NdkModelFeatures(this.myModelVersion);
        this.populateModuleFields();
        this.initializeSelectedVariant();
    }

    private void populateModuleFields() {
        if (this.myVariantAbi.isEmpty()) {
            this.populateForFullVariantsSync();
        } else {
            this.populateForSingleVariantSync();
        }
        if (this.myVariantsByName.isEmpty()) {
            this.myVariantsByName.put("------", new NdkVariant("------", this.myFeatures.isExportedHeadersSupported()));
            this.myVariantNamesByVariantAndAbiName.put("------", new NdkVariantName("---", "--"));
        }
    }

    private void populateForFullVariantsSync() {
        for (NativeArtifact artifact : this.myAndroidProject.getArtifacts()) {
            String variantName = this.myFeatures.isGroupNameSupported() ? artifact.getGroupName() : artifact.getName();
            NdkVariantName ndkVariantName = new NdkVariantName(variantName, artifact.getAbi());
            NdkVariant variant = this.myVariantsByName.get(ndkVariantName.displayName);
            if (variant == null) {
                variant = new NdkVariant(ndkVariantName.displayName, this.myFeatures.isExportedHeadersSupported());
                this.myVariantsByName.put(ndkVariantName.displayName, variant);
                this.myVariantNamesByVariantAndAbiName.put(ndkVariantName.displayName, ndkVariantName);
            }
            variant.addArtifact(artifact);
        }
        this.populateToolchains(this.myAndroidProject.getToolChains());
        this.populateSettings(this.myAndroidProject.getSettings());
    }

    private void populateForSingleVariantSync() {
        for (Map.Entry entry : this.myAndroidProject.getVariantInfos().entrySet()) {
            for (String abi : ((NativeVariantInfo)entry.getValue()).getAbiNames()) {
                NdkVariantName ndkVariantName = new NdkVariantName((String)entry.getKey(), abi);
                this.myVariantNamesByVariantAndAbiName.put(ndkVariantName.displayName, ndkVariantName);
            }
        }
        for (IdeNativeVariantAbi variantAbi : this.myVariantAbi) {
            this.populateForNativeVariantAbi(variantAbi);
        }
    }

    private void populateForNativeVariantAbi(@NotNull IdeNativeVariantAbi variantAbi) {
        if (variantAbi == null) {
            NdkModuleModel.$$$reportNull$$$0(6);
        }
        String variantName = NdkModuleModel.getNdkVariantName(variantAbi.getVariantName(), variantAbi.getAbi());
        NdkVariant variant = new NdkVariant(variantName, this.myFeatures.isExportedHeadersSupported());
        for (NativeArtifact artifact : variantAbi.getArtifacts()) {
            variant.addArtifact(artifact);
        }
        this.myVariantsByName.put(variantName, variant);
        this.populateToolchains(variantAbi.getToolChains());
        this.populateSettings(variantAbi.getSettings());
    }

    private void populateToolchains(@NotNull Collection<NativeToolchain> nativeToolchains) {
        if (nativeToolchains == null) {
            NdkModuleModel.$$$reportNull$$$0(7);
        }
        for (NativeToolchain toolchain : nativeToolchains) {
            this.myToolchainsByName.put(toolchain.getName(), toolchain);
        }
    }

    private void populateSettings(@NotNull Collection<NativeSettings> nativeSettings) {
        if (nativeSettings == null) {
            NdkModuleModel.$$$reportNull$$$0(8);
        }
        for (NativeSettings settings : nativeSettings) {
            this.mySettingsByName.put(settings.getName(), settings);
        }
    }

    private void initializeSelectedVariant() {
        Set<String> variantNames = this.myVariantsByName.keySet();
        assert (!variantNames.isEmpty());
        if (variantNames.size() == 1) {
            this.mySelectedVariantName = (String)Iterables.getOnlyElement(variantNames);
            return;
        }
        for (String variantName : variantNames) {
            if (!variantName.equals("debug") && !variantName.equals(NdkModuleModel.getNdkVariantName("debug", "x86"))) continue;
            this.mySelectedVariantName = variantName;
            return;
        }
        ArrayList<String> sortedVariantNames = new ArrayList<String>(variantNames);
        Collections.sort(sortedVariantNames);
        assert (!sortedVariantNames.isEmpty());
        this.mySelectedVariantName = (String)sortedVariantNames.get(0);
    }

    public void addVariantOnlyModuleModel(@NotNull IdeNativeVariantAbi variantAbi) {
        if (variantAbi == null) {
            NdkModuleModel.$$$reportNull$$$0(9);
        }
        this.myVariantAbi.add(variantAbi);
        this.populateForNativeVariantAbi(variantAbi);
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            NdkModuleModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            NdkModuleModel.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    public IdeNativeAndroidProject getAndroidProject() {
        IdeNativeAndroidProject ideNativeAndroidProject = this.myAndroidProject;
        if (ideNativeAndroidProject == null) {
            NdkModuleModel.$$$reportNull$$$0(12);
        }
        return ideNativeAndroidProject;
    }

    @NotNull
    public Collection<String> getNdkVariantNames() {
        Set<String> set = this.myVariantNamesByVariantAndAbiName.keySet();
        if (set == null) {
            NdkModuleModel.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public String getVariantName(@NotNull String ndkVariantName) {
        NdkVariantName result2;
        if (ndkVariantName == null) {
            NdkModuleModel.$$$reportNull$$$0(14);
        }
        if ((result2 = this.myVariantNamesByVariantAndAbiName.get(ndkVariantName)) == null) {
            throw new RuntimeException(String.format("Variant named '%s' but only variants named '%s' were found.", ndkVariantName, Joiner.on((String)",").join(this.myVariantNamesByVariantAndAbiName.keySet())));
        }
        String string = this.myVariantNamesByVariantAndAbiName.get((Object)ndkVariantName).variant;
        if (string == null) {
            NdkModuleModel.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getAbiName(@NotNull String ndkVariantName) {
        if (ndkVariantName == null) {
            NdkModuleModel.$$$reportNull$$$0(16);
        }
        String string = this.myVariantNamesByVariantAndAbiName.get((Object)ndkVariantName).abi;
        if (string == null) {
            NdkModuleModel.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String getNdkVariantName(@NotNull String variant, @NotNull String abi) {
        if (variant == null) {
            NdkModuleModel.$$$reportNull$$$0(18);
        }
        if (abi == null) {
            NdkModuleModel.$$$reportNull$$$0(19);
        }
        String string = variant + "-" + abi;
        if (string == null) {
            NdkModuleModel.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public Collection<NdkVariant> getVariants() {
        Collection<NdkVariant> collection2 = this.myVariantsByName.values();
        if (collection2 == null) {
            NdkModuleModel.$$$reportNull$$$0(21);
        }
        return collection2;
    }

    @NotNull
    public NdkVariant getSelectedVariant() {
        NdkVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        NdkVariant ndkVariant = selected;
        if (ndkVariant == null) {
            NdkModuleModel.$$$reportNull$$$0(22);
        }
        return ndkVariant;
    }

    public boolean variantExists(@NotNull String variantName) {
        if (variantName == null) {
            NdkModuleModel.$$$reportNull$$$0(23);
        }
        return this.myVariantsByName.containsKey(variantName);
    }

    public void setSelectedVariantName(@NotNull String name) {
        Set<String> variantNames;
        if (name == null) {
            NdkModuleModel.$$$reportNull$$$0(24);
        }
        if ((variantNames = this.myVariantsByName.keySet()).contains(name)) {
            this.mySelectedVariantName = name;
        } else {
            this.initializeSelectedVariant();
        }
    }

    @Nullable
    public NativeToolchain findToolchain(@NotNull String toolchainName) {
        if (toolchainName == null) {
            NdkModuleModel.$$$reportNull$$$0(25);
        }
        return this.myToolchainsByName.get(toolchainName);
    }

    @Nullable
    public NativeSettings findSettings(@NotNull String settingsName) {
        if (settingsName == null) {
            NdkModuleModel.$$$reportNull$$$0(26);
        }
        return this.mySettingsByName.get(settingsName);
    }

    @NotNull
    public NdkModelFeatures getFeatures() {
        NdkModelFeatures ndkModelFeatures = this.myFeatures;
        if (ndkModelFeatures == null) {
            NdkModuleModel.$$$reportNull$$$0(27);
        }
        return ndkModelFeatures;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myAndroidProject);
        out.writeObject(this.mySelectedVariantName);
        out.writeObject(this.myVariantAbi);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (IdeNativeAndroidProject)in.readObject();
        this.mySelectedVariantName = (String)in.readObject();
        this.myVariantAbi = (List)in.readObject();
        this.parseAndSetModelVersion();
        this.myFeatures = new NdkModelFeatures(this.myModelVersion);
        this.myVariantNamesByVariantAndAbiName = new HashMap<String, NdkVariantName>();
        this.myVariantsByName = new HashMap<String, NdkVariant>();
        this.myToolchainsByName = new HashMap<String, NativeToolchain>();
        this.mySettingsByName = new HashMap<String, NativeSettings>();
        this.populateModuleFields();
    }

    public int hashCode() {
        return Objects.hash(this.myModuleName, this.myRootDirPath, this.myAndroidProject, this.mySelectedVariantName, this.myVariantAbi);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NdkModuleModel)) {
            return false;
        }
        NdkModuleModel that = (NdkModuleModel)obj;
        if (!Objects.equals(this.myModuleName, that.myModuleName)) {
            return false;
        }
        if (!Objects.equals(this.myRootDirPath, that.myRootDirPath)) {
            return false;
        }
        if (!Objects.equals(this.myAndroidProject, that.myAndroidProject)) {
            return false;
        }
        if (!Objects.equals(this.mySelectedVariantName, that.mySelectedVariantName)) {
            return false;
        }
        return Objects.equals(this.myVariantAbi, that.myVariantAbi);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantAbi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeToolchains";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeSettings";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/NdkModuleModel";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkVariantName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abi";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchainName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/NdkModuleModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNdkVariantNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbiName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNdkVariantName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVariant";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "populateForNativeVariantAbi";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "populateToolchains";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "populateSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addVariantOnlyModuleModel";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 27: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getVariantName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAbiName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNdkVariantName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "variantExists";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedVariantName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findToolchain";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DummyNdkVariant {
        private static final String variantNameWithoutAbi = "---";
        private static final String abiName = "--";
        public static final String variantNameWithAbi = "------";
    }
}

