/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NdkVariant
implements Serializable {
    @NotNull
    private final String myVariantName;
    @NotNull
    private final Map<String, NativeArtifact> myArtifactsByName;
    private final boolean myExportedHeadersSupported;

    public NdkVariant() {
        this.myVariantName = "";
        this.myArtifactsByName = Collections.emptyMap();
        this.myExportedHeadersSupported = false;
    }

    NdkVariant(@NotNull String variantName, boolean exportedHeadersSupported) {
        if (variantName == null) {
            NdkVariant.$$$reportNull$$$0(0);
        }
        this.myVariantName = variantName;
        this.myArtifactsByName = new HashMap<String, NativeArtifact>();
        this.myExportedHeadersSupported = exportedHeadersSupported;
    }

    void addArtifact(@NotNull NativeArtifact artifact) {
        if (artifact == null) {
            NdkVariant.$$$reportNull$$$0(1);
        }
        this.myArtifactsByName.put(artifact.getName(), artifact);
    }

    @NotNull
    public String getName() {
        String string = this.myVariantName;
        if (string == null) {
            NdkVariant.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Collection<File> getSourceFolders() {
        LinkedHashSet<File> sourceFolders = new LinkedHashSet<File>();
        for (NativeArtifact artifact : this.getArtifacts()) {
            if (this.myExportedHeadersSupported) {
                sourceFolders.addAll(artifact.getExportedHeaders());
            }
            for (NativeFile sourceFile : artifact.getSourceFiles()) {
                File parentFile = sourceFile.getFilePath().getParentFile();
                if (parentFile == null) continue;
                sourceFolders.add(parentFile);
            }
        }
        ImmutableList immutableList = ImmutableList.copyOf(sourceFolders);
        if (immutableList == null) {
            NdkVariant.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @NotNull
    public Collection<NativeArtifact> getArtifacts() {
        Collection<NativeArtifact> collection2 = this.myArtifactsByName.values();
        if (collection2 == null) {
            NdkVariant.$$$reportNull$$$0(4);
        }
        return collection2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/NdkVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/NdkVariant";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

