/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.Projects;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;

public final class GradleFiles {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock;
    @NotNull
    private final Set<VirtualFile> myChangedFiles;
    @NotNull
    private final Set<VirtualFile> myChangedExternalFiles;
    @NotNull
    private final Map<VirtualFile, Integer> myFileHashes;
    @NotNull
    private final Set<VirtualFile> myExternalBuildFiles;
    @NotNull
    private final SyncListener mySyncListener;
    @NotNull
    private final FileEditorManagerListener myFileEditorListener;

    @NotNull
    public static GradleFiles getInstance(@NotNull Project project) {
        if (project == null) {
            GradleFiles.$$$reportNull$$$0(0);
        }
        GradleFiles gradleFiles = (GradleFiles)ServiceManager.getService((Project)project, GradleFiles.class);
        if (gradleFiles == null) {
            GradleFiles.$$$reportNull$$$0(1);
        }
        return gradleFiles;
    }

    private GradleFiles(@NotNull Project project) {
        if (project == null) {
            GradleFiles.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myChangedFiles = new HashSet<VirtualFile>();
        this.myChangedExternalFiles = new HashSet<VirtualFile>();
        this.myFileHashes = new HashMap<VirtualFile, Integer>();
        this.myExternalBuildFiles = new HashSet<VirtualFile>();
        this.mySyncListener = new SyncListener();
        this.myProject = project;
        final GradleFileChangeListener fileChangeListener = new GradleFileChangeListener(this);
        this.myFileEditorListener = new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleFiles.this.maybeAddOrRemovePsiTreeListener(event.getNewFile(), (PsiTreeChangeListener)fileChangeListener);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/gradle/project/sync/GradleFiles$1", "selectionChanged"));
            }
        };
        if (this.myProject.isDefault()) {
            return;
        }
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myFileEditorListener);
        GradleSyncState.subscribe(this.myProject, this.mySyncListener);
    }

    private void maybeAddOrRemovePsiTreeListener(@Nullable VirtualFile file, @NotNull PsiTreeChangeListener fileChangeListener) {
        if (fileChangeListener == null) {
            GradleFiles.$$$reportNull$$$0(3);
        }
        if (file == null || !file.isValid()) {
            return;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile2 == null) {
            return;
        }
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener(fileChangeListener);
        if (this.isGradleFile(psiFile2) || this.isExternalBuildFile(psiFile2)) {
            PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener(fileChangeListener);
        }
    }

    @NotNull
    @VisibleForTesting
    GradleSyncListener getSyncListener() {
        SyncListener syncListener = this.mySyncListener;
        if (syncListener == null) {
            GradleFiles.$$$reportNull$$$0(4);
        }
        return syncListener;
    }

    @NotNull
    @VisibleForTesting
    FileEditorManagerListener getFileEditorListener() {
        FileEditorManagerListener fileEditorManagerListener = this.myFileEditorListener;
        if (fileEditorManagerListener == null) {
            GradleFiles.$$$reportNull$$$0(5);
        }
        return fileEditorManagerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean hasHashForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.containsKey(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChangedFiles.clear();
            this.myChangedExternalFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChangedFile(@NotNull VirtualFile file, boolean isExternal) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (isExternal) {
                this.myChangedExternalFiles.add(file);
            } else {
                this.myChangedFiles.add(file);
            }
        }
    }

    private static void putHashForFile(@NotNull Map<VirtualFile, Integer> map2, @NotNull VirtualFile file) {
        Integer hash2;
        if (map2 == null) {
            GradleFiles.$$$reportNull$$$0(8);
        }
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(9);
        }
        if ((hash2 = GradleFiles.computeHash(file)) != null) {
            map2.put(file, hash2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeHashesForFiles(@NotNull Map<VirtualFile, Integer> files2) {
        if (files2 == null) {
            GradleFiles.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myFileHashes.clear();
            this.myFileHashes.putAll(files2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Integer getStoredHashForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsChangedFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myChangedFiles.contains(file) || this.myChangedExternalFiles.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExternalBuildFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeExternalBuildFiles(@NotNull Collection<VirtualFile> externalBuildFiles) {
        if (externalBuildFiles == null) {
            GradleFiles.$$$reportNull$$$0(13);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.addAll(externalBuildFiles);
        }
    }

    @Nullable
    private static Integer computeHash(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(14);
        }
        return (Integer)ReadAction.compute(() -> {
            if (!file.isValid()) {
                return null;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            return document == null ? null : Integer.valueOf(document.getText().hashCode());
        });
    }

    private boolean areHashesEqual(@NotNull VirtualFile file) {
        Integer oldHash;
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(15);
        }
        return (oldHash = this.getStoredHashForFile(file)) != null && oldHash.equals(GradleFiles.computeHash(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHashesOfChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            return this.filterHashes(this.myChangedFiles) && this.filterHashes(this.myChangedExternalFiles);
        }
    }

    private boolean filterHashes(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            GradleFiles.$$$reportNull$$$0(16);
        }
        boolean status = true;
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>();
        for (VirtualFile file : files2) {
            if (!this.areHashesEqual(file)) {
                status = false;
                continue;
            }
            toRemove.add(file);
        }
        files2.removeAll(toRemove);
        return status;
    }

    private void scheduleUpdateFileHashes() {
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile propertiesFile;
            File propertiesFilePath;
            HashMap<VirtualFile, Integer> fileHashes = new HashMap<VirtualFile, Integer>();
            GradleWrapper gradleWrapper = GradleWrapper.find(this.myProject);
            if (gradleWrapper != null && (propertiesFilePath = gradleWrapper.getPropertiesFilePath()).isFile() && (propertiesFile = gradleWrapper.getPropertiesFile()) != null) {
                GradleFiles.putHashForFile(fileHashes, propertiesFile);
            }
            this.removeExternalBuildFiles();
            ArrayList<VirtualFile> externalBuildFiles = new ArrayList<VirtualFile>();
            ArrayList modules = Lists.newArrayList((Object[])ModuleManager.getInstance((Project)this.myProject).getModules());
            ExecutorService executorService = AndroidIoManager.getInstance().getBackgroundDiskIoExecutor();
            ProgressManager progressManager = ProgressManager.getInstance();
            ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
            Application application = ApplicationManager.getApplication();
            Consumer<Module> computeHashes = module -> {
                NdkModuleModel ndkModuleModel;
                VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
                if (buildFile != null) {
                    ProgressManager.checkCanceled();
                    File path2 = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile);
                    if (path2.isFile()) {
                        ReadAction.run(() -> GradleFiles.putHashForFile(fileHashes, buildFile));
                    }
                }
                if ((ndkModuleModel = NdkModuleModel.get(module)) != null) {
                    for (File externalBuildFile : ndkModuleModel.getAndroidProject().getBuildFiles()) {
                        ProgressManager.checkCanceled();
                        if (!externalBuildFile.isFile()) continue;
                        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)externalBuildFile, (boolean)true);
                        externalBuildFiles.add(virtualFile);
                        if (virtualFile == null) continue;
                        GradleFiles.putHashForFile(fileHashes, virtualFile);
                    }
                }
            };
            modules.stream().map(module -> executorService.submit(() -> progressManager.executeProcessUnderProgress(() -> application.runReadAction(() -> computeHashes.accept((Module)module)), progressIndicator))).forEach(future2 -> {
                try {
                    future2.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            });
            this.storeExternalBuildFiles(externalBuildFiles);
            String[] fileNames = new String[]{"settings.gradle", "settings.gradle.kts", "gradle.properties"};
            File rootFolderPath = Projects.getBaseDirPath((Project)this.myProject);
            VirtualFile rootFolder = ProjectUtil.guessProjectDir((Project)this.myProject);
            if (rootFolder != null) {
                for (String fileName : fileNames) {
                    VirtualFile virtualFile;
                    File filePath = new File(rootFolderPath, fileName);
                    if (!filePath.isFile() || (virtualFile = rootFolder.findChild(fileName)) == null || !virtualFile.exists() || virtualFile.isDirectory()) continue;
                    GradleFiles.putHashForFile(fileHashes, virtualFile);
                }
            }
            this.storeHashesForFiles(fileHashes);
        }, this.myProject.getDisposed());
    }

    public boolean areGradleFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> !this.checkHashesOfChangedFiles());
    }

    public boolean areExternalBuildFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return !this.filterHashes(this.myChangedExternalFiles);
            }
        });
    }

    public boolean isGradleFile(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            GradleFiles.$$$reportNull$$$0(17);
        }
        if ((psiFile2.getFileType() == GroovyFileType.GROOVY_FILE_TYPE || psiFile2.getFileType().getName().equals("Kotlin")) && (psiFile2.getName().endsWith("gradle") || psiFile2.getName().endsWith("gradle.kts"))) {
            return true;
        }
        return psiFile2.getFileType() == PropertiesFileType.INSTANCE && ("gradle.properties".equals(psiFile2.getName()) || "gradle-wrapper.properties".equals(psiFile2.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternalBuildFile(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            GradleFiles.$$$reportNull$$$0(18);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myExternalBuildFiles.contains(psiFile2.getVirtualFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChangeListener";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalBuildFiles";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditorListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "maybeAddOrRemovePsiTreeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasHashForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addChangedFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putHashForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "storeHashesForFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStoredHashForFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsChangedFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "storeExternalBuildFiles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeHash";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areHashesEqual";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterHashes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isGradleFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isExternalBuildFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class GradleFileChangeListener
    extends PsiTreeChangeAdapter {
        @NotNull
        private final GradleFiles myGradleFiles;

        private GradleFileChangeListener(@NotNull GradleFiles gradleFiles) {
            if (gradleFiles == null) {
                GradleFileChangeListener.$$$reportNull$$$0(0);
            }
            this.myGradleFiles = gradleFiles;
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(1);
            }
            this.processEvent(event, event.getChild());
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(2);
            }
            this.processEvent(event, event.getChild());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(3);
            }
            this.processEvent(event, event.getNewChild(), event.getOldChild());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(4);
            }
            this.processEvent(event, event.getChild());
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(5);
            }
            this.processEvent(event, event.getOldChild(), event.getNewChild());
        }

        private void processEvent(@NotNull PsiTreeChangeEvent event, PsiElement ... elements) {
            PsiFile psiFile2;
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(6);
            }
            if (elements == null) {
                GradleFileChangeListener.$$$reportNull$$$0(7);
            }
            if ((psiFile2 = event.getFile()) == null) {
                return;
            }
            boolean isExternalBuildFile = this.myGradleFiles.isExternalBuildFile(psiFile2);
            if (!this.myGradleFiles.isGradleFile(psiFile2) && !isExternalBuildFile) {
                return;
            }
            if (this.myGradleFiles.containsChangedFile(psiFile2.getVirtualFile())) {
                return;
            }
            if (!this.myGradleFiles.myProject.isInitialized() || !PsiManager.getInstance((Project)this.myGradleFiles.myProject).isInProject((PsiElement)psiFile2)) {
                return;
            }
            boolean foundChange = false;
            for (PsiElement element : elements) {
                if (element == null || element instanceof PsiWhiteSpace || element.getNode().getElementType().equals(GroovyTokenTypes.mNLS) && (element.getParent() == null || element.getParent() instanceof GrCodeBlock || element.getParent() instanceof PsiFile)) continue;
                foundChange = true;
                break;
            }
            if (foundChange) {
                this.myGradleFiles.addChangedFile(psiFile2.getVirtualFile(), isExternalBuildFile);
                EditorNotifications.getInstance((Project)psiFile2.getProject()).updateNotifications(psiFile2.getVirtualFile());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleFiles";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleFiles$GradleFileChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SyncListener
    implements GradleSyncListener {
        private SyncListener() {
        }

        @Override
        public void syncStarted(@NotNull Project project) {
            if (project == null) {
                SyncListener.$$$reportNull$$$0(0);
            }
            this.maybeProcessSyncStarted(project);
        }

        private void maybeProcessSyncStarted(@NotNull Project project) {
            if (project == null) {
                SyncListener.$$$reportNull$$$0(1);
            }
            if (!project.isInitialized() && project.equals(GradleFiles.this.myProject)) {
                return;
            }
            GradleFiles.this.scheduleUpdateFileHashes();
            GradleFiles.this.removeChangedFiles();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleFiles$SyncListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "maybeProcessSyncStarted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UpdateHashesStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                UpdateHashesStartupActivity.$$$reportNull$$$0(0);
            }
            GradleFiles.getInstance(project).scheduleUpdateFileHashes();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleFiles$UpdateHashesStartupActivity", "runActivity"));
        }
    }
}

