/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.ui.GuiTestingService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Key;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class SimulatedSyncErrors {
    private static Key<ExternalSystemException> SIMULATED_ERROR_KEY = Key.create((String)"com.android.tools.idea.gradle.sync.simulated.errors");

    private SimulatedSyncErrors() {
    }

    public static void registerNullMessageSyncErrorToSimulate() {
        SimulatedSyncErrors.registerSyncErrorToSimulate(new Throwable());
    }

    public static void registerSyncErrorToSimulate(@NotNull String errorMessage) {
        if (errorMessage == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(0);
        }
        SimulatedSyncErrors.registerSyncErrorToSimulate(new Throwable(errorMessage));
    }

    public static void registerSyncErrorToSimulate(@NotNull Throwable cause) {
        if (cause == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(1);
        }
        SimulatedSyncErrors.verifyIsTestMode();
        ExternalSystemException exception = new ExternalSystemException(cause.getMessage());
        exception.initCause(cause);
        SimulatedSyncErrors.store(exception);
    }

    public static void registerSyncErrorToSimulate(@NotNull String errorMessage, @NotNull File errorFile) {
        if (errorMessage == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(2);
        }
        if (errorFile == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(3);
        }
        SimulatedSyncErrors.registerSyncErrorToSimulate(new Throwable(errorMessage), errorFile);
    }

    public static void registerSyncErrorToSimulate(@NotNull Throwable cause, @NotNull File errorFile) {
        if (cause == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(4);
        }
        if (errorFile == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(5);
        }
        SimulatedSyncErrors.verifyIsTestMode();
        LocationAwareExternalSystemException exception = new LocationAwareExternalSystemException(cause.getMessage(), errorFile.getPath(), new String[0]);
        exception.initCause(cause);
        SimulatedSyncErrors.store((ExternalSystemException)exception);
    }

    private static void store(@NotNull ExternalSystemException exception) {
        if (exception == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().putUserData(SIMULATED_ERROR_KEY, (Object)exception);
    }

    public static void simulateRegisteredSyncError() {
        Application application = ApplicationManager.getApplication();
        ExternalSystemException error = (ExternalSystemException)((Object)application.getUserData(SIMULATED_ERROR_KEY));
        if (error != null) {
            SimulatedSyncErrors.verifyIsTestMode();
            application.putUserData(SIMULATED_ERROR_KEY, null);
            throw error;
        }
    }

    private static void verifyIsTestMode() {
        if (!SimulatedSyncErrors.isTestMode()) {
            throw new IllegalStateException("Not in unit or UI test mode");
        }
    }

    private static boolean isTestMode() {
        return GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSyncErrorToSimulate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "store";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

