/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenPluginBuildFileHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class OldAndroidPluginErrorHandler
extends BaseSyncErrorHandler {
    private static final Pattern PATTERN = Pattern.compile("The android gradle plugin version .+ is too old, please update to the latest version.");

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text;
        if (rootCause == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(1);
        }
        if (OldAndroidPluginErrorHandler.isMatching(text = rootCause.getMessage())) {
            OldAndroidPluginErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.OLD_ANDROID_PLUGIN);
            return Joiner.on((char)'\n').join((Iterable)Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text));
        }
        return null;
    }

    @VisibleForTesting
    static boolean isMatching(String text) {
        if (StringUtil.isNotEmpty((String)text)) {
            String firstLine = OldAndroidPluginErrorHandler.getFirstLineMessage(text);
            if (firstLine.startsWith("Plugin is too old, please update to a more recent version")) {
                return true;
            }
            return PATTERN.matcher(firstLine).matches();
        }
        return false;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(2);
        }
        if (text == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(3);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        if (!GradleUtil.hasKtsBuildFiles(project)) {
            hyperlinks.add(new FixAndroidGradlePluginVersionHyperlink());
        }
        if (project.isInitialized()) {
            AndroidPluginInfo result2 = AndroidPluginInfo.findFromBuildFiles(project);
            if (result2 != null && result2.getPluginBuildFile() != null) {
                hyperlinks.add(new OpenFileHyperlink(result2.getPluginBuildFile().getPath()));
            }
        } else {
            hyperlinks.add(new OpenPluginBuildFileHyperlink());
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            OldAndroidPluginErrorHandler.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

