/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.ProjectSyncIssues;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeAndroidProjectImpl;
import com.android.ide.common.gradle.model.IdeNativeVariantAbi;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.gradle.model.GradlePluginModel;
import com.android.ide.gradle.model.sources.SourcesAndJavadocArtifacts;
import com.android.repository.Revision;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.IdeaJavaModuleModelFactory;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.SimulatedSyncErrors;
import com.android.tools.idea.gradle.project.sync.SyncActionOptions;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.errors.GradleDistributionInstallErrorHandler;
import com.android.tools.idea.gradle.project.sync.idea.GradleModelVersionCheck;
import com.android.tools.idea.gradle.project.sync.idea.GradleSyncExecutor;
import com.android.tools.idea.gradle.project.sync.idea.ProjectFinder;
import com.android.tools.idea.gradle.project.sync.idea.data.model.ProjectCleanupModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.issues.AgpUpgradeRequiredException;
import com.android.tools.idea.gradle.project.sync.idea.svs.AndroidExtraModelProvider;
import com.android.tools.idea.gradle.project.sync.idea.svs.VariantGroup;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.utils.BuildScriptUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt.idea.KaptGradleModel;
import org.jetbrains.kotlin.kapt.idea.KaptSourceSetModel;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;

@Order(value=1000)
public class AndroidGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final Key<Boolean> IS_ANDROID_PROJECT_KEY = Key.create((String)"IS_ANDROID_PROJECT_KEY");
    private static final Logger LOG = Logger.getInstance(AndroidGradleProjectResolver.class);
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final ProjectFinder myProjectFinder;
    @NotNull
    private final VariantSelector myVariantSelector;
    @NotNull
    private final IdeNativeAndroidProject.Factory myNativeAndroidProjectFactory;
    @NotNull
    private final IdeaJavaModuleModelFactory myIdeaJavaModuleModelFactory;
    @NotNull
    private final IdeDependenciesFactory myDependenciesFactory;
    @NotNull
    private final ModalityState myModality;

    public AndroidGradleProjectResolver() {
        this(new CommandLineArgs(), new ProjectFinder(), new VariantSelector(), (IdeNativeAndroidProject.Factory)new IdeNativeAndroidProjectImpl.FactoryImpl(), new IdeaJavaModuleModelFactory(), new IdeDependenciesFactory());
    }

    @NonInjectable
    @VisibleForTesting
    AndroidGradleProjectResolver(@NotNull CommandLineArgs commandLineArgs, @NotNull ProjectFinder projectFinder, @NotNull VariantSelector variantSelector, @NotNull IdeNativeAndroidProject.Factory nativeAndroidProjectFactory, @NotNull IdeaJavaModuleModelFactory ideaJavaModuleModelFactory, @NotNull IdeDependenciesFactory dependenciesFactory) {
        if (commandLineArgs == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(0);
        }
        if (projectFinder == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(1);
        }
        if (variantSelector == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(2);
        }
        if (nativeAndroidProjectFactory == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(3);
        }
        if (ideaJavaModuleModelFactory == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(4);
        }
        if (dependenciesFactory == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(5);
        }
        this.myCommandLineArgs = commandLineArgs;
        this.myProjectFinder = projectFinder;
        this.myVariantSelector = variantSelector;
        this.myNativeAndroidProjectFactory = nativeAndroidProjectFactory;
        this.myIdeaJavaModuleModelFactory = ideaJavaModuleModelFactory;
        this.myDependenciesFactory = dependenciesFactory;
        this.myModality = ModalityState.defaultModalityState();
    }

    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        AndroidProject androidProject;
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(6);
        }
        if (projectDataNode == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(7);
        }
        if ((androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class)) != null && !GradleModelVersionCheck.isSupportedVersion(androidProject)) {
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_ANDROID_MODEL_VERSION).setGradleVersion(androidProject.getModelVersion());
            UsageTrackerUtils.withProjectId(event, this.myProjectFinder.findProject(this.resolverCtx));
            UsageTracker.log((AndroidStudioEvent.Builder)event);
            String msg = AndroidGradleProjectResolver.getUnsupportedModelVersionErrorMsg(GradleModelVersionCheck.getModelVersion(androidProject));
            throw new IllegalStateException(msg);
        }
        if (androidProject != null) {
            Project project = this.myProjectFinder.findProject(this.resolverCtx);
            GradleVersion currentAgpVersion = GradleVersion.tryParse((String)androidProject.getModelVersion());
            GradleVersion latestVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
            if (currentAgpVersion != null && GradlePluginUpgrade.shouldForcePluginUpgrade(project, currentAgpVersion, latestVersion)) {
                throw new AgpUpgradeRequiredException(project, currentAgpVersion);
            }
        }
        DataNode dataNode = this.nextResolver.createModule(gradleModule, projectDataNode);
        if (dataNode == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(8);
        }
        return dataNode;
    }

    private void populateSourcesAndJavadocModel(@NotNull IdeaModule gradleModule) {
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(9);
        }
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        SourcesAndJavadocArtifacts artifacts = (SourcesAndJavadocArtifacts)this.resolverCtx.getExtraProject(gradleModule, SourcesAndJavadocArtifacts.class);
        if (artifacts != null && project != null) {
            LibraryFilePaths.getInstance(project).populate(artifacts);
        }
    }

    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        File gradleSettingsFile;
        NativeAndroidProject nativeAndroidProject;
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(10);
        }
        if (ideModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(11);
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            return;
        }
        this.populateSourcesAndJavadocModel(gradleModule);
        File moduleRootDirPath = FilePaths.toSystemDependentPath((String)((ModuleData)ideModule.getData()).getLinkedExternalProjectPath());
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        ProjectSyncIssues projectSyncIssues = (ProjectSyncIssues)this.resolverCtx.getExtraProject(gradleModule, ProjectSyncIssues.class);
        boolean androidProjectWithoutVariants = false;
        String moduleName2 = ((ModuleData)ideModule.getData()).getInternalName();
        VariantGroup variantGroup = (VariantGroup)this.resolverCtx.getExtraProject(gradleModule, VariantGroup.class);
        KaptGradleModel kaptGradleModel = (KaptGradleModel)this.resolverCtx.getExtraProject(gradleModule, KaptGradleModel.class);
        if (androidProject != null) {
            List<Variant> variants;
            Variant selectedVariant = this.myVariantSelector.findVariantToSelect(androidProject);
            if (selectedVariant == null && variantGroup != null && !(variants = variantGroup.getVariants()).isEmpty()) {
                selectedVariant = variants.get(0);
            }
            if (selectedVariant == null) {
                androidProjectWithoutVariants = true;
            } else {
                AndroidModuleModel model2 = AndroidModuleModel.create(moduleName2, moduleRootDirPath, androidProject, selectedVariant.getName(), this.myDependenciesFactory, variantGroup == null ? null : variantGroup.getVariants(), projectSyncIssues);
                this.populateKaptKotlinGeneratedSourceDir(gradleModule, model2);
                ideModule.createChild(AndroidProjectKeys.ANDROID_MODEL, (Object)model2);
            }
        }
        if ((nativeAndroidProject = (NativeAndroidProject)this.resolverCtx.getExtraProject(gradleModule, NativeAndroidProject.class)) != null) {
            IdeNativeAndroidProject copy = this.myNativeAndroidProjectFactory.create(nativeAndroidProject);
            ArrayList<IdeNativeVariantAbi> ideNativeVariantAbis = new ArrayList<IdeNativeVariantAbi>();
            if (variantGroup != null) {
                ideNativeVariantAbis.addAll(variantGroup.getNativeVariants().stream().map(IdeNativeVariantAbi::new).collect(Collectors.toList()));
            }
            NdkModuleModel ndkModuleModel = new NdkModuleModel(moduleName2, moduleRootDirPath, copy, ideNativeVariantAbis);
            ideModule.createChild(AndroidProjectKeys.NDK_MODEL, (Object)ndkModuleModel);
        }
        if ((gradleSettingsFile = BuildScriptUtil.findGradleSettingsFile((File)moduleRootDirPath)).isFile() && androidProject == null && nativeAndroidProject == null && !this.hasArtifacts(gradleModule)) {
            this.createJavaProject(gradleModule, ideModule, Collections.emptyList(), false, false, kaptGradleModel);
            return;
        }
        BuildScriptClasspathModel buildScriptModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(BuildScriptClasspathModel.class);
        String gradleVersion2 = buildScriptModel != null ? buildScriptModel.getGradleVersion() : null;
        GradleProject gradleProject = gradleModule.getGradleProject();
        GradleScript buildScript = null;
        try {
            buildScript = gradleProject.getBuildScript();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        File buildFilePath = buildScript != null ? buildScript.getSourceFile() : null;
        String agpVersion = androidProject != null ? androidProject.getModelVersion() : null;
        GradlePluginModel gradlePluginModel = (GradlePluginModel)this.resolverCtx.getExtraProject(gradleModule, GradlePluginModel.class);
        ArrayList<String> gradlePluginList = new ArrayList<String>();
        if (gradlePluginModel != null) {
            gradlePluginList.addAll(gradlePluginModel.getGradlePluginList());
        }
        GradleModuleModel gradleModuleModel = new GradleModuleModel(moduleName2, gradleProject, gradlePluginList, buildFilePath, gradleVersion2, agpVersion, kaptGradleModel);
        ideModule.createChild(AndroidProjectKeys.GRADLE_MODULE_MODEL, (Object)gradleModuleModel);
        if (nativeAndroidProject == null && (androidProject == null || androidProjectWithoutVariants)) {
            Object issues = ImmutableList.of();
            if (projectSyncIssues != null) {
                issues = projectSyncIssues.getSyncIssues();
            } else if (androidProject != null) {
                issues = androidProject.getSyncIssues();
            }
            this.createJavaProject(gradleModule, ideModule, (Collection<SyncIssue>)issues, androidProjectWithoutVariants, gradlePluginList.contains("org.gradle.api.plugins.JavaPlugin"), kaptGradleModel);
            if ("buildSrc".equals(gradleModule.getGradleProject().getName())) {
                this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            }
        }
    }

    private boolean hasArtifacts(@NotNull IdeaModule gradleModule) {
        ExternalProject externalProject;
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(12);
        }
        return (externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null && !externalProject.getArtifacts().isEmpty();
    }

    private void createJavaProject(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull Collection<SyncIssue> syncIssues, boolean androidProjectWithoutVariants, boolean isBuildable, @Nullable KaptGradleModel kaptGradleModel) {
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(13);
        }
        if (ideModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(14);
        }
        if (syncIssues == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(15);
        }
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        JavaModuleModel javaModuleModel = this.myIdeaJavaModuleModelFactory.create(gradleModule, syncIssues, externalProject, androidProjectWithoutVariants, isBuildable, kaptGradleModel);
        ideModule.createChild(AndroidProjectKeys.JAVA_MODULE_MODEL, (Object)javaModuleModel);
    }

    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(16);
        }
        if (ideModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(17);
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(18);
        }
        if (ideModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(19);
        }
        if (ideProject == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(20);
        }
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
    }

    private boolean isAndroidGradleProject() {
        Boolean isAndroidGradleProject = (Boolean)this.resolverCtx.getUserData(IS_ANDROID_PROJECT_KEY);
        if (isAndroidGradleProject != null) {
            return isAndroidGradleProject;
        }
        isAndroidGradleProject = this.resolverCtx.hasModulesWithModel(AndroidProject.class) || this.resolverCtx.hasModulesWithModel(NativeAndroidProject.class);
        return (Boolean)this.resolverCtx.putUserDataIfAbsent(IS_ANDROID_PROJECT_KEY, (Object)isAndroidGradleProject);
    }

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleProject == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(21);
        }
        if (projectDataNode == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(22);
        }
        this.populateModuleBuildDirs(gradleProject);
        this.populateGlobalLibraryMap();
        if (this.isAndroidGradleProject()) {
            projectDataNode.createChild(AndroidProjectKeys.PROJECT_CLEANUP_MODEL, (Object)ProjectCleanupModel.getInstance());
        }
        super.populateProjectExtraModels(gradleProject, projectDataNode);
    }

    private void populateKaptKotlinGeneratedSourceDir(@NotNull IdeaModule gradleModule, @NotNull AndroidModuleModel androidModuleModel) {
        KaptGradleModel kaptGradleModel;
        if (gradleModule == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(23);
        }
        if (androidModuleModel == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(24);
        }
        if ((kaptGradleModel = (KaptGradleModel)this.resolverCtx.getExtraProject(gradleModule, KaptGradleModel.class)) == null || !kaptGradleModel.isEnabled()) {
            return;
        }
        for (KaptSourceSetModel sourceSetModel : kaptGradleModel.getSourceSets()) {
            File kotlinGenSourceDir = sourceSetModel.getGeneratedKotlinSourcesDirFile();
            IdeBaseArtifact artifact = AndroidGradleProjectResolver.findArtifact(sourceSetModel, androidModuleModel);
            if (artifact == null || kotlinGenSourceDir == null) continue;
            artifact.addGeneratedSourceFolder(kotlinGenSourceDir);
        }
    }

    @Nullable
    private static IdeBaseArtifact findArtifact(@NotNull KaptSourceSetModel sourceSetModel, @NotNull AndroidModuleModel androidModel) {
        if (sourceSetModel == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(25);
        }
        if (androidModel == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(26);
        }
        String sourceSetName = sourceSetModel.getSourceSetName();
        if (!sourceSetModel.isTest()) {
            IdeVariant variant = androidModel.findVariantByName(sourceSetName);
            return variant == null ? null : variant.getMainArtifact();
        }
        String androidTestSuffix = "AndroidTest";
        if (sourceSetName.endsWith(androidTestSuffix)) {
            String variantName = sourceSetName.substring(0, sourceSetName.length() - androidTestSuffix.length());
            IdeVariant variant = androidModel.findVariantByName(variantName);
            return variant == null ? null : variant.getAndroidTestArtifact();
        }
        String unitTestSuffix = "UnitTest";
        if (sourceSetName.endsWith(unitTestSuffix)) {
            String variantName = sourceSetName.substring(0, sourceSetName.length() - unitTestSuffix.length());
            IdeVariant variant = androidModel.findVariantByName(variantName);
            return variant == null ? null : variant.getUnitTestArtifact();
        }
        return null;
    }

    private void populateModuleBuildDirs(@NotNull IdeaProject rootIdeaProject) {
        if (rootIdeaProject == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(27);
        }
        for (IdeaModule ideaModule : rootIdeaProject.getChildren()) {
            GradleProject gradleProject = ideaModule.getGradleProject();
            if (gradleProject == null) continue;
            String rootBuildId = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir().getPath();
            this.myDependenciesFactory.setRootBuildId(rootBuildId);
            break;
        }
        ArrayList<IdeaProject> ideaProjects = new ArrayList<IdeaProject>();
        ideaProjects.add(rootIdeaProject);
        List includedBuilds = this.resolverCtx.getModels().getIncludedBuilds();
        for (Build includedBuild : includedBuilds) {
            IdeaProject ideaProject = (IdeaProject)this.resolverCtx.getModels().getModel((BuildModel)includedBuild, IdeaProject.class);
            assert (ideaProject != null);
            ideaProjects.add(ideaProject);
        }
        for (IdeaProject ideaProject : ideaProjects) {
            for (IdeaModule ideaModule : ideaProject.getChildren()) {
                GradleProject gradleProject = ideaModule.getGradleProject();
                if (gradleProject == null) continue;
                try {
                    String buildId = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir().getPath();
                    this.myDependenciesFactory.findAndAddBuildFolderPath(buildId, gradleProject.getPath(), gradleProject.getBuildDirectory());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
    }

    private void populateGlobalLibraryMap() {
        ArrayList<GlobalLibraryMap> globalLibraryMaps = new ArrayList<GlobalLibraryMap>();
        Build mainBuild = this.resolverCtx.getModels().getMainBuild();
        List includedBuilds = this.resolverCtx.getModels().getIncludedBuilds();
        ArrayList<Build> builds = new ArrayList<Build>(includedBuilds.size() + 1);
        builds.add(mainBuild);
        builds.addAll(includedBuilds);
        for (Build build2 : builds) {
            GlobalLibraryMap mapOfCurrentBuild = null;
            for (ProjectModel projectModel : build2.getProjects()) {
                GlobalLibraryMap moduleMap = (GlobalLibraryMap)this.resolverCtx.getModels().getModel(projectModel, GlobalLibraryMap.class);
                if (mapOfCurrentBuild != null && (moduleMap == null || moduleMap.getLibraries().size() <= mapOfCurrentBuild.getLibraries().size())) continue;
                mapOfCurrentBuild = moduleMap;
            }
            if (mapOfCurrentBuild == null) continue;
            globalLibraryMaps.add(mapOfCurrentBuild);
        }
        this.myDependenciesFactory.setUpGlobalLibraryMap(globalLibraryMaps);
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        LinkedHashSet modelClasses = new LinkedHashSet();
        modelClasses.add(AndroidProject.class);
        modelClasses.add(NativeAndroidProject.class);
        modelClasses.add(GlobalLibraryMap.class);
        modelClasses.add(GradlePluginModel.class);
        modelClasses.add(ProjectSyncIssues.class);
        LinkedHashSet linkedHashSet = modelClasses;
        if (linkedHashSet == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(28);
        }
        return linkedHashSet;
    }

    @NotNull
    public ProjectImportModelProvider getModelProvider() {
        return this.configureAndGetExtraModelProvider();
    }

    public void preImportCheck() {
        SimulatedSyncErrors.simulateRegisteredSyncError();
    }

    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID)) {
            File androidHomePath;
            LocalProperties localProperties;
            ArrayList<Pair<String, String>> args = new ArrayList<Pair<String, String>>();
            if (!IdeInfo.getInstance().isAndroidStudio() && (localProperties = this.getLocalProperties()).getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                args.add((Pair<String, String>)Pair.create((Object)"android.home", (Object)androidHomePath.getPath()));
            }
            ArrayList<Pair<String, String>> arrayList = args;
            if (arrayList == null) {
                AndroidGradleProjectResolver.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        List<Pair<String, String>> list = Collections.emptyList();
        if (list == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    private LocalProperties getLocalProperties() {
        File projectDir = FilePaths.toSystemDependentPath((String)this.resolverCtx.getProjectPath());
        try {
            return new LocalProperties(projectDir);
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file in project '%1$s'", projectDir.getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    @NotNull
    public List<String> getExtraCommandLineArgs() {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        List<String> list = this.myCommandLineArgs.get(project);
        if (list == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        String msg;
        if (error == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(32);
        }
        if (projectPath == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(33);
        }
        if ((msg = error.getMessage()) != null && !msg.contains("The project is using an unsupported version of the Android Gradle plug-in")) {
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)error);
            if (rootCause instanceof ClassNotFoundException) {
                msg = rootCause.getMessage();
                if (AndroidGradleProjectResolver.isUsingUnsupportedGradleVersion(msg)) {
                    AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
                    event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
                    UsageTrackerUtils.withProjectId(event, this.myProjectFinder.findProject(this.resolverCtx));
                    UsageTracker.log((AndroidStudioEvent.Builder)event);
                    return new ExternalSystemException("The project is using an unsupported version of Gradle.");
                }
            } else if (rootCause instanceof ZipException && GradleDistributionInstallErrorHandler.COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PATTERN.matcher(msg).matches()) {
                return new ExternalSystemException(msg);
            }
        }
        ExternalSystemException externalSystemException = super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
        if (externalSystemException == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(34);
        }
        return externalSystemException;
    }

    private static boolean isUsingUnsupportedGradleVersion(@Nullable String errorMessage) {
        return "org.gradle.api.artifacts.result.ResolvedComponentResult".equals(errorMessage) || "org.gradle.api.artifacts.result.ResolvedModuleVersionResult".equals(errorMessage);
    }

    @NotNull
    private static String getUnsupportedModelVersionErrorMsg(@Nullable GradleVersion modelVersion) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("The project is using an unsupported version of the Android Gradle plug-in");
        String recommendedVersion = String.format("The recommended version is %1$s.", LatestKnownPluginVersionProvider.INSTANCE.get());
        if (modelVersion != null) {
            builder2.append(String.format(" (%1$s).", modelVersion.toString())).append(" ").append(recommendedVersion);
            if (modelVersion.getMajor() == 0 && modelVersion.getMinor() <= 8) {
                builder2.append("\n\nStarting with version 0.9.0 incompatible changes were introduced in the build language.\n").append("Please read the migration guide").append(" to learn how to update your project.");
            }
        } else {
            builder2.append(". ").append(recommendedVersion);
        }
        String string = builder2.toString();
        if (string == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private ProjectImportModelProvider configureAndGetExtraModelProvider() {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        SelectedVariants selectedVariants = null;
        boolean isSingleVariantSync = false;
        boolean shouldGenerateSources = false;
        Collection<String> cachedSourcesAndJavadoc = null;
        String moduleWithVariantSwitched = null;
        if (project != null) {
            isSingleVariantSync = AndroidGradleProjectResolver.shouldOnlySyncSingleVariant(project);
            if (isSingleVariantSync) {
                SelectedVariantCollector variantCollector = new SelectedVariantCollector(project);
                selectedVariants = variantCollector.collectSelectedVariants();
                moduleWithVariantSwitched = (String)project.getUserData(BuildVariantUpdater.MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI);
                project.putUserData(BuildVariantUpdater.MODULE_WITH_BUILD_VARIANT_SWITCHED_FROM_UI, null);
            }
            cachedSourcesAndJavadoc = LibraryFilePaths.getInstance(project).retrieveCachedLibs();
        }
        SyncActionOptions options = new SyncActionOptions();
        options.setModuleIdWithVariantSwitched(moduleWithVariantSwitched);
        options.setSingleVariantSyncEnabled(isSingleVariantSync);
        options.setSelectedVariants(selectedVariants);
        options.setCachedSourcesAndJavadoc(cachedSourcesAndJavadoc);
        return new AndroidExtraModelProvider(options);
    }

    private static boolean shouldOnlySyncSingleVariant(@NotNull Project project) {
        Boolean shouldOnlySyncSingleVariant;
        if (project == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(36);
        }
        return (shouldOnlySyncSingleVariant = (Boolean)project.getUserData(GradleSyncExecutor.SINGLE_VARIANT_KEY)) != null && shouldOnlySyncSingleVariant != false;
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters2) {
        if (parameters2 == null) {
            AndroidGradleProjectResolver.$$$reportNull$$$0(37);
        }
        PathsList classPath = parameters2.getClassPath();
        classPath.add(PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()));
        classPath.add(PathUtil.getJarPathForClass(Revision.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidGradleSettings.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidProject.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArgs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFinder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantSelector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeAndroidProjectFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaJavaModuleModelFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesFactory";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleModel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetModel";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootIdeaProject";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/AndroidGradleProjectResolver";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraJvmArgs";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraCommandLineArgs";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFriendlyError";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsupportedModelVersionErrorMsg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "populateSourcesAndJavadocModel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleContentRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasArtifacts";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createJavaProject";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleCompileOutputSettings";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleDependencies";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "populateKaptKotlinGeneratedSourceDir";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleBuildDirs";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyError";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shouldOnlySyncSingleVariant";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "enhanceRemoteProcessing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

