/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DisableOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowDependencyInProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowSyncIssuesDetailsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueUsageReporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class UnresolvedDependenciesReporter
extends SimpleDeduplicatingSyncIssueReporter {
    private static final String UNRESOLVED_DEPENDENCIES_GROUP = "Unresolved dependencies";

    @NotNull
    public static UnresolvedDependenciesReporter getInstance() {
        UnresolvedDependenciesReporter unresolvedDependenciesReporter = (UnresolvedDependenciesReporter)ApplicationManager.getApplication().getService(UnresolvedDependenciesReporter.class);
        if (unresolvedDependenciesReporter == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(0);
        }
        return unresolvedDependenciesReporter;
    }

    @Override
    int getSupportedIssueType() {
        return 2;
    }

    @Override
    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel2, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        if (project == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(1);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(2);
        }
        if (projectBuildModel2 == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(3);
        }
        if (syncIssues == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(4);
        }
        if (buildFile == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(5);
        }
        assert (!syncIssues.isEmpty());
        String dependency = syncIssues.get(0).getData();
        GradleBuildModel buildModel = projectBuildModel2.getModuleBuildModel(buildFile);
        ArtifactDependencyModel dependencyModel = buildModel.dependencies().artifacts().stream().filter(artifact -> artifact.compactNotation().equals(dependency)).findFirst().orElse(null);
        PsiElement element = dependencyModel == null ? null : dependencyModel.getPsiElement();
        int lineNumber = UnresolvedDependenciesReporter.getLineNumberForElement(project, element);
        return new OpenFileHyperlink(buildFile.getPath(), module.getName(), lineNumber, -1);
    }

    @Override
    @NotNull
    protected Object getDeduplicationKey(@NotNull SyncIssue issue2) {
        if (issue2 == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(6);
        }
        SyncIssue syncIssue = issue2;
        if (syncIssue == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(7);
        }
        return syncIssue;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (project == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(8);
        }
        if (syncIssues == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(9);
        }
        if (affectedModules == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(10);
        }
        if (buildFileMap == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(11);
        }
        assert (!syncIssues.isEmpty() && !affectedModules.isEmpty());
        SyncIssue issue2 = syncIssues.get(0);
        String dependency = issue2.getData();
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        if (dependency == null) {
            ArrayList<String> extraInfo = new ArrayList<String>();
            try {
                List multiLineMessage = issue2.getMultiLineMessage();
                if (multiLineMessage != null) {
                    extraInfo.addAll(multiLineMessage);
                }
            }
            catch (UnsupportedOperationException multiLineMessage) {
                // empty catch block
            }
            if (!extraInfo.isEmpty()) {
                quickFixes.add(new ShowSyncIssuesDetailsHyperlink(issue2.getMessage(), extraInfo));
            }
            if (GradleProjects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(0, new DisableOfflineModeHyperlink());
            }
            ArrayList<NotificationHyperlink> arrayList = quickFixes;
            if (arrayList == null) {
                UnresolvedDependenciesReporter.$$$reportNull$$$0(12);
            }
            return arrayList;
        }
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)dependency);
        List<VirtualFile> buildFiles = affectedModules.stream().map(m -> (VirtualFile)buildFileMap.get(m)).collect(Collectors.toList());
        Module module = affectedModules.get(0);
        if (dependency.startsWith("com.android.support") || dependency.startsWith("androidx.") || dependency.startsWith("com.google.android")) {
            UnresolvedDependenciesReporter.addGoogleMavenRepositoryHyperlink(project, buildFiles, quickFixes);
        } else if (GradleProjects.isOfflineBuildModeEnabled(project)) {
            quickFixes.add(new DisableOfflineModeHyperlink());
        }
        if (IdeInfo.getInstance().isAndroidStudio() && buildFileMap.values().stream().noneMatch(GradleUtil::isKtsFile) && coordinate != null) {
            quickFixes.add(new ShowDependencyInProjectStructureHyperlink(module, coordinate));
        }
        ArrayList<NotificationHyperlink> arrayList = quickFixes;
        if (arrayList == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        if (project == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(14);
        }
        if (syncIssues == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(15);
        }
        if (affectedModules == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(16);
        }
        if (buildFileMap == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(17);
        }
        if (type == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(18);
        }
        NotificationData notificationData = super.setupNotificationData(project, syncIssues, affectedModules, buildFileMap, type);
        notificationData.setTitle(UNRESOLVED_DEPENDENCIES_GROUP);
        String dependency = syncIssues.get(0).getData();
        if (dependency == null) {
            NotificationData notificationData2 = notificationData;
            if (notificationData2 == null) {
                UnresolvedDependenciesReporter.$$$reportNull$$$0(19);
            }
            return notificationData2;
        }
        String message2 = "Failed to resolve: " + dependency;
        notificationData.setMessage(message2);
        NotificationData notificationData3 = notificationData;
        if (notificationData3 == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(20);
        }
        return notificationData3;
    }

    public void report(@NotNull Collection<String> unresolvedDependencies, @NotNull Module module) {
        if (unresolvedDependencies == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(21);
        }
        if (module == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(22);
        }
        if (unresolvedDependencies.isEmpty()) {
            return;
        }
        VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
        List<SyncIssue> syncIssues = unresolvedDependencies.stream().map(s -> new SyncIssue((String)s){
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
            }

            public int getSeverity() {
                return 2;
            }

            public int getType() {
                return 2;
            }

            @Nullable
            public String getData() {
                return this.val$s;
            }

            public String getMessage() {
                return this.val$s;
            }

            @Nullable
            public List<String> getMultiLineMessage() {
                return null;
            }
        }).collect(Collectors.toList());
        SyncIssueUsageReporter syncIssueUsageReporter = SyncIssueUsageReporter.Companion.getInstance(module.getProject());
        this.reportAll(syncIssues, syncIssues.stream().collect(Collectors.toMap(Function.identity(), k -> module)), (Map<Module, VirtualFile>)(buildFile == null ? ImmutableMap.of() : ImmutableMap.of((Object)module, (Object)buildFile)), syncIssueUsageReporter);
    }

    @NotNull
    private static Collection<RemotePackage> getRemotePackages(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(23);
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepositoryPackages packages = sdkHandler.getSdkManager(indicator).getPackages();
        Collection<RemotePackage> collection2 = packages.getRemotePackages().values();
        if (collection2 == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(24);
        }
        return collection2;
    }

    private static void addGoogleMavenRepositoryHyperlink(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull List<NotificationHyperlink> fixes) {
        if (project == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(25);
        }
        if (buildFiles == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(26);
        }
        if (fixes == null) {
            UnresolvedDependenciesReporter.$$$reportNull$$$0(27);
        }
        if (!project.isInitialized()) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink(project));
            return;
        }
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog((Project)project);
        if (projectBuildModel2 == null) {
            return;
        }
        ArrayList<VirtualFile> filesToFix = new ArrayList<VirtualFile>();
        for (VirtualFile file : buildFiles) {
            GradleBuildModel moduleModel;
            if (file == null || !file.isValid() || (moduleModel = projectBuildModel2.getModuleBuildModel(file)).repositories().hasGoogleMavenRepository()) continue;
            filesToFix.add(file);
        }
        if (filesToFix.isEmpty()) {
            return;
        }
        GradleBuildModel buildModel = projectBuildModel2.getProjectBuildModel();
        if (buildModel != null && !buildModel.repositories().hasGoogleMavenRepository()) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink((List<VirtualFile>)ImmutableList.of((Object)buildModel.getVirtualFile())));
            return;
        }
        fixes.add(new AddGoogleMavenRepositoryHyperlink(filesToFix));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/UnresolvedDependenciesReporter";
                break;
            }
            case 1: 
            case 8: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBuildModel";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileMap";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedDependencies";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFiles";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/UnresolvedDependenciesReporter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeduplicationKey";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLinks";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setupNotificationData";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePackages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModuleLink";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDeduplicationKey";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLinks";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupNotificationData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePackages";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addGoogleMavenRepositoryHyperlink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

