/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.tools.idea.gradle.LibraryFilePaths;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ModuleDependenciesSetup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class AndroidModuleDependenciesSetup
extends ModuleDependenciesSetup {
    private static final Logger LOG = Logger.getInstance(AndroidModuleDependenciesSetup.class);

    AndroidModuleDependenciesSetup() {
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File artifactPath, boolean exported) {
        if (module == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(3);
        }
        if (artifactPath == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(4);
        }
        this.setUpLibraryDependency(module, modelsProvider, libraryName, scope, artifactPath, new File[]{artifactPath}, exported);
    }

    void setUpLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull File artifactPath, @NotNull File[] binaryPaths, boolean exported) {
        if (module == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(6);
        }
        if (libraryName == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(8);
        }
        if (artifactPath == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(9);
        }
        if (binaryPaths == null) {
            AndroidModuleDependenciesSetup.$$$reportNull$$$0(10);
        }
        String prefix = GradleConstants.SYSTEM_ID.getReadableName() + ": ";
        libraryName = libraryName.isEmpty() || StringUtil.startsWith((CharSequence)libraryName, (CharSequence)prefix) ? libraryName : prefix + libraryName;
        LibraryFilePaths libraryFilePaths = LibraryFilePaths.getInstance(module.getProject());
        File sourceJarPath = libraryFilePaths.findSourceJarPath(libraryName, artifactPath);
        File javadocJarPath = libraryFilePaths.findJavadocJarPath(libraryName, artifactPath);
        boolean newLibrary = false;
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library == null || !AndroidModuleDependenciesSetup.isLibraryValid(modelsProvider.getModifiableLibraryModel(library), binaryPaths, javadocJarPath, sourceJarPath)) {
            if (library != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(library.getName() + " not valid after sync.");
                }
                modelsProvider.removeLibrary(library);
            }
            library = modelsProvider.createLibrary(libraryName);
            newLibrary = true;
        }
        if (newLibrary) {
            this.updateLibraryRootTypePaths(library, OrderRootType.CLASSES, modelsProvider, binaryPaths);
            if (sourceJarPath != null) {
                this.updateLibraryRootTypePaths(library, OrderRootType.SOURCES, modelsProvider, sourceJarPath);
            }
            if (javadocJarPath != null) {
                this.updateLibraryRootTypePaths(library, JavadocOrderRootType.getInstance(), modelsProvider, javadocJarPath);
            }
            for (File binaryPath : binaryPaths) {
                File annotations;
                String pathName = binaryPath.getPath();
                if (pathName.endsWith("res") && pathName.length() > "res".length() && pathName.charAt(pathName.length() - "res".length() - 1) == File.separatorChar) {
                    annotations = new File(pathName.substring(0, pathName.length() - "res".length()), "annotations.zip");
                    if (!annotations.isFile()) continue;
                    this.updateLibraryRootTypePaths(library, AnnotationOrderRootType.getInstance(), modelsProvider, annotations);
                    continue;
                }
                if (!libraryName.startsWith("androidx.annotation:annotation", prefix.length()) && !libraryName.startsWith("com.android.support:support-annotations", prefix.length()) || !pathName.endsWith(".jar") || !(annotations = new File(pathName.substring(0, pathName.length() - ".jar".length()) + "-annotations.zip")).isFile()) continue;
                this.updateLibraryRootTypePaths(library, AnnotationOrderRootType.getInstance(), modelsProvider, annotations);
            }
        }
        this.addLibraryAsDependency(library, libraryName, scope, module, modelsProvider, exported);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "modelsProvider";
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "libraryName";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[0] = "artifactPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[0] = "binaryPaths";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidModuleDependenciesSetup";
        objectArray[2] = "setUpLibraryDependency";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

