/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.ArgsInfo;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/sync/setup/post/ModuleSetup;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myProject", "setupSteps", "", "Lcom/android/tools/idea/gradle/project/sync/setup/post/ModuleSetupStep;", "(Lcom/intellij/openapi/project/Project;[Lcom/android/tools/idea/gradle/project/sync/setup/post/ModuleSetupStep;)V", "mySetupSteps", "[Lcom/android/tools/idea/gradle/project/sync/setup/post/ModuleSetupStep;", "setUpModules", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "setupKotlinOptionsOnFacet", "module", "Lcom/intellij/openapi/module/Module;", "intellij.android.core"})
public final class ModuleSetup {
    private final ModuleSetupStep[] mySetupSteps;
    private final Project myProject;

    public final void setUpModules(@Nullable ProgressIndicator progressIndicator) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(myProject)");
        for (Module module : moduleManager.getModules()) {
            for (ModuleSetupStep setupStep : this.mySetupSteps) {
                setupStep.setUpModule(module, progressIndicator);
            }
            Module module2 = module;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            this.setupKotlinOptionsOnFacet(module2);
        }
    }

    private final void setupKotlinOptionsOnFacet(Module module) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"AndroidFacet.getInstance(module) ?: return");
        AndroidFacet facet2 = androidFacet;
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet2);
        if (androidModuleModel == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidModuleModel, (String)"AndroidModuleModel.get(facet) ?: return");
        AndroidModuleModel androidModel = androidModuleModel;
        IdeVariant ideVariant = androidModel.getSelectedVariant();
        Intrinsics.checkNotNullExpressionValue((Object)ideVariant, (String)"androidModel.selectedVariant");
        String sourceSetName = ideVariant.getName();
        if (Intrinsics.areEqual((Object)KotlinGradleSourceSetDataServiceKt.getSourceSetName((Module)module), (Object)sourceSetName)) {
            return;
        }
        Map map2 = KotlinGradleSourceSetDataServiceKt.getCompilerArgumentsBySourceSet((Module)module);
        if (map2 == null || (map2 = (ArgsInfo)map2.get(sourceSetName)) == null) {
            return;
        }
        Map argsInfo = map2;
        KotlinFacet kotlinFacet = KotlinFacet.Companion.get(module);
        if (kotlinFacet == null) {
            return;
        }
        KotlinFacet kotlinFacet2 = kotlinFacet;
        KotlinGradleSourceSetDataServiceKt.setSourceSetName((Module)module, (String)sourceSetName);
        KotlinGradleSourceSetDataServiceKt.configureFacetByCompilerArguments((KotlinFacet)kotlinFacet2, (ArgsInfo)argsInfo, null);
    }

    @VisibleForTesting
    public ModuleSetup(@NotNull Project myProject, ModuleSetupStep ... setupSteps) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)setupSteps, (String)"setupSteps");
        this.myProject = myProject;
        this.mySetupSteps = setupSteps;
    }

    public ModuleSetup(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModuleSetupStep[] moduleSetupStepArray = ModuleSetupStep.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)moduleSetupStepArray, (String)"ModuleSetupStep.getExtensions()");
        this(project, Arrays.copyOf(moduleSetupStepArray, moduleSetupStepArray.length));
    }
}

